<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

if (!defined('DC_CONTEXT_ADMIN')) { exit; }

# Local settings update
if (!empty($_POST['s']) && is_array($_POST['s']))
{
	try
	{
		foreach ($_POST['s'] as $ns => $s)
		{
			$core->blog->settings->setNameSpace($ns);
			
			foreach ($s as $k => $v) 	{
				$core->blog->settings->put($k,$v);
			}
			
			$core->blog->triggerBlog();
		}
		
		http::redirect($p_url.'&upd=1');
	}
	catch (Exception $e)
	{
		$core->error->add($e->getMessage());
	}
}

# Global settings update
if (!empty($_POST['gs']) && is_array($_POST['gs']))
{
	try
	{
		foreach ($_POST['gs'] as $ns => $s)
		{
			$core->blog->settings->setNameSpace($ns);
			
			foreach ($s as $k => $v) 	{
				$core->blog->settings->put($k,$v,null,null,true,true);
			}
			
			$core->blog->triggerBlog();
		}
		
		http::redirect($p_url.'&upd=1&part=global');
	}
	catch (Exception $e)
	{
		$core->error->add($e->getMessage());
	}
}

$part = !empty($_GET['part']) && $_GET['part'] == 'global' ? 'global' : 'local';

function settingLine($id,$s,$ns,$field_name,$strong_label)
{
	if ($s['type'] == 'boolean') {
		$field = form::combo(array($field_name.'['.$ns.']['.$id.']',$field_name.'_'.$id),
		array(__('yes') => 1, __('no') => 0),$s['value']);
	} else {
		$field = form::field(array($field_name.'['.$ns.']['.$id.']',$field_name.'_'.$id),40,null,
		html::escapeHTML($s['value']));
	}
	
	$slabel = $strong_label ? '<strong>%s</strong>' : '%s';
	
	return
	'<tr>'.
	'<td><label for="s_'.$id.'">'.sprintf($slabel,html::escapeHTML($id)).'</label></td>'.
	'<td>'.$field.'</td>'.
	'<td>'.$s['type'].'</td>'.
	'<td>'.html::escapeHTML($s['label']).'</td>'.
	'</tr>';
}
?>
<html>
<head>
  <title>about:config</title>
  <script type="text/javascript" src="js/multi-part-page.js"></script>
  <script type="text/javascript">
  //<![CDATA[
  chainHandler(window,'onload',function() {
	  new multiPartPage('<?php echo $part; ?>');
  });
  //]]>
  </script>
</head>

<body>
<?php
if (!empty($_GET['upd'])) {
	echo '<p class="message">'.__('Configuration successfully updated').'</p>';
}

if (!empty($_GET['upda'])) {
	echo '<p class="message">'.__('Settings definition successfully updated').'</p>';
}
?>
<h2><?php echo html::escapeHTML($core->blog->name); ?> &gt; about:config</h2>

<div id="local" class="multi-part" title="<?php echo __('blog settings'); ?>">
<form action="plugin.php" method="post">
<table>
<tr>
  <th class="nowrap">Setting ID</th>
  <th><?php echo __('Value'); ?></th>
  <th><?php echo __('Type'); ?></th>
  <th class="maximal"><?php echo __('Description'); ?></th>
</tr>
<?php
$settings = array();

foreach ($core->blog->settings->dumpSettings() as $k => $v) {
	$settings[$v['ns']][$k] = $v;
}

ksort($settings);

foreach ($settings as $ns => $s)
{
	ksort($s);
	echo '<tr><td colspan="4">namespace: <strong>'.$ns.'</strong></td></tr>';
	
	foreach ($s as $k => $v)
	{
		echo settingLine($k,$v,$ns,'s',!$v['global']);
	}
}
?>
</table>
<p><input type="submit" value="<?php echo __('save'); ?>" />
<input type="hidden" name="p" value="aboutConfig" /></p>
</form>
</div>

<div id="global" class="multi-part" title="<?php echo __('global settings'); ?>">
<form action="plugin.php" method="post">
<table>
<tr>
  <th class="nowrap">Setting ID</th>
  <th><?php echo __('Value'); ?></th>
  <th><?php echo __('Type'); ?></th>
  <th class="maximal"><?php echo __('Description'); ?></th>
</tr>
<?php
$settings = array();

foreach ($core->blog->settings->dumpGlobalSettings() as $k => $v) {
	$settings[$v['ns']][$k] = $v;
}

ksort($settings);

foreach ($settings as $ns => $s)
{
	ksort($s);
	echo '<tr><td colspan="4">namespace: <strong>'.$ns.'</strong></td></tr>';
	
	foreach ($s as $k => $v)
	{
		echo settingLine($k,$v,$ns,'gs',false);
	}
}
?>
</table>
<p><input type="submit" value="<?php echo __('save'); ?>" />
<input type="hidden" name="p" value="aboutConfig" /></p>
</form>
</div>

</body>
</html>