<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

if (!empty($_GET['pf'])) {
	require dirname(__FILE__).'/../load_plugin_file.php';
	exit;
}

if (!isset($_SERVER['PATH_INFO'])) {
	$_SERVER['PATH_INFO'] = '';
}

require_once dirname(__FILE__).'/../prepend.php';
require_once dirname(__FILE__).'/rs.extension.php';

# Loading blog
if (defined('DC_BLOG_ID')) {
	$core->setBlog(DC_BLOG_ID);
}

if ($core->blog->id == null) {
	header('Content-Type: text/plain');
	echo 'Blog is not defined';
	exit;
}

# Loading media
try {
	$core->media = new dcMedia($core);
} catch (Exception $e) {}

# Creating template context
$_ctx = new context();
try {
	$core->tpl = new dcTemplate(DC_TPL_CACHE,'$core->tpl',$core);
} catch (Exception $e) {
	header('Content-Type: text/plain');
	echo $e->getMessage();
	exit;
}

# Loading plugins
$core->plugins->loadModules(DC_PLUGINS_ROOT,'public');

# Loading themes
$core->themes = new dcModules($core);
$core->themes->loadModules($core->blog->themes_path);

# Loading locales
$_lang = $core->blog->settings->lang;
l10n::set(dirname(__FILE__).'/../../locales/'.$_lang.'/date');
l10n::set(dirname(__FILE__).'/../../locales/'.$_lang.'/public');
$core->plugins->loadModulesL10N($_lang,'main');

# Defining theme if not defined
if (!isset($__theme)) {
	$__theme = $core->blog->settings->theme;
}

# If theme doesn't exist, stop everything
if (!$core->themes->moduleExists($__theme)) {
	header('Content-Type: text/plain');
	echo 'Theme '.$__theme.' doesn\'t exists.';
	exit;
}

# Loading _public.php file for selected theme
$core->themes->loadNsFile($__theme,'public');

# --BEHAVIOR-- publicPrepend
$core->callBehavior('publicPrepend',$core);

# Prepare the HTTP cache thing
$mod_files = get_included_files();
$mod_ts = array();
$mod_ts[] = $core->blog->upddt;

$core->tpl->setPath(
	$core->blog->themes_path.'/'.$__theme,
	$core->blog->themes_path.'/default',
	dirname(__FILE__).'/default-templates');

$core->url->mode = $core->blog->settings->url_scan;

try {
	$core->url->getDocument();
} catch (Exception $e) {
	header('Content-Type: text/plain');
	echo 'Something went wrong: '.$e->getMessage();
	exit;
}
?>