<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

class dcTemplate extends template
{
	private $core;
	
	function __construct($cache_dir,$self_name,&$core)
	{
		parent::__construct($cache_dir,$self_name);
		
		$this->remove_php = true;
		$this->use_cache = true;
		
		$this->tag_block = '<tpl:(%1$s)(?:(\s+.*?)>|>)(.*?)</tpl:%1$s>';
		$this->tag_value = '{{tpl:(%s)(\s(.*?))?}}';
		
		$this->core =& $core;
		
		# l10n
		$this->addValue('lang',array($this,'l10n'));
		
		# Archives
		$this->addBlock('Archives',array($this,'Archives'));
		$this->addBlock('ArchivesHeader',array($this,'ArchivesHeader'));
		$this->addBlock('ArchivesFooter',array($this,'ArchivesFooter'));
		$this->addBlock('ArchivesYearHeader',array($this,'ArchivesYearHeader'));
		$this->addBlock('ArchivesYearFooter',array($this,'ArchivesYearFooter'));
		$this->addValue('ArchiveDate',array($this,'ArchiveDate'));
		$this->addBlock('ArchiveNext',array($this,'ArchiveNext'));
		$this->addBlock('ArchivePrevious',array($this,'ArchivePrevious'));
		$this->addValue('ArchiveEntriesCount',array($this,'ArchiveEntriesCount'));
		$this->addValue('ArchiveURL',array($this,'ArchiveURL'));
		
		# Attachments
		$this->addBlock('Attachments',array($this,'Attachments'));
		$this->addBlock('AttachmentsHeader',array($this,'AttachmentsHeader'));
		$this->addBlock('AttachmentsFooter',array($this,'AttachmentsFooter'));
		$this->addValue('AttachmentMimeType',array($this,'AttachmentMimeType'));
		$this->addValue('AttachmentType',array($this,'AttachmentType'));
		$this->addValue('AttachmentFileName',array($this,'AttachmentFileName'));
		$this->addValue('AttachmentSize',array($this,'AttachmentSize'));
		$this->addValue('AttachmentTitle',array($this,'AttachmentTitle'));
		$this->addValue('AttachmentThumbnailURL',array($this,'AttachmentThumbnailURL'));
		$this->addValue('AttachmentURL',array($this,'AttachmentURL'));
		$this->addBlock('AttachmentIf',array($this,'AttachmentIf'));
		
		# Blog
		$this->addValue('BlogArchiveURL',array($this,'BlogArchiveURL'));
		$this->addValue('BlogCopyrightNotice',array($this,'BlogCopyrightNotice'));
		$this->addValue('BlogDescription',array($this,'BlogDescription'));
		$this->addValue('BlogEditor',array($this,'BlogEditor'));
		$this->addValue('BlogFeedID',array($this,'BlogFeedID'));
		$this->addValue('BlogFeedURL',array($this,'BlogFeedURL'));
		$this->addValue('BlogRSDURL',array($this,'BlogRSDURL'));
		$this->addValue('BlogName',array($this,'BlogName'));
		$this->addValue('BlogLanguage',array($this,'BlogLanguage'));
		$this->addValue('BlogThemeURL',array($this,'BlogThemeURL'));
		$this->addValue('BlogUpdateDate',array($this,'BlogUpdateDate'));
		$this->addValue('BlogURL',array($this,'BlogURL'));
		
		# Categories
		$this->addBlock('Categories',array($this,'Categories'));
		$this->addBlock('CategoriesHeader',array($this,'CategoriesHeader'));
		$this->addBlock('CategoriesFooter',array($this,'CategoriesFooter'));
		$this->addValue('CategoryFeedURL',array($this,'CategoryFeedURL'));
		$this->addValue('CategoryURL',array($this,'CategoryURL'));
		$this->addValue('CategoryDescription',array($this,'CategoryDescription'));
		$this->addValue('CategoryTitle',array($this,'CategoryTitle'));
		
		# Comments
		$this->addBlock('Comments',array($this,'Comments'));
		$this->addValue('CommentAuthor',array($this,'CommentAuthor'));
		$this->addValue('CommentAuthorLink',array($this,'CommentAuthorLink'));
		$this->addValue('CommentAuthorURL',array($this,'CommentAuthorURL'));
		$this->addValue('CommentContent',array($this,'CommentContent'));
		$this->addValue('CommentDate',array($this,'CommentDate'));
		$this->addValue('CommentTime',array($this,'CommentTime'));
		$this->addValue('CommentEmail',array($this,'CommentEmail'));
		$this->addValue('CommentEntryTitle',array($this,'CommentEntryTitle'));
		$this->addValue('CommentFeedID',array($this,'CommentFeedID'));
		$this->addValue('CommentID',array($this,'CommentID'));
		$this->addBlock('CommentIf',array($this,'CommentIf'));
		$this->addValue('CommentIfFirst',array($this,'CommentIfFirst'));
		$this->addValue('CommentIfMe',array($this,'CommentIfMe'));
		$this->addValue('CommentIfOdd',array($this,'CommentIfOdd'));
		$this->addValue('CommentIP',array($this,'CommentIP'));
		$this->addValue('CommentOrderNumber',array($this,'CommentOrderNumber'));
		$this->addBlock('CommentsFooter',array($this,'CommentsFooter'));
		$this->addBlock('CommentsHeader',array($this,'CommentsHeader'));
		$this->addValue('CommentPostURL',array($this,'CommentPostURL'));
		$this->addBlock('IfCommentAuthorEmail',array($this,'IfCommentAuthorEmail'));
		
		# Comment preview
		$this->addBlock('IfCommentPreview',array($this,'IfCommentPreview'));
		$this->addValue('CommentPreviewName',array($this,'CommentPreviewName'));
		$this->addValue('CommentPreviewEmail',array($this,'CommentPreviewEmail'));
		$this->addValue('CommentPreviewSite',array($this,'CommentPreviewSite'));
		$this->addValue('CommentPreviewContent',array($this,'CommentPreviewContent'));
		$this->addValue('CommentPreviewCheckRemember',array($this,'CommentPreviewCheckRemember'));
		
		# Entries
		$this->addBlock('DateFooter',array($this,'DateFooter'));
		$this->addBlock('DateHeader',array($this,'DateHeader'));
		$this->addBlock('Entries',array($this,'Entries'));
		$this->addBlock('EntriesFooter',array($this,'EntriesFooter'));
		$this->addBlock('EntriesHeader',array($this,'EntriesHeader'));
		$this->addValue('EntryExcerpt',array($this,'EntryExcerpt'));
		$this->addValue('EntryAttachmentCount',array($this,'EntryAttachmentCount'));
		$this->addValue('EntryAuthorCommonName',array($this,'EntryAuthorCommonName'));
		$this->addValue('EntryAuthorDisplayName',array($this,'EntryAuthorDisplayName'));
		$this->addValue('EntryAuthorEmail',array($this,'EntryAuthorEmail'));
		$this->addValue('EntryAuthorID',array($this,'EntryAuthorID'));
		$this->addValue('EntryAuthorLink',array($this,'EntryAuthorLink'));
		$this->addValue('EntryAuthorURL',array($this,'EntryAuthorURL'));
		$this->addValue('EntryBasename',array($this,'EntryBasename'));
		$this->addValue('EntryCategory',array($this,'EntryCategory'));
		$this->addValue('EntryCategoryID',array($this,'EntryCategoryID'));
		$this->addValue('EntryCategoryURL',array($this,'EntryCategoryURL'));
		$this->addValue('EntryCommentCount',array($this,'EntryCommentCount'));
		$this->addValue('EntryContent',array($this,'EntryContent'));
		$this->addValue('EntryDate',array($this,'EntryDate'));
		$this->addValue('EntryFeedID',array($this,'EntryFeedID'));
		$this->addValue('EntryID',array($this,'EntryID'));
		$this->addBlock('EntryIf',array($this,'EntryIf'));
		$this->addValue('EntryIfFirst',array($this,'EntryIfFirst'));
		$this->addValue('EntryIfOdd',array($this,'EntryIfOdd'));
		$this->addValue('EntryLang',array($this,'EntryLang'));
		$this->addBlock('EntryNext',array($this,'EntryNext'));
		$this->addBlock('EntryPrevious',array($this,'EntryPrevious'));
		$this->addValue('EntryTitle',array($this,'EntryTitle'));
		$this->addValue('EntryTime',array($this,'EntryTime'));
		$this->addValue('EntryTrackbackCount',array($this,'EntryTrackbackCount'));
		$this->addValue('EntryTrackbackData',array($this,'EntryTrackbackData'));
		$this->addValue('EntryTrackbackLink',array($this,'EntryTrackbackLink'));
		$this->addValue('EntryURL',array($this,'EntryURL'));
		
		# Languages
		$this->addBlock('Languages',array($this,'Languages'));
		$this->addBlock('LanguagesHeader',array($this,'LanguagesHeader'));
		$this->addBlock('LanguagesFooter',array($this,'LanguagesFooter'));
		$this->addValue('LanguageCode',array($this,'LanguageCode'));
		$this->addBlock('LanguageIfCurrent',array($this,'LanguageIfCurrent'));
		$this->addValue('LanguageURL',array($this,'LanguageURL'));
		
		# Pagination
		$this->addBlock('Pagination',array($this,'Pagination'));
		$this->addValue('PaginationCounter',array($this,'PaginationCounter'));
		$this->addValue('PaginationCurrent',array($this,'PaginationCurrent'));
		$this->addBlock('PaginationIf',array($this,'PaginationIf'));
		$this->addValue('PaginationURL',array($this,'PaginationURL'));
		
		# Trackbacks
		$this->addValue('PingBlogName',array($this,'PingBlogName'));
		$this->addValue('PingContent',array($this,'PingContent'));
		$this->addValue('PingDate',array($this,'PingDate'));
		$this->addValue('PingEntryTitle',array($this,'PingEntryTitle'));
		$this->addValue('PingFeedID',array($this,'PingFeedID'));
		$this->addValue('PingID',array($this,'PingID'));
		$this->addValue('PingIfFirst',array($this,'PingIfFirst'));
		$this->addValue('PingIfOdd',array($this,'PingIfOdd'));
		$this->addValue('PingIP',array($this,'PingIP'));
		$this->addValue('PingNoFollow',array($this,'PingNoFollow'));
		$this->addValue('PingOrderNumber',array($this,'PingOrderNumber'));
		$this->addValue('PingPostURL',array($this,'PingPostURL'));
		$this->addBlock('Pings',array($this,'Pings'));
		$this->addBlock('PingsFooter',array($this,'PingsFooter'));
		$this->addBlock('PingsHeader',array($this,'PingsHeader'));
		$this->addValue('PingTime',array($this,'PingTime'));
		$this->addValue('PingTitle',array($this,'PingTitle'));
		$this->addValue('PingAuthorURL',array($this,'PingAuthorURL'));
		
		# System
		$this->addBlock('SysIf',array($this,'SysIf'));
		$this->addBlock('SysIfCommentPublished',array($this,'SysIfCommentPublished'));
		$this->addBlock('SysIfCommentPending',array($this,'SysIfCommentPending'));
		$this->addBlock('SysIfFormError',array($this,'SysIfFormError'));
		$this->addValue('SysFeedSubtitle',array($this,'SysFeedSubtitle'));
		$this->addValue('SysFormError',array($this,'SysFormError'));
		$this->addValue('SysSearchString',array($this,'SysSearchString'));
		$this->addValue('SysSelfURI',array($this,'SysSelfURI'));
	}
	
	protected function compileBlock($match)
	{
		$b = $match[1];
		$content = $match[3];
		$attr = $this->getAttrs($match[2]);
		
		# --BEHAVIOR-- templateBeforeBlock
		$res = $this->core->callBehavior('templateBeforeBlock',$this->core,$b,$attr);
		
		$res .= parent::compileBlock($match);
		
		return $res;
	}
	
	protected function compileValue($match)
	{
		$v = $match[1];
		$attr = isset($match[2]) ? $this->getAttrs($match[2]) : array();
		$str_attr = isset($match[2]) ? $match[2] : null;
		
		# --BEHAVIOR-- templateBeforeValue
		$res = $this->core->callBehavior('templateBeforeValue',$this->core,$v,$attr);
		
		$res = parent::compileValue($match);
		
		return $res;
	}
	
	public function getFilters($attr)
	{
		$p[0] = '0';	# encode_xml
		$p[1] = '0';	# remove_html
		$p[2] = '0';	# cut_string
		$p[3] = '0';	# lower_case
		$p[4] = '0';	# upper_case
		
		$p[0] = (integer) (!empty($attr['encode_xml']) || !empty($attr['encode_html']));
		$p[1] = (integer) !empty($attr['remove_html']);
		
		if (!empty($attr['cut_string']) && (integer) $attr['cut_string'] > 0) {
			$p[2] = (integer) $attr['cut_string'];
		}
		
		$p[3] = (integer) !empty($attr['lower_case']);
		$p[4] = (integer) !empty($attr['upper_case']);
		
		return "context::global_filter(%s,".implode(",",$p).")";
	}
	
	
	/* TEMPLATE FUNCTIONS
	------------------------------------------------------- */
	
	public function l10n($attr,$str_attr)
	{
		# Normalize content
		$str_attr = preg_replace('/\s+/x',' ',$str_attr);
		
		return "<?php echo __('".str_replace("'","\\'",$str_attr)."'); ?>";
	}
	
	/* Archives ------------------------------------------- */
	public function Archives($attr,$content)
	{
		$p = '$params = array();';
		$p .= "\$params['type'] = 'month';\n";
		if (isset($attr['type'])) {
			$p .= "\$params['type'] = '".addslashes($attr['type'])."';\n";
		}
		
		if (isset($attr['category'])) {
			$p .= "\$params['cat_url'] = '".addslashes($attr['category'])."';\n";
		}
		
		$p .=
		'if ($_ctx->exists("categories")) { '.
			"\$params['cat_id'] = \$_ctx->categories->cat_id; ".
		"}\n";
		
		$order = 'desc';
		if (isset($attr['order']) && preg_match('/^(desc|asc)$/i',$attr['order'])) {
			$p .= "\$params['order'] = '".$attr['order']."';\n ";
		}
		
		$res = "<?php\n";
		$res .= $p;
		$res .= '$_ctx->archives = $core->blog->getDates($params); unset($params);'."\n";
		$res .= "?>\n";
		
		$res .=
		'<?php while ($_ctx->archives->fetch()) : ?>'.$content.'<?php endwhile; $_ctx->archives = null; ?>';
		
		return $res;
	}
	
	public function ArchivesHeader($attr,$content)
	{
		return
		"<?php if (\$_ctx->archives->isStart()) : ?>".
		$content.
		"<?php endif; ?>";
	}
	
	public function ArchivesFooter($attr,$content)
	{
		return
		"<?php if (\$_ctx->archives->isEnd()) : ?>".
		$content.
		"<?php endif; ?>";
	}
	
	public function ArchivesYearHeader($attr,$content)
	{
		return
		"<?php if (\$_ctx->archives->yearHeader()) : ?>".
		$content.
		"<?php endif; ?>";
	}
	
	public function ArchivesYearFooter($attr,$content)
	{
		return
		"<?php if (\$_ctx->archives->yearFooter()) : ?>".
		$content.
		"<?php endif; ?>";
	}
	
	public function ArchiveDate($attr)
	{
		$format = '%B %Y';
		if (!empty($attr['format'])) {
			$format = addslashes($attr['format']);
		}
		
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,"dt::dt2str('".$format."',\$_ctx->archives->dt)").'; ?>';
	}
	
	public function ArchiveEntriesCount($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->archives->nb_post').'; ?>';
	}
	
	public function ArchiveNext($attr,$content)
	{
		$p = '$params = array();';
		$p .= "\$params['type'] = 'month';\n";
		if (isset($attr['type'])) {
			$p .= "\$params['type'] = '".addslashes($attr['type'])."';\n";
		}
		
		$p .= "\$params['next'] = \$_ctx->archives->dt;";
		
		$res = "<?php\n";
		$res .= $p;
		$res .= '$_ctx->archives = $core->blog->getDates($params); unset($params);'."\n";
		$res .= "?>\n";
		
		$res .=
		'<?php while ($_ctx->archives->fetch()) : ?>'.$content.'<?php endwhile; $_ctx->archives = null; ?>';
		
		return $res;
	}
	
	public function ArchivePrevious($attr,$content)
	{
		$p = '$params = array();';
		$p .= "\$params['type'] = 'month';\n";
		if (isset($attr['type'])) {
			$p .= "\$params['type'] = '".addslashes($attr['type'])."';\n";
		}
		
		$p .= "\$params['previous'] = \$_ctx->archives->dt;";
		
		$res = "<?php\n";
		$res .= $p;
		$res .= '$_ctx->archives = $core->blog->getDates($params); unset($params);'."\n";
		$res .= "?>\n";
		
		$res .=
		'<?php while ($_ctx->archives->fetch()) : ?>'.$content.'<?php endwhile; $_ctx->archives = null; ?>';
		
		return $res;
	}
	
	public function ArchiveURL($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->archives->url($core)').'; ?>';
	}
	
	/* Attachments ---------------------------------------- */
	public function Attachments($attr,$content)
	{
		$res =
		"<?php\n".
		'if ($_ctx->posts !== null && $core->media) {'."\n".
			'$_ctx->attachments = $core->media->getPostMedia($_ctx->posts->post_id);'."\n".
		"?>\n".
		
		'<?php foreach ($_ctx->attachments as $attach_i => $attach_f) : '.
		'$GLOBALS[\'attach_i\'] = $attach_i; $GLOBALS[\'attach_f\'] = $attach_f; ?>'.
		$content.
		'<?php endforeach; $_ctx->attachments = null; unset($attach_id); unset($attach_f); ?>'.
		
		"<?php } ?>\n";
		
		return $res;
	}
	
	public function AttachmentsHeader($attr,$content)
	{
		return
		"<?php if (\$attach_i == 0) : ?>".
		$content.
		"<?php endif; ?>";
	}
	
	public function AttachmentsFooter($attr,$content)
	{
		return
		"<?php if (\$attach_i+1 == count(\$_ctx->attachments)) : ?>".
		$content.
		"<?php endif; ?>";
	}
	
	public function AttachmentIf($attr,$content)
	{
		$if = array();
		
		if (isset($attr['is_image'])) {
			$sign = (boolean) $attr['is_image'] ? '' : '!';
			$if[] = $sign.'$attach_f->media_image';
		}
		
		if (isset($attr['has_thumb'])) {
			$sign = (boolean) $attr['has_thumb'] ? '' : '!';
			$if[] = $sign.'isset($attach_f->media_thumb[\'sq\'])';
		}
		
		if (isset($attr['is_mp3'])) {
			$sign = (boolean) $attr['is_mp3'] ? '' : '!';
			$if[] = $sign.'$attach_f->type == "audio/mpeg3"';
		}
		
		if (!empty($if)) {
			return '<?php if('.implode(' && ',$if).') : ?>'.$content.'<?php endif; ?>';
		} else {
			return $content;
		}
	}
	
	public function AttachmentMimeType($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$attach_f->type').'; ?>';
	}
	
	public function AttachmentType($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$attach_f->media_type').'; ?>';
	}
	
	public function AttachmentFileName($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$attach_f->basename').'; ?>';
	}
	
	public function AttachmentSize($attr)
	{
		$f = $this->getFilters($attr);
		if (!empty($attr['full'])) {
			return '<?php echo '.sprintf($f,'$attach_f->size').'; ?>';
		}
		return '<?php echo '.sprintf($f,'files::size($attach_f->size)').'; ?>';
	}
	
	public function AttachmentTitle($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$attach_f->media_title').'; ?>';
	}
	
	public function AttachmentThumbnailURL($attr)
	{
		$f = $this->getFilters($attr);
		return
		'<?php '.
		'if (isset($attach_f->media_thumb[\'sq\'])) {'.
			'echo '.sprintf($f,'$attach_f->media_thumb[\'sq\']').';'.
		'}'.
		'?>';
	}
	
	public function AttachmentURL($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$attach_f->file_url').'; ?>';
	}
	
	
	/* Blog ----------------------------------------------- */
	public function BlogArchiveURL($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$core->blog->url.$core->url->getBase("archive")').'; ?>';
	}
	
	public function BlogCopyrightNotice($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$core->blog->settings->copyright_notice').'; ?>';
	}
	
	public function BlogDescription($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$core->blog->desc').'; ?>';
	}
	
	public function BlogEditor($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$core->blog->settings->editor').'; ?>';
	}
	
	public function BlogFeedID($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'"urn:md5:".$core->blog->uid').'; ?>';
	}
	
	public function BlogFeedURL($attr)
	{
		$type = !empty($attr['type']) ? $attr['type'] : 'rss2';
		
		if (!preg_match('#^(rss2|atom)$#',$type)) {
			$type = 'rss2';
		}
		
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$core->blog->url.$core->url->getBase("feed")."/'.$type.'"').'; ?>';
	}
	
	public function BlogName($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$core->blog->name').'; ?>';
	}
	
	public function BlogLanguage($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$core->blog->settings->lang').'; ?>';
	}
	
	public function BlogThemeURL($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$core->blog->settings->themes_url."/".$core->blog->settings->theme').'; ?>';
	}
	
	public function BlogUpdateDate($attr)
	{
		$format = '';
		if (!empty($attr['format'])) {
			$format = addslashes($attr['format']);
		} else {
			$format = '%Y-%m-%d %H:%M:%S';
		}
		
		$iso8601 = !empty($attr['iso8601']);
		$rfc822 = !empty($attr['rfc822']);
		
		$f = $this->getFilters($attr);
		
		if ($rfc822) {
			return '<?php echo '.sprintf($f,"dt::rfc822(\$core->blog->upddt,\$core->blog->settings->blog_timezone)").'; ?>';
		} elseif ($iso8601) {
			return '<?php echo '.sprintf($f,"dt::iso8601(\$core->blog->upddt,\$core->blog->settings->blog_timezone)").'; ?>';
		} else {
			return '<?php echo '.sprintf($f,"dt::str('".$format."',\$core->blog->upddt)").'; ?>';
		}
	}
	
	public function BlogRSDURL($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$core->blog->url.$core->url->getBase(\'rsd\')').'; ?>';
	}
	
	public function BlogURL($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$core->blog->url').'; ?>';
	}
	
	
	/* Categories ----------------------------------------- */
	public function Categories($attr,$content)
	{
		$res = "<?php\n";
		$res .= '$_ctx->categories = $core->blog->getCategories();'."\n";
		$res .= "?>\n";
		
		$res .=
		'<?php while ($_ctx->categories->fetch()) : ?>'.$content.'<?php endwhile; $_ctx->categories = null; ?>';
		
		return $res;
	}
	
	public function CategoriesHeader($attr,$content)
	{
		return
		"<?php if (\$_ctx->categories->isStart()) : ?>".
		$content.
		"<?php endif; ?>";
	}
	
	public function CategoriesFooter($attr,$content)
	{
		return
		"<?php if (\$_ctx->categories->isEnd()) : ?>".
		$content.
		"<?php endif; ?>";
	}
	
	public function CategoryFeedURL($attr)
	{
		$type = !empty($attr['type']) ? $attr['type'] : 'rss2';
		
		if (!preg_match('#^(rss2|atom)$#',$type)) {
			$type = 'rss2';
		}
		
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$core->blog->url.$core->url->getBase("feed")."/category/".'.
		'$_ctx->categories->cat_url."/'.$type.'"').'; ?>';
	}
	
	public function CategoryURL($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$core->blog->url.$core->url->getBase("category")."/".$_ctx->categories->cat_url').'; ?>';
	}
	
	public function CategoryDescription($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->categories->cat_desc').'; ?>';
	}
	
	public function CategoryTitle($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->categories->cat_title').'; ?>';
	}
	
	/* Entries -------------------------------------------- */
	public function Entries($attr,$content)
	{
		$lastn = 0;
		if (isset($attr['lastn'])) {
			$lastn = abs((integer) $attr['lastn'])+0;
		}
		
		$p = 'if (!isset($_page_number)) { $_page_number = 1; }'."\n";
		
		if ($lastn > 0) {
			$p .= "\$params['limit'] = ".$lastn.";\n";
		} else {
			$p .= "\$params['limit'] = \$core->blog->settings->nb_post_per_page;\n";
		}
		
		$p .= "\$params['limit'] = array(((\$_page_number-1)*\$params['limit']),\$params['limit']);\n";
		
		if (isset($attr['author'])) {
			$p .= "\$params['user_id'] = '".addslashes($attr['author'])."';\n";
		}
		
		if (isset($attr['category'])) {
			$p .= "\$params['cat_url'] = '".addslashes($attr['category'])."';\n";
			$p .= "context::categoryPostParam(\$params);\n";
		}
		
		$p .=
		'if ($_ctx->exists("users")) { '.
			"\$params['user_id'] = \$_ctx->users->user_id; ".
		"}\n";
		
		$p .=
		'if ($_ctx->exists("categories")) { '.
			"\$params['cat_id'] = \$_ctx->categories->cat_id; ".
		"}\n";
		
		$p .=
		'if ($_ctx->exists("archives")) { '.
			"\$params['post_year'] = \$_ctx->archives->year(); ".
			"\$params['post_month'] = \$_ctx->archives->month(); ".
			"unset(\$params['limit']); ".
		"}\n";
		
		$p .=
		'if ($_ctx->exists("langs")) { '.
			"\$params['post_lang'] = \$_ctx->langs->post_lang; ".
		"}\n";
		
		$p .=
		'if (isset($_search)) { '.
			"\$params['search'] = \$_search; ".
		"}\n";
		
		$sortby = 'post_dt';
		$order = 'desc';
		if (isset($attr['sortby'])) {
			switch ($attr['sortby']) {
				case 'title': $sortby = 'post_title'; break;
				case 'selected' : $sortby = 'post_selected'; break;
				case 'author' : $sortby = 'user_id'; break;
				case 'date' : $sortby = 'post_dt'; break;
			}
		}
		if (isset($attr['order']) && preg_match('/^(desc|asc)$/i',$attr['order'])) {
			$order = $attr['order'];
		}
		
		$p .= "\$params['order'] = '".$sortby." ".$order."';\n";
		
		if (isset($attr['no_content']) && $attr['no_content']) {
			$p .= "\$params['no_content'] = true;\n";
		}
		
		if (isset($attr['selected'])) {
			$p .= "\$params['post_selected'] = ".(integer) (boolean) $attr['selected'].";";
		}
		
		$res = "<?php\n";
		$res .= $p;
		$res .= '$_ctx->post_params = $params;'."\n";
		$res .= '$_ctx->posts = $core->blog->getPosts($params); unset($params);'."\n";
		$res .= "?>\n";
		
		$res .=
		'<?php while ($_ctx->posts->fetch()) : ?>'.$content.'<?php endwhile; '.
		'$_ctx->posts = null; $_ctx->post_params = null; ?>';
		
		return $res;
	}
	
	public function DateHeader($attr,$content)
	{
		return
		"<?php if (\$_ctx->posts->firstPostOfDay()) : ?>".
		$content.
		"<?php endif; ?>";
	}
	
	public function DateFooter($attr,$content)
	{
		return
		"<?php if (\$_ctx->posts->lastPostOfDay()) : ?>".
		$content.
		"<?php endif; ?>";
	}
	
	public function EntryIf($attr,$content)
	{
		$if = array();
		$extended = null;
		$hascategory = null;
		
		if (isset($attr['extended'])) {
			$sign = (boolean) $attr['extended'] ? '' : '!';
			$if[] = $sign.'$_ctx->posts->isExtended()';
		}
		
		if (isset($attr['has_category'])) {
			$sign = (boolean) $attr['has_category'] ? '' : '!';
			$if[] = $sign.'$_ctx->posts->cat_id';
		}
		
		if (isset($attr['has_attachment'])) {
			$sign = (boolean) $attr['has_attachment'] ? '' : '!';
			$if[] = $sign.'$_ctx->posts->nb_media';
		}
		
		if (isset($attr['comments_active'])) {
			$sign = (boolean) $attr['comments_active'] ? '' : '!';
			$if[] = $sign.'$_ctx->posts->commentsActive()';
		}
		
		if (isset($attr['pings_active'])) {
			$sign = (boolean) $attr['pings_active'] ? '' : '!';
			$if[] = $sign.'$_ctx->posts->trackbacksActive()';
		}
		
		if (isset($attr['show_comments'])) {
			if ((boolean) $attr['show_comments']) {
				$if[] = '($_ctx->posts->hasComments() || $_ctx->posts->commentsActive())';
			} else {
				$if[] = '(!$_ctx->posts->hasComments() && !$_ctx->posts->commentsActive())';
			}
		}
		
		if (isset($attr['show_pings'])) {
			if ((boolean) $attr['show_pings']) {
				$if[] = '($_ctx->posts->hasTrackbacks() || $_ctx->posts->trackbacksActive())';
			} else {
				$if[] = '(!$_ctx->posts->hasTrackbacks() && !$_ctx->posts->trackbacksActive())';
			}
		}
		
		if (!empty($if)) {
			return '<?php if('.implode(' && ',$if).') : ?>'.$content.'<?php endif; ?>';
		} else {
			return $content;
		}
	}
	
	public function EntryIfFirst($attr)
	{
		$ret = isset($attr['return']) ? $attr['return'] : 'first';
		$ret = html::escapeHTML($ret);
		
		return
		'<?php if ($_ctx->posts->index() == 0) { '.
		"echo '".addslashes($ret)."'; } ?>";
	}
	
	public function EntryIfOdd($attr)
	{
		$ret = isset($attr['return']) ? $attr['return'] : 'odd';
		$ret = html::escapeHTML($ret);
		
		return
		'<?php if (($_ctx->posts->index()+1)%2) { '.
		"echo '".addslashes($ret)."'; } ?>";
	}
	
	public function EntryContent($attr)
	{
		$urls = '0';
		if (!empty($attr['absolute_urls'])) {
			$urls = '1';
		}
		
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->posts->getContent('.$urls.')').'; ?>';
	}
	
	public function EntryExcerpt($attr)
	{
		$urls = '0';
		if (!empty($attr['absolute_urls'])) {
			$urls = '1';
		}
		
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->posts->getExcerpt('.$urls.')').'; ?>';
	}
	
	public function EntryAttachmentCount($attr)
	{
		$none = 'no attachment';
		$one = 'one attachment';
		$more = '%d attachments';
		
		if (isset($attr['none'])) {
			$none = addslashes($attr['none']);
		}
		if (isset($attr['one'])) {
			$one = addslashes($attr['one']);
		}
		if (isset($attr['more'])) {
			$more = addslashes($attr['more']);
		}
		
		return
		"<?php if (\$_ctx->posts->nb_media == 0) {\n".
		"  printf(__('".$none."'),(integer) \$_ctx->posts->nb_media);\n".
		"} elseif (\$_ctx->posts->nb_media == 1) {\n".
		"  printf(__('".$one."'),(integer) \$_ctx->posts->nb_media);\n".
		"} else {\n".
		"  printf(__('".$more."'),(integer) \$_ctx->posts->nb_media);\n".
		"} ?>";
	}
	
	public function EntryAuthorCommonName($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->posts->getAuthorCN()').'; ?>';
	}
	
	public function EntryAuthorDisplayName($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->posts->user_displayname').'; ?>';
	}
	
	public function EntryAuthorID($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->posts->user_id').'; ?>';
	}
	
	public function EntryAuthorEmail($attr)
	{
		$p = 'true';
		if (isset($attr['spam_protected']) && !$attr['spam_protected']) {
			$p = 'false';
		}
		
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,"\$_ctx->posts->getAuthorEmail(".$p.")").'; ?>';
	}
	
	public function EntryAuthorLink($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->posts->getAuthorLink()').'; ?>';
	}
	
	public function EntryAuthorURL($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->posts->user_url').'; ?>';
	}
	
	public function EntryBasename($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->posts->post_url').'; ?>';
	}
	
	public function EntryCategory($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->posts->cat_title').'; ?>';
	}
	
	public function EntryCategoryID($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->posts->cat_id').'; ?>';
	}
	
	public function EntryCategoryURL($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->posts->getCategoryURL()').'; ?>';
	}
	
	public function EntryFeedID($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->posts->getFeedID()').'; ?>';
	}
	
	public function EntryID($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->posts->post_id').'; ?>';
	}
	
	public function EntryLang($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->posts->post_lang').'; ?>';
	}
	
	public function EntryNext($attr,$content)
	{
		return
		'<?php $next_post = $core->blog->getNextPost(strtotime($_ctx->posts->post_dt),1); ?>'."\n".
		'<?php if ($next_post !== null) : ?>'.
			
			'<?php $_ctx->posts = $next_post; unset($next_post);'."\n".
			'while ($_ctx->posts->fetch()) : ?>'.
			$content.
			'<?php endwhile; $_ctx->posts = null; ?>'.
		"<?php endif; ?>\n";
	}
	
	public function EntryPrevious($attr,$content)
	{
		return
		'<?php $prev_post = $core->blog->getNextPost(strtotime($_ctx->posts->post_dt),-1); ?>'."\n".
		'<?php if ($prev_post !== null) : ?>'.
			
			'<?php $_ctx->posts = $prev_post; unset($prev_post);'."\n".
			'while ($_ctx->posts->fetch()) : ?>'.
			$content.
			'<?php endwhile; $_ctx->posts = null; ?>'.
		"<?php endif; ?>\n";
	}
	
	public function EntryTitle($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->posts->post_title').'; ?>';
	}
	
	public function EntryURL($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->posts->getURL()').'; ?>';
	}
	
	public function EntryDate($attr)
	{
		$format = '';
		if (!empty($attr['format'])) {
			$format = addslashes($attr['format']);
		}
		
		$iso8601 = !empty($attr['iso8601']);
		$rfc822 = !empty($attr['rfc822']);
		
		$f = $this->getFilters($attr);
		
		if ($rfc822) {
			return '<?php echo '.sprintf($f,"\$_ctx->posts->getRFC822Date()").'; ?>';
		} elseif ($iso8601) {
			return '<?php echo '.sprintf($f,"\$_ctx->posts->getISO8601Date()").'; ?>';
		} else {
			return '<?php echo '.sprintf($f,"\$_ctx->posts->getDate('".$format."')").'; ?>';
		}
	}
	
	public function EntryTime($attr)
	{
		$format = '';
		if (!empty($attr['format'])) {
			$format = addslashes($attr['format']);
		}
		
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,"\$_ctx->posts->getTime('".$format."')").'; ?>';
	}
	
	public function EntriesHeader($attr,$content)
	{
		return
		"<?php if (\$_ctx->posts->isStart()) : ?>".
		$content.
		"<?php endif; ?>";
	}
	
	public function EntriesFooter($attr,$content)
	{
		return
		"<?php if (\$_ctx->posts->isEnd()) : ?>".
		$content.
		"<?php endif; ?>";
	}
	
	public function EntryCommentCount($attr)
	{
		$none = 'no comment';
		$one = 'one comment';
		$more = '%d comments';
		
		if (isset($attr['none'])) {
			$none = addslashes($attr['none']);
		}
		if (isset($attr['one'])) {
			$one = addslashes($attr['one']);
		}
		if (isset($attr['more'])) {
			$more = addslashes($attr['more']);
		}
		
		return
		"<?php if (\$_ctx->posts->nb_comment == 0) {\n".
		"  printf(__('".$none."'),(integer) \$_ctx->posts->nb_comment);\n".
		"} elseif (\$_ctx->posts->nb_comment == 1) {\n".
		"  printf(__('".$one."'),(integer) \$_ctx->posts->nb_comment);\n".
		"} else {\n".
		"  printf(__('".$more."'),(integer) \$_ctx->posts->nb_comment);\n".
		"} ?>";
	}
	
	public function EntryTrackbackCount($attr)
	{
		$none = 'no trackback';
		$one = 'one trackback';
		$more = '%d trackbacks';
		
		if (isset($attr['none'])) {
			$none = addslashes($attr['none']);
		}
		if (isset($attr['one'])) {
			$one = addslashes($attr['one']);
		}
		if (isset($attr['more'])) {
			$more = addslashes($attr['more']);
		}
		
		return
		"<?php if (\$_ctx->posts->nb_trackback == 0) {\n".
		"  printf(__('".$none."'),(integer) \$_ctx->posts->nb_trackback);\n".
		"} elseif (\$_ctx->posts->nb_trackback == 1) {\n".
		"  printf(__('".$one."'),(integer) \$_ctx->posts->nb_trackback);\n".
		"} else {\n".
		"  printf(__('".$more."'),(integer) \$_ctx->posts->nb_trackback);\n".
		"} ?>";
	}
	
	public function EntryTrackbackData($attr)
	{
		return "<?php if (\$_ctx->posts->trackbacksActive()) { echo \$_ctx->posts->getTrackbackData(); } ?>\n";
	}
	
	public function EntryTrackbackLink($attr)
	{
		return "<?php if (\$_ctx->posts->trackbacksActive()) { echo \$_ctx->posts->getTrackbackLink(); } ?>\n";
	}
	
	/* Languages -------------------------------------- */
	public function Languages($attr,$content)
	{
		$p = '$params = array();';
		
		if (isset($attr['lang'])) {
			$p = "\$params['lang'] = '".addslashes($attr['lang'])."';\n";
		}
		
		$order = 'desc';
		if (isset($attr['order']) && preg_match('/^(desc|asc)$/i',$attr['order'])) {
			$p .= "\$params['order'] = '".$attr['order']."';\n ";
		}
		
		$res = "<?php\n";
		$res .= $p;
		$res .= '$_ctx->langs = $core->blog->getLangs($params); unset($params);'."\n";
		$res .= "?>\n";
		
		$res .=
		'<?php if ($_ctx->langs->count() > 1) : '.
		'while ($_ctx->langs->fetch()) : ?>'.$content.
		'<?php endwhile; $_ctx->langs = null; endif; ?>';
		
		return $res;
	}
	
	public function LanguagesHeader($attr,$content)
	{
		return
		"<?php if (\$_ctx->langs->isStart()) : ?>".
		$content.
		"<?php endif; ?>";
	}
	
	public function LanguagesFooter($attr,$content)
	{
		return
		"<?php if (\$_ctx->langs->isEnd()) : ?>".
		$content.
		"<?php endif; ?>";
	}
	
	public function LanguageCode($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->langs->post_lang').'; ?>';
	}
	
	public function LanguageIfCurrent($attr,$content)
	{
		return
		"<?php if (\$_ctx->cur_lang == \$_ctx->langs->post_lang) : ?>".
		$content.
		"<?php endif; ?>";
	}
	
	public function LanguageURL($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$core->blog->url.$core->url->getBase("lang").$_ctx->langs->post_lang').'; ?>';
	}
	
	/* Pagination ------------------------------------- */
	public function Pagination($attr,$content)
	{
		$p = "<?php\n";
		$p .= '$params = $_ctx->post_params;'."\n";
		$p .= '$_ctx->pagination = $core->blog->getPosts($params,true); unset($params);'."\n";
		$p .= "?>\n";
		
		return
		$p.
		'<?php if ($_ctx->pagination->f(0) > $_ctx->posts->count()) : ?>'.
		$content.
		'<?php endif; ?>';
	}
	
	public function PaginationCounter($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,"context::PaginationNbPages()").'; ?>';
	}
	
	public function PaginationCurrent($attr)
	{
		$offset = 0;
		if (isset($attr['offset'])) {
			$offset = (integer) $attr['offset'];
		}
		
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,"context::PaginationPosition(".$offset.")").'; ?>';
	}
	
	public function PaginationIf($attr,$content)
	{
		$if = array();
		
		if (isset($attr['start'])) {
			$sign = (boolean) $attr['start'] ? '' : '!';
			$if[] = $sign.'context::PaginationStart()';
		}
		
		if (isset($attr['end'])) {
			$sign = (boolean) $attr['end'] ? '' : '!';
			$if[] = $sign.'context::PaginationEnd()';
		}
		
		if (!empty($if)) {
			return '<?php if('.implode(' && ',$if).') : ?>'.$content.'<?php endif; ?>';
		} else {
			return $content;
		}
	}
	
	public function PaginationURL($attr)
	{
		$offset = 0;
		if (isset($attr['offset'])) {
			$offset = (integer) $attr['offset'];
		}
		
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,"context::PaginationURL(".$offset.")").'; ?>';
	}
	
	/* Comments --------------------------------------- */
	public function Comments($attr,$content)
	{
		$p =
		"if (\$_ctx->posts !== null) { ".
			"\$params['post_id'] = \$_ctx->posts->post_id; ".
			"\$core->blog->withoutPassword(false);\n".
		"}\n";
		
		if (empty($attr['with_pings'])) {
			$p .= "\$params['comment_trackback'] = false;\n";
		}
		
		$lastn = 0;
		if (isset($attr['lastn'])) {
			$lastn = abs((integer) $attr['lastn'])+0;
		}
		
		if ($lastn > 0) {
			$p .= "\$params['limit'] = ".$lastn.";\n";
		}
		
		$p .=
		'if ($_ctx->exists("categories")) { '.
			"\$params['cat_id'] = \$_ctx->categories->cat_id; ".
		"}\n";
		
		$order = 'asc';
		if (isset($attr['order']) && preg_match('/^(desc|asc)$/i',$attr['order'])) {
			$order = $attr['order'];
		}
		
		$p .= "\$params['order'] = 'comment_dt ".$order."';\n";
		
		if (isset($attr['no_content']) && $attr['no_content']) {
			$p .= "\$params['no_content'] = true;\n";
		}
		
		$res = "<?php\n";
		$res .= $p;
		$res .= '$_ctx->comments = $core->blog->getComments($params); unset($params);'."\n";
		$res .= "if (\$_ctx->posts !== null) { \$core->blog->withoutPassword(true);}\n";
		
		if (!empty($attr['with_pings'])) {
			$res .= '$_ctx->pings = $_ctx->comments;'."\n";
		}
		
		$res .= "?>\n";
		
		$res .=
		'<?php while ($_ctx->comments->fetch()) : ?>'.$content.'<?php endwhile; $_ctx->comments = null; ?>';
		
		return $res;
	}
	
	public function CommentAuthor($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,"\$_ctx->comments->comment_author").'; ?>';
	}
	
	public function CommentAuthorLink($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->comments->getAuthorLink()').'; ?>';
	}
	
	public function CommentAuthorURL($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->comments->getAuthorURL()').'; ?>';
	}
	
	public function CommentContent($attr)
	{
		$urls = '0';
		if (!empty($attr['absolute_urls'])) {
			$urls = '1';
		}
		
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->comments->getContent('.$urls.')').'; ?>';
	}
	
	public function CommentDate($attr)
	{
		$format = '';
		if (!empty($attr['format'])) {
			$format = addslashes($attr['format']);
		}
		
		$iso8601 = !empty($attr['iso8601']);
		$rfc822 = !empty($attr['rfc822']);
		
		$f = $this->getFilters($attr);
		
		if ($rfc822) {
			return '<?php echo '.sprintf($f,"\$_ctx->comments->getRFC822Date()").'; ?>';
		} elseif ($iso8601) {
			return '<?php echo '.sprintf($f,"\$_ctx->comments->getISO8601Date()").'; ?>';
		} else {
			return '<?php echo '.sprintf($f,"\$_ctx->comments->getDate('".$format."')").'; ?>';
		}
	}
	
	public function CommentTime($attr)
	{
		$format = '';
		if (!empty($attr['format'])) {
			$format = addslashes($attr['format']);
		}
		
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,"\$_ctx->comments->getTime('".$format."')").'; ?>';
	}
	
	public function CommentEmail($attr)
	{
		$p = 'true';
		if (isset($attr['spam_protected']) && !$attr['spam_protected']) {
			$p = 'false';
		}
		
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,"\$_ctx->comments->getEmail(".$p.")").'; ?>';
	}
	
	public function CommentEntryTitle($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->comments->post_title').'; ?>';
	}
	
	public function CommentFeedID($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->comments->getFeedID()').'; ?>';
	}
	
	public function CommentID($attr)
	{
		return '<?php echo $_ctx->comments->comment_id; ?>';
	}
	
	public function CommentIf($attr,$content)
	{
		$if = array();
		$is_ping = null;
		
		if (isset($attr['is_ping'])) {
			$sign = (boolean) $attr['is_ping'] ? '' : '!';
			$if[] = $sign.'$_ctx->comments->comment_trackback';
		}
		
		if (!empty($if)) {
			return '<?php if('.implode(' && ',$if).') : ?>'.$content.'<?php endif; ?>';
		} else {
			return $content;
		}
	}
	
	public function CommentIfFirst($attr)
	{
		$ret = isset($attr['return']) ? $attr['return'] : 'first';
		$ret = html::escapeHTML($ret);
		
		return
		'<?php if ($_ctx->comments->index() == 0) { '.
		"echo '".addslashes($ret)."'; } ?>";
	}
	
	public function CommentIfMe($attr)
	{
		$ret = isset($attr['return']) ? $attr['return'] : 'me';
		$ret = html::escapeHTML($ret);
		
		return
		'<?php if ($_ctx->comments->isMe()) { '.
		"echo '".addslashes($ret)."'; } ?>";
	}
	
	public function CommentIfOdd($attr)
	{
		$ret = isset($attr['return']) ? $attr['return'] : 'odd';
		$ret = html::escapeHTML($ret);
		
		return
		'<?php if (($_ctx->comments->index()+1)%2) { '.
		"echo '".addslashes($ret)."'; } ?>";
	}
	
	public function CommentIP($attr)
	{
		return '<?php echo $_ctx->comments->comment_ip; ?>';
	}
	
	public function CommentOrderNumber($attr)
	{
		return '<?php echo $_ctx->comments->index()+1; ?>';
	}
	
	public function CommentsFooter($attr,$content)
	{
		return
		"<?php if (\$_ctx->comments->isEnd()) : ?>".
		$content.
		"<?php endif; ?>";
	}
	
	public function CommentsHeader($attr,$content)
	{
		return
		"<?php if (\$_ctx->comments->isStart()) : ?>".
		$content.
		"<?php endif; ?>";
	}
	
	public function CommentPostURL($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->comments->getPostURL()').'; ?>';
	}
	
	public function IfCommentAuthorEmail($attr,$content)
	{
		return
		"<?php if (\$_ctx->comments->comment_email) : ?>".
		$content.
		"<?php endif; ?>";
	}
	
	/* Comment preview -------------------------------- */
	public function IfCommentPreview($attr,$content)
	{
		return
		'<?php if ($_ctx->comment_preview !== null && $_ctx->comment_preview["preview"]) : ?>'.
		$content.
		'<?php endif; ?>';
	}
	
	public function CommentPreviewName($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->comment_preview["name"]').'; ?>';
	}
	
	public function CommentPreviewEmail($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->comment_preview["mail"]').'; ?>';
	}
	
	public function CommentPreviewSite($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->comment_preview["site"]').'; ?>';
	}
	
	public function CommentPreviewContent($attr)
	{
		$f = $this->getFilters($attr);
		
		if (!empty($attr['raw'])) {
			$co = '$_ctx->comment_preview["rawcontent"]';
		} else {
			$co = '$_ctx->comment_preview["content"]';
		}
		
		return '<?php echo '.sprintf($f,$co).'; ?>';
	}
	
	public function CommentPreviewCheckRemember($attr)
	{
		return
		"<?php if (\$_ctx->comment_preview['remember']) { echo ' checked=\"checked\"'; } ?>";
	}
	
	/* Trackbacks ------------------------------------- */
	public function PingBlogName($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->pings->comment_author').'; ?>';
	}
	
	public function PingContent($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->pings->getTrackbackContent()').'; ?>';
	}
	
	public function PingDate($attr)
	{
		$format = '';
		if (!empty($attr['format'])) {
			$format = addslashes($attr['format']);
		}
		
		$iso8601 = !empty($attr['iso8601']);
		$rfc822 = !empty($attr['rfc822']);
		
		$f = $this->getFilters($attr);
		
		if ($rfc822) {
			return '<?php echo '.sprintf($f,"\$_ctx->pings->getRFC822Date()").'; ?>';
		} elseif ($iso8601) {
			return '<?php echo '.sprintf($f,"\$_ctx->pings->getISO8601Date()").'; ?>';
		} else {
			return '<?php echo '.sprintf($f,"\$_ctx->pings->getDate('".$format."')").'; ?>';
		}
	}
	
	public function PingTime($attr)
	{
		$format = '';
		if (!empty($attr['format'])) {
			$format = addslashes($attr['format']);
		}
		
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,"\$_ctx->pings->getTime('".$format."')").'; ?>';
	}
	
	public function PingEntryTitle($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->pings->post_title').'; ?>';
	}
	
	public function PingFeedID($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->pings->getFeedID()').'; ?>';
	}
	
	public function PingID($attr)
	{
		return '<?php echo $_ctx->pings->comment_id; ?>';
	}
	
	public function PingIfFirst($attr)
	{
		$ret = isset($attr['return']) ? $attr['return'] : 'first';
		$ret = html::escapeHTML($ret);
		
		return
		'<?php if ($_ctx->pings->index() == 0) { '.
		"echo '".addslashes($ret)."'; } ?>";
	}
	
	public function PingIfOdd($attr)
	{
		$ret = isset($attr['return']) ? $attr['return'] : 'odd';
		$ret = html::escapeHTML($ret);
		
		return
		'<?php if (($_ctx->pings->index()+1)%2) { '.
		"echo '".addslashes($ret)."'; } ?>";
	}
	
	public function PingIP($attr)
	{
		return '<?php echo $_ctx->pings->comment_ip; ?>';
	}
	
	public function PingNoFollow($attr)
	{
		return
		'<?php if($core->blog->settings->comments_nofollow) { '.
		'echo \' rel="nofollow"\';'.
		'} ?>';
	}
	
	public function PingOrderNumber($attr)
	{
		return '<?php echo $_ctx->pings->index()+1; ?>';
	}
	
	public function PingPostURL($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->pings->getPostURL()').'; ?>';
	}
	
	public function Pings($attr,$content)
	{
		$p =
		"if (\$_ctx->posts !== null) { ".
			"\$params['post_id'] = \$_ctx->posts->post_id; ".
			"\$core->blog->withoutPassword(false);\n".
		"}\n";
		
		$p .= "\$params['comment_trackback'] = true;\n";
		
		$lastn = 0;
		if (isset($attr['lastn'])) {
			$lastn = abs((integer) $attr['lastn'])+0;
		}
		
		if ($lastn > 0) {
			$p .= "\$params['limit'] = ".$lastn.";\n";
		}
		
		$order = 'asc';
		if (isset($attr['order']) && preg_match('/^(desc|asc)$/i',$attr['order'])) {
			$order = $attr['order'];
		}
		
		$p .= "\$params['order'] = 'comment_dt ".$order."';\n";
		
		if (isset($attr['no_content']) && $attr['no_content']) {
			$p .= "\$params['no_content'] = true;\n";
		}
		
		$res = "<?php\n";
		$res .= $p;
		$res .= '$_ctx->pings = $core->blog->getComments($params); unset($params);'."\n";
		$res .= "if (\$_ctx->posts !== null) { \$core->blog->withoutPassword(true);}\n";
		$res .= "?>\n";
		
		$res .=
		'<?php while ($_ctx->pings->fetch()) : ?>'.$content.'<?php endwhile; $_ctx->pings = null; ?>';
		
		return $res;
	}
	
	public function PingsFooter($attr,$content)
	{
		return
		"<?php if (\$_ctx->pings->isEnd()) : ?>".
		$content.
		"<?php endif; ?>";
	}
	
	public function PingsHeader($attr,$content)
	{
		return
		"<?php if (\$_ctx->pings->isStart()) : ?>".
		$content.
		"<?php endif; ?>";
	}
	
	public function PingTitle($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->pings->getTrackbackTitle()').'; ?>';
	}
	
	public function PingAuthorURL($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->pings->getAuthorURL()').'; ?>';
	}
	
	# System
	public function SysIf($attr,$content)
	{
		$if = array();
		$is_ping = null;
		
		if (isset($attr['categories'])) {
			$sign = (boolean) $attr['categories'] ? '!' : '=';
			$if[] = '$_ctx->categories '.$sign.'== null';
		}
		
		if (isset($attr['posts'])) {
			$sign = (boolean) $attr['posts'] ? '!' : '=';
			$if[] = '$_ctx->posts '.$sign.'== null';
		}
		
		if (isset($attr['blog_lang'])) {
			$if[] = "\$core->blog->settings->lang == '".addslashes($attr['blog_lang'])."'";
		}
		
		if (!empty($if)) {
			return '<?php if('.implode(' && ',$if).') : ?>'.$content.'<?php endif; ?>';
		} else {
			return $content;
		}
	}
	
	public function SysIfCommentPublished($attr,$content)
	{
		return
		'<?php if (!empty($_GET[\'pub\'])) : ?>'.
		$content.
		'<?php endif; ?>';
	}
	
	public function SysIfCommentPending($attr,$content)
	{
		return
		'<?php if (isset($_GET[\'pub\']) && $_GET[\'pub\'] == 0) : ?>'.
		$content.
		'<?php endif; ?>';
	}
	
	public function SysFeedSubtitle($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php if ($_ctx->feed_subtitle !== null) { echo '.sprintf($f,'$_ctx->feed_subtitle').';} ?>';
	}
	
	public function SysIfFormError($attr,$content)
	{
		return
		'<?php if ($_ctx->form_error !== null) : ?>'.
		$content.
		'<?php endif; ?>';
	}
	
	public function SysFormError($attr)
	{
		return
		'<?php if ($_ctx->form_error !== null) { echo $_ctx->form_error; } ?>';
	}
	
	public function SysSearchString($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php if (isset($_search)) { echo '.sprintf($f,'$_search').';} ?>';
	}
	
	public function SysSelfURI($attr)
	{
		$f = $this->getFilters($attr);
		return '<?php echo '.sprintf($f,'http::getSelfURI()').'; ?>';
	}
}
?>