<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

class dcModules
{
	private $path;
	private $ns;
	private $modules = array();
	
	private $id;
	private $mroot;
	
	public function __construct(&$core)
	{
		$this->core =& $core;
	}
	
	public function loadModules($path,$ns=null)
	{
		$this->path = explode(PATH_SEPARATOR,$path);
		$this->ns = $ns;
		
		foreach ($this->path as $root)
		{
			if (!is_dir($root) || !is_readable($root)) {
				continue;
			}
			
			if (substr($root,-1) != '/') {
				$root .= '/';
			}
			
			if (($d = @dir($root)) === false) {
				continue;
			}
			
			while (($entry = $d->read()) !== false)
			{
				$full_entry = $root.'/'.$entry;
				
				if ($entry != '.' && $entry != '..' && is_dir($full_entry)
				&& file_exists($full_entry.'/_define.php')
				&& !file_exists($full_entry.'/_disabled'))
				{
					$this->id = $entry;
					$this->mroot = $full_entry;
					require $full_entry.'/_define.php';
					$this->id = null;
					$this->mroot = null;
				}
			}
			$d->close();
		}
	}
	
	public function registerModule($name,$desc,$author,$version,$permissions=null)
	{
		if ($this->ns == 'admin') {
			if ($permissions == '' && !$this->core->auth->isSuperAdmin()) {
				return;
			} elseif (!$this->core->auth->check($permissions,$this->core->blog->id)) {
				return;
			}
		}
		
		if ($this->id) {
			$this->modules[$this->id] = array(
			'root' => $this->mroot,
			'name' => $name,
			'desc' => $desc,
			'author' => $author,
			'version' => $version,
			'permissions' => $permissions
			);
			
			$this->loadNsFile($this->id,$this->ns);
		}
	}
	
	public function loadModulesL10N($lang,$file)
	{
		foreach ($this->modules as $m)
		{
			$lfile = $m['root'].'/locales/%s/%s';
			if (l10n::set(sprintf($lfile,$lang,$file)) === false && $lang != 'en') {
				l10n::set(sprintf($lfile,'en',$file));
			}
		}
	}
	
	public function getModules($id=null)
	{
		if ($id && isset($this->modules[$id])) {
			return $this->modules[$id];
		}
		return $this->modules;
	}
	
	public function moduleExists($id)
	{
		return isset($this->modules[$id]);
	}
	
	public function moduleRoot($id)
	{
		return isset($this->modules[$id]) ? $this->modules[$id]['root'] : null;
	}
	
	public function loadNsFiles($ns=null)
	{
		foreach ($this->modules as $k => $v) {
			$this->loadNsFile($k,$ns);
		}
	}
	
	public function loadNsFile($id,$ns=null)
	{
		switch ($ns) {
			case 'admin':
				$this->loadModuleFile($this->modules[$id]['root'].'/_admin.php');
				break;
			case 'public':
				$this->loadModuleFile($this->modules[$id]['root'].'/_public.php');
				break;
		}
	}
	
	private function loadModuleFile($________)
	{
		if (!file_exists($________)) {
			return;
		}
		
		foreach ($GLOBALS as $k => $v) {
			$$k =& $GLOBALS[$k];
			global $$k;
		}
		
		require $________;
	}
}
?>