<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of Clearbricks.
# Copyright (c) 2006 Olivier Meunier and contributors. All rights
# reserved.
#
# Clearbricks is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# Clearbricks is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Clearbricks; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

class imageMeta
{
	protected $meta = array();
	protected $xmp = array();
	
	public static function readMeta($f)
	{
		$o = new self;
		$o->loadFile($f);
		return $o->getMeta();
	}
	
	public function getMeta()
	{
		return array_merge($this->properties,$this->xmp);
	}
	
	public function loadFile($f)
	{
		if (($fp = @fopen($f,'rb')) === false) {
			throw new Exception('Unable to open image file');
		}
		
		$inside = false;
		$done = false;
		$xmp = null;
		
		while (!feof($fp))
		{
			$buffer = fgets($fp,4096);
			
			$xmp_start = strpos($buffer,'<x:xmpmeta');
			
			if ($xmp_start !== false) {
				$buffer = substr($buffer,$xmp_start);
				$inside = true;
			}
			
			if ($inside)
			{
				$xmp_end = strpos($buffer,'</x:xmpmeta>');
				if ($xmp_end !== false) {
					$buffer = substr($buffer,$xmp_end,12);
					$inside = false;
					$done = true;
				}
				
				$xmp .= $buffer;
			}
			
			if ($done) {
				break;
			}
		}
		
		fclose($fp);
		
		if (!$xmp) {
			return null;
		}
		
		$this->parseXMP($xmp);
	}
	
	protected function parseXMP($xmp)
	{
		foreach ($this->xmp_reg as $code => $patterns)
		{
			foreach ($patterns as $p)
			{
				if (preg_match($p,$xmp,$m)) {
					$this->xmp[$code] = $m[1];
					break;
				}
			}
		}
		
		if (preg_match('%<dc:subject>\s*<rdf:Bag>(.+?)</rdf:Bag%msu',$xmp,$m)
		&& preg_match_all('%<rdf:li>(.+?)</rdf:li>%msu',$m[1],$m))
		{
			$this->xmp['Subject'] = implode(', ',$m[1]);
		}
		
		foreach ($this->xmp as $k => $v) {
			$this->xmp[$k] = html::decodeEntities($v);
		}
	}
	
	/* Properties
	------------------------------------------------------- */
	protected $properties = array(
		'Title' => null,
		'Description' => null,
		'Creator' => null,
		'Rights' => null,
		'Make' => null,
		'Model' => null,
		'Exposure' => null,
		'FNumber' => null,
		'MaxApertureValue' => null,
		'ExposureProgram' => null,
		'ISOSpeedRatings' => null,
		'DateTimeOriginal' => null,
		'ExposureBiasValue' => null,
		'MeteringMode' => null,
		'FocalLength' => null,
		'Lens' => null,
		'CountryCode' => null,
		'Country' => null,
		'State' => null,
		'City' => null,
		'Subject' => null
	);
	
	protected $xmp_reg = array(
		'Title' => array(
			'%<dc:title>\s*<rdf:Alt>\s*<rdf:li.*?>(.+?)</rdf:li>%msu'
		),
		'Description' => array(
			'%<dc:description>\s*<rdf:Alt>\s*<rdf:li.*?>(.+?)</rdf:li>%msu'
		),
		'Creator' => array(
			'%<dc:creator>\s*<rdf:Seq>\s*<rdf:li>(.+?)</rdf:li>%msu'
		),
		'Rights' => array(
			'%<dc:rights>\s*<rdf:Alt>\s*<rdf:li.*?>(.+?)</rdf:li>%msu'
		),
		'Make' => array(
			'%<tiff:Make>(.+?)</tiff:Make>%msu',
			'%tiff:Make="(.+?)"%msu'
		),
		'Model' => array(
			'%<tiff:Model>(.+?)</tiff:Model>%msu',
			'%tiff:Model="(.+?)"%msu'
		),
		'Exposure' => array(
			'%<exif:ExposureTime>(.+?)</exif:ExposureTime>%msu',
			'%exif:ExposureTime="(.+?)"%msu'
		),
		'FNumber' => array(
			'%<exif:FNumber>(.+?)</exif:FNumber>%msu',
			'%exif:FNumber="(.+?)"%msu'
		),
		'MaxApertureValue' => array(
			'%<exif:MaxApertureValue>(.+?)</exif:MaxApertureValue>%msu',
			'%exif:MaxApertureValue="(.+?)"%msu'
		),
		'ExposureProgram' => array(
			'%<exif:ExposureProgram>(.+?)</exif:ExposureProgram>%msu',
			'%exif:ExposureProgram="(.+?)"%msu'
		),
		'ISOSpeedRatings' => array(
			'%<exif:ISOSpeedRatings>\s*<rdf:Seq>\s*<rdf:li>(.+?)</rdf:li>%msu'
		),
		'DateTimeOriginal' => array(
			'%<exif:DateTimeOriginal>(.+?)</exif:DateTimeOriginal>%msu',
			'%exif:DateTimeOriginal="(.+?)"%msu'
		),
		'ExposureBiasValue' => array(
			'%<exif:ExposureBiasValue>(.+?)</exif:ExposureBiasValue>%msu',
			'%exif:ExposureBiasValue="(.+?)"%msu'
		),
		'MeteringMode' => array(
			'%<exif:MeteringMode>(.+?)</exif:MeteringMode>%msu',
			'%exif:MeteringMode="(.+?)"%msu'
		),
		'FocalLength' => array(
			'%<exif:FocalLength>(.+?)</exif:FocalLength>%msu',
			'%exif:FocalLength="(.+?)"%msu'
		),
		'Lens' => array(
			'%<aux:Lens>(.+?)</aux:Lens>%msu',
			'%aux:Lens="(.+?)"%msu'
		),
		'CountryCode' => array(
			'%<Iptc4xmpCore:CountryCode>(.+?)</Iptc4xmpCore:CountryCode>%msu',
			'%Iptc4xmpCore:CountryCode="(.+?)"%msu'
		),
		'Country' => array(
			'%<photoshop:Country>(.+?)</photoshop:Country>%msu',
			'%photoshop:Country="(.+?)"%msu'
		),
		'State' => array(
			'%<photoshop:State>(.+?)</photoshop:State>%msu',
			'%photoshop:State="(.+?)"%msu'
		),
		'City' => array(
			'%<photoshop:City>(.+?)</photoshop:City>%msu',
			'%photoshop:City="(.+?)"%msu'
		)
	);
}
?>