<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/../inc/admin/prepend.php';

dcPage::checkSuper();

# Delete users
if (!empty($delete_users))
{
	foreach ($delete_users as $u)
	{
		try {
			$core->delUser($u);
		} catch (Exception $e) {
			$core->error->add($e->getMessage());
		}
	}
	
	if (!$core->error->flag()) {
		http::redirect('users.php?del=1');
	}
}


# Creating filter combo boxes
$sortby_combo = array(
__('User ID') => 'U.user_id',
__('Name') => 'user_name',
__('Firstname') => 'user_firstname',
__('Number of entries') => 'nb_post'
);

$order_combo = array(
__('Descending') => 'desc',
__('Ascending') => 'asc'
);


#Get users
$page = !empty($_GET['page']) ? $_GET['page'] : 1;
$nb_per_page =  30;

if (!empty($_GET['nb']) && (integer) $_GET['nb'] > 0) {
	$nb_per_page = $_GET['nb'];
}

$q = !empty($_GET['q']) ? $_GET['q'] : '';
$sortby = !empty($_GET['sortby']) ?	$_GET['sortby'] : 'user_id';
$order = !empty($_GET['order']) ?		$_GET['order'] : 'asc';

$params['limit'] = array((($page-1)*$nb_per_page),$nb_per_page);

$show_filters = false;

# - Search filter
if ($q) {
	$params['q'] = $q;
	$show_filters = true;
}

# - Sortby and order filter
if ($sortby !== '' && in_array($sortby,$sortby_combo)) {
	if ($order !== '' && in_array($order,$order_combo)) {
		$params['order'] = $sortby.' '.$order;
		$show_filters = true;
	}
}

try {
	$rs = $core->getUsers($params);
	$counter = $core->getUsers($params,1);
	$user_list = new adminUserList($core,$rs,$counter->f(0));
} catch (Exception $e) {
	$core->error->add($e->getMessage());
}


/* DISPLAY
-------------------------------------------------------- */
$starting_script = '<script type="text/javascript" src="js/_users.js"></script>'."\n";
if (!$show_filters) {
	$starting_script .= '<script type="text/javascript" src="js/filter-controls.js"></script>'."\n";
}

dcPage::open(__('users'),$starting_script);

if (!$core->error->flag())
{
	if (!empty($_GET['del'])) {
		echo '<p class="message">'.__('User has been successfully removed.').'</p>';
	}
	
	echo '<h2>'.__('Users').'</h2>';
	
	echo '<p><strong><a href="user.php">'.__('Create a new user').'</a></strong></p>';
	
	if (!$show_filters) {
		echo '<p><a id="filter-control" class="form-control" href="#">'.__('Filters').'</a></p>';
	}
	
	echo
	'<form action="users.php" method="get" id="filters-form">'.
	'<fieldset class="two-cols"><legend>'.__('Filters').'</legend>'.
	
	'<div class="col">'.
	'<p><label>'.__('Order by:').' '.
	form::combo('sortby',$sortby_combo,$sortby).
	'</label> '.
	'<label>'.__('Sort').' '.
	form::combo('order',$order_combo,$order).
	'</label></p>'.
	'</div>'.
	
	'<div class="col">'.
	'<p><label>'.__('Search:').' '.
	form::field('q',20,255,html::escapeHTML($q)).
	'</label></p>'.
	'<p><label class="classic">'.	form::field('nb',3,3,$nb_per_page).' '.
	__('Users per page').'</label> '.
	'<input type="submit" value="'.__('filter').'" /></p>'.
	'</div>'.
	
	'<br class="clear" />'. //Opera sucks
	'</fieldset>'.
	'</form>';
	
	# Show users
	$user_list->display($page,$nb_per_page,
	'<form action="dispatcher.php" method="get" id="form-users" '.
	'onsubmit="return submitUserForm(this,\''.
	html::escapeJS(__('Are you sure you want to delete selected users?')).'\');">'.
	
	'%s'.
	
	'<div class="two-cols">'.
	'<p class="col"><a href="#" onclick="return checkBoxes(\'form-users\',\'all\');">'.
	__('select all users').'</a> - '.
	'<a href="#" onclick="return checkBoxes(\'form-users\',\'invert\');">'.
	__('invert selection').'</a></p>'.
	
	'<p class="col right"><label class="classic">'.
	__('Selected users action:').' '.
	form::combo('dispatch_action',
	array(__('Set permissions') => 'setpermissions',
	__('Delete') => 'deleteuser')
	).'</label> '.
	'<input type="submit" value="'.__('ok').'" />'.
	'</p>'.
	'</div>'.
	'</form>'
	);
}

dcPage::close();
?>