Array.from = function(iterable) {
	if (!iterable) return [];
	if (iterable.toArray) {
		return iterable.toArray();
	} else {
		var results = [];
		for (var i = 0; i < iterable.length; i++) {
			results.push(iterable[i]);
		}
		return results;
	}
}

Function.prototype.bind = function() {
	var __method = this, args = Array.from(arguments), object = args.shift();
	return function() {
		return __method.apply(object);
	}
}

function ajaxTools(request_type)
{
	this.debug = false;
	this.request_type = request_type || 'GET';
	this.x = null;
	
	this.callback = null;
	this.callback_args = new Array();
	
	this.params = new Array();
	
	this.initObject();
}

ajaxTools.prototype = {
	debugAlert: function(data) {
		if (this.debug) {
			alert(data);
		}
	},
	
	initObject: function() {
		this.debugAlert('initObject() called..');
		
		var msxmlhttp = new Array('Msxml2.XMLHTTP.5.0','Msxml2.XMLHTTP.4.0',
		'Msxml2.XMLHTTP.3.0','Msxml2.XMLHTTP','Microsoft.XMLHTTP');
		
		for (var i = 0; i < msxmlhttp.length; i++) {
			try {
				this.x = new ActiveXObject(msxmlhttp[i]);
			} catch (e) {
				this.x = null;
			}
		}
		
		if(!this.x && typeof XMLHttpRequest != "undefined") {
			this.x = new XMLHttpRequest();
		}
		
		if (!this.x) {
			this.debugAlert('Could not create connection object.');
		}
	},
	
	param: function(n,v) {
		this.params.push(n+'='+v);
	},
	
	callUrl: function(uri,callback) {
		if (this.x == null) { return; }
		
		// Define callback and arguments
		this.callback = callback;
		this.callback_args = new Array();
		
		for (var i=2; i<arguments.length; i++) {
			this.callback_args.push(arguments[i]);
		}
		
		this.x.onreadystatechange = this.onStateChange.bind(this);
		
		// Prepare params
		var params = this.params.join('&');
		this.params = new Array();
		
		if (this.request_type == 'GET') {
			if (uri.indexOf('?') >= 0) {
				uri += '&'+params;
			} else {
				uri += '?'+params;
			}
			params = null;
		}
		
		this.x.open(this.request_type, uri, true);
		
		if (this.request_type == 'POST') {
			this.x.setRequestHeader('Method', 'POST'+uri+'HTTP/1.1');
			this.x.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
		}
		
		// Call uri
		this.x.send(params);
	},
	
	onStateChange: function() {
		if (this.x.readyState == 4) {
			if (this.x.status == 200) {
				this.debugAlert(this.x.responseText);
				try {
					this.callback.apply(this.x,this.callback_args);
				} catch (e) {
					this.debugAlert('Unable to call function '+this.callback);
				}
			} else {
				this.debugAlert('There was a problem with the request.');
			}
		}
	},
	
	elementContent: function(e) {
		if (e == undefined) { return null; }
		
		if (!e.hasChildNodes()) { return null; }
		
		e.normalize();
		c = e.firstChild.nodeValue;
		c = c.replace(/<!--.*-->/mg,'');
		c = c.replace(/^\s+/,'').replace(/\s+$/,'');
		return c;
	}
};