function submitCommentsForm(F,msg)
{
	// Get all form elements
	var inputs = F.elements;
	var post_ids = new Array();
	var action;
	
	// Get user_ids
	var i = 0;
	for (i=0; i<inputs.length; i++)
	{
		if (inputs[i].name == 'comments[]') {
			post_ids.push(inputs[i]);
		}
		
		if (inputs[i].name == 'action') {
			action = inputs[i].value;
		}
	}
	
	var selectfields = 0;
	for (i=0; i<post_ids.length; i++) {
		selectfields += post_ids[i].checked;
	}
	
	if (selectfields == 0) {
		return false;
	}
	
	if (action == 'delete') {
		return window.confirm(msg);
	}
	
	return true;
}

function commentExpander(line)
{
	var td = line.firstChild;
	
	var img = document.createElement('img');
	img.src = 'images/plus.png';
	img.className = 'expand';
	img.line = line;
	img.onclick = function() { viewCommentContent(this,this.line); }
	
	td.insertBefore(img,td.firstChild);
}

function viewCommentContent(img,line)
{
	var commentId = line.id.substr(1);
	
	var tr = document.getElementById('ce'+commentId);
	
	if (!tr)
	{
		tr = document.createElement('tr');
		tr.id = 'ce'+commentId;
		var td = document.createElement('td');
		td.colSpan = 6;
		td.className = 'expand';
		tr.appendChild(td);
		
		img.src = 'images/minus.png';
		
		// Get post content
		var x = new ajaxTools();
		x.callUrl('services.php?f=getCommentById&id='+commentId,
		function() {
			var rsp = this.responseXML.getElementsByTagName('rsp').item(0);
			
			if (rsp.attributes[0].value == 'ok') {
				var comment = x.elementContent(rsp.getElementsByTagName('comment_display_content').item(0));
				
				if (comment) {
					td.innerHTML = comment;
				}
			} else {
				alert(x.elementContent(rsp.getElementsByTagName('message').item(0)));
			}
		});
		
		line.className += ' expand';
		line.parentNode.insertBefore(tr,line.nextSibling);
	}
	else if (tr.style.display == 'none')
	{
		tr.style.display = '';
		line.className += ' expand';
		img.src = 'images/minus.png';
	}
	else
	{
		tr.style.display = 'none';
		line.className = line.className.replace(/ expand$/,'');
		img.src = 'images/plus.png';
	}
}

chainHandler(window,'onload',function() {
	var f = document.getElementById('form-comments');
	var lines = getElementsByNameAndClass('tr','line',f);
	
	for (var i=0; i<lines.length; i++) {
		commentExpander(lines[i]);
	}
});