<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/../inc/admin/prepend.php';

dcPage::check('admin');

# Loading themes
$core->themes = new dcModules($core);
$core->themes->loadModules($core->blog->themes_path,null);

# Theme screenshot
if (!empty($_GET['shot']) && $core->themes->moduleExists($_GET['shot'])) {
	$f = $core->blog->themes_path.'/'.$_GET['shot'].'/screenshot.jpg';
	if (!file_exists($f)) {
		$f = dirname(__FILE__).'/images/noscreenshot.png';
	}
	
	http::cache(array_merge(array($f),get_included_files()));
	
	header('Content-Type: image/png');
	readfile($f);
	
	exit;
}

# Updating theme
if (!empty($_POST['theme']))
{
	$core->blog->settings->setNameSpace('system');
	$core->blog->settings->put('theme',$_POST['theme']);
	$core->blog->triggerBlog();
	http::redirect('blog_theme.php?upd=1');
}

$default_tab = !empty($_REQUEST['tab']) ? html::escapeHTML($_REQUEST['tab']) : 'themes';

dcPage::open(__('Blog themes'),dcPage::jsMultiPartPage($default_tab));

echo
'<h2>'.html::escapeHTML($core->blog->name).' &gt; '.__('Theme settings').'</h2>';

if (!empty($_GET['upd'])) {
	echo '<p class="message">'.__('Theme has been successfully changed.').'</p>';
}

echo
'<div class="multi-part" id="themes" title="'.__('Themes').'">'.
'<form action="blog_theme.php" method="post">';

foreach ($core->themes->getModules() as $k => $v)
{
	$screenshot = 'images/noscreenshot.png';
	if (file_exists($core->blog->themes_path.'/'.$k.'/screenshot.jpg')) {
		$screenshot = 'blog_theme.php?shot='.rawurlencode($k);
	}
	
	$radio_id = 'theme_'.html::escapeHTML($k);
	echo
	'<div class="screenshot"><h3>'.
	form::radio(array('theme',$radio_id),html::escapeHTML($k),$core->blog->settings->theme == $k).' '.
	'<label class="classic" for="'.$radio_id.'">'.
	html::escapeHTML($v['name']).'</label></h3>'.
	'<p><label class="classic" for="'.$radio_id.'">'.
	'<img src="'.$screenshot.'" width="240" height="210" alt="" /></label>'.
	' <br />'.sprintf(__('by %s'),html::escapeHTML($v['author'])).'</p>'.
	'</div>';
}

echo
'<p class="clear"><input type="submit" value="'.__('save').'" /></p>'.
'</form>'.
'</div>';

# Get current theme configuration part
$theme_config_file = path::real($core->blog->themes_path.'/'.$core->blog->settings->theme).'/_config.php';
if (file_exists($theme_config_file))
{
	echo	'<div class="multi-part" id="theme_config" title="'.__('Theme configuration').'">';
	
	try
	{
		echo '<form action="blog_theme.php" method="post">';
		
		include $theme_config_file;
		
		echo
		'<p class="clear"><input type="submit" value="'.__('save').'" />'.
		form::hidden('tab','theme_config').'</p>'.
		'</form>';
	}
	catch (Exception $e)
	{
		echo '<div class="error"><p>'.$e->getMessage().'</p></div>';
	}
	
	echo '</div>';
}

dcPage::close();
?>