<?php
# ***** BEGIN LICENSE BLOCK *****
# This is spamplemousse, a plugin for DotClear. 
# Copyright (c) 2005 Benoit CLERC, Alain Vagner and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/class.dc.spampl.php';

$core->addBehavior('publicBeforeCommentCreate',array('spamFilterBehaviors','markSpam'));
$core->addBehavior('publicBeforeTrackbackCreate',array('spamFilterBehaviors','markSpam'));

class spamFilterBehaviors
{
	public static function markSpam(&$cur)
	{
		$spamFilter = new dcSpamFilter($GLOBALS['core']);
		
		$comment_content =
			$cur->comment_author.' '.$cur->comment_email.' '.
			$cur->comment_site.' '.$cur->comment_content;
		
		if ($cur->comment_ip && ($dnsbl = $spamFiler->dnsblLookup($cur->comment_ip)))
		{
			$cur->comment_spam_status = 'Blocked by '.$dnsbl;
			$cur->comment_status = -2;
		}
		elseif ($spamFilter->checkSpamWords($comment_content))
		{
			$cur->comment_spam_status = 'Bad word detected';
			$cur->comment_status = -2;
		}
	}
}

class spamFilterURL extends dcUrlHandlers
{
	public static function feed($args)
	{
		$core =& $GLOBALS['core'];
		$spamFilter = new dcSpamFilter($core);
		
		$user_id = $spamFilter->checkUserCode($args);
		
		if ($user_id === false) {
			self::p404();
		}
		
		$core->auth->checkUser($user_id,null,null);
		
		header('Content-Type: application/xml');
		
		$title = $core->blog->name.' - '.__('Spam moderation');
		
		echo
		'<?xml version="1.0" encoding="utf-8"?>'."\n".
		'<rss version="2.0"'."\n".
		'xmlns:dc="http://purl.org/dc/elements/1.1/"'."\n".
		'xmlns:content="http://purl.org/rss/1.0/modules/content/">'."\n".
		'<channel>'."\n".
		'<title>'.$title.'</title>'."\n".
		'<link>'.(DC_ADMIN_URL ? DC_ADMIN_URL.'comments.php?status=-2' : 'http://null').'</link>'."\n".
		'<description></description>'."\n";
		
		$params['comment_status'] = -2;
		$rs = $core->blog->getComments($params);
		
		while ($rs->fetch())
		{
			$uri = DC_ADMIN_URL ? DC_ADMIN_URL.'comment.php?id='.$rs->comment_id : 'http://null';
			$author = $rs->comment_author;
			$title = $rs->post_title.' - '.$author.' ('.$rs->comment_spam_status.')';
			$id = $rs->getFeedID();
			
			$content = '<p>IP: '.$rs->comment_ip;
			
			if (trim($rs->comment_site)) {
				$content .= '<br />URL: <a href="'.$rs->comment_site.'">'.$rs->comment_site.'</a>';
			}
			$content .= "</p><hr />\n";
			$content .= $rs->comment_content;
			
			if (DC_ADMIN_URL) {
				$content .=
				'<form action="'.DC_ADMIN_URL.'comment.php" method="post">'.
				'<p><input type="submit" value="'.__('Publish').'" />'.
				'<input type="hidden" name="action" value="status" /></p>'.
				'</form>'.
				'<form action="'.DC_ADMIN_URL.'comment.php" method="post">'.
				'<p><input type="submit" value="'.__('Delete').'" />'.
				'<input type="hidden" name="action" value="delete" /></p>'.
				'</form>';
			}
			
			echo
			'<item>'."\n".
			'  <title>'.html::escapeHTML($title).'</title>'."\n".				
			'  <link>'.$uri.'</link>'."\n".
			'  <guid>'.$id.'</guid>'."\n".
			'  <pubDate>'.$rs->getRFC822Date().'</pubDate>'."\n".
			'  <dc:creator>'.html::escapeHTML($author).'</dc:creator>'."\n".
			'  <description>'.html::escapeHTML(strip_tags($rs->comment_content)).'</description>'."\n".
			'  <content:encoded>'.html::escapeHTML($content).'</content:encoded>'."\n".		
			'</item>';
		}
		
		echo "</channel>\n</rss>";	
		exit;
	}
}
?>