<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/class.dc.meta.php';

$core->tpl->addBlock('MetaData',array('tplMetadata','MetaData'));
$core->tpl->addBlock('MetaDataHeader',array('tplMetadata','MetaDataHeader'));
$core->tpl->addBlock('MetaDataFooter',array('tplMetadata','MetaDataFooter'));
$core->tpl->addValue('MetaID',array('tplMetadata','MetaID'));
$core->tpl->addValue('MetaPercent',array('tplMetadata','MetaPercent'));
$core->tpl->addValue('MetaRoundPercent',array('tplMetadata','MetaRoundPercent'));
$core->tpl->addValue('MetaURL',array('tplMetadata','MetaURL'));
$core->tpl->addValue('MetaAllURL',array('tplMetadata','MetaAllURL'));

$core->tpl->addBlock('EntryMetaData',array('tplMetadata','EntryMetaData'));

$core->tpl->addBlock('MetaEntries',array('tplMetadata','MetaEntries'));

class tplMetadata
{
	public static function MetaData($attr,$content)
	{
		$type = isset($attr['type']) ? addslashes($attr['type']) : 'tag';
		
		$limit = isset($attr['limit']) ? (integer) $attr['limit'] : 'null';
		
		$sortby = 'meta_id_lower';
		if (isset($attr['sortby']) && $attr['sortby'] == 'count') {
			$sortby = 'count';
		}
		
		$order = 'asc';
		if (isset($attr['order']) && $attr['order'] == 'desc') {
			$order = 'desc';
		}
		
		$res =
		"<?php\n".
		'$objMeta = new dcMeta($core); '.
		"\$_ctx->meta = \$objMeta->getMeta('".$type."',".$limit."); ".
		"\$_ctx->meta->sort('".$sortby."','".$order."'); ".
		'?>';
		
		$res .=
		'<?php while ($_ctx->meta->fetch()) : ?>'.$content.'<?php endwhile; '.
		'$_ctx->meta = null; unset($objMeta); ?>';
		
		return $res;
	}
	
	public static function MetaDataHeader($attr,$content)
	{
		return
		"<?php if (\$_ctx->meta->isStart()) : ?>".
		$content.
		"<?php endif; ?>";
	}
	
	public static function MetaDataFooter($attr,$content)
	{
		return
		"<?php if (\$_ctx->meta->isEnd()) : ?>".
		$content.
		"<?php endif; ?>";
	}
	
	public static function EntryMetaData($attr,$content)
	{
		$type = isset($attr['type']) ? addslashes($attr['type']) : 'tag';
		
		$sortby = 'meta_id_lower';
		if (isset($attr['sortby']) && $attr['sortby'] == 'count') {
			$sortby = 'count';
		}
		
		$order = 'asc';
		if (isset($attr['order']) && $attr['order'] == 'desc') {
			$order = 'desc';
		}
		
		$res =
		"<?php\n".
		'$objMeta = new dcMeta($core); '.
		"\$_ctx->meta = \$objMeta->getMetaRecordset(\$_ctx->posts->post_meta,'".$type."'); ".
		"\$_ctx->meta->sort('".$sortby."','".$order."'); ".
		'?>';
		
		$res .=
		'<?php while ($_ctx->meta->fetch()) : ?>'.$content.'<?php endwhile; '.
		'$_ctx->meta = null; unset($objMeta); ?>';
		
		return $res;
	}
	
	public static function MetaID($attr)
	{
		$f = $GLOBALS['core']->tpl->getFilters($attr);
		return '<?php echo '.sprintf($f,'$_ctx->meta->meta_id').'; ?>';
	}
	
	public static function MetaPercent($attr)
	{
		return '<?php echo $_ctx->meta->percent; ?>';
	}
	
	public static function MetaRoundPercent($attr)
	{
		return '<?php echo $_ctx->meta->roundpercent; ?>';
	}
	
	public static function MetaURL($attr)
	{
		$f = $GLOBALS['core']->tpl->getFilters($attr);
		return '<?php echo '.sprintf($f,'$core->blog->url.$core->url->getBase("tag").'.
		'"/".rawurlencode($_ctx->meta->meta_id)').'; ?>';
	}
	
	public static function MetaEntries($attr,$content)
	{
		$type = isset($attr['metatype']) ? addslashes($attr['metatype']) : 'tag';
		
		$p =
		"\$params['from'] = ', '.\$core->prefix.'meta META ';\n".
		"\$params['sql'] = 'AND META.post_id = P.post_id ';\n".
		"\$params['sql'] .= \"AND META.meta_type = '\".\$core->con->escapeStr('".$type."').\"' \";\n".
		
		'if ($_ctx->exists("meta")) { '.
			"\$params['sql'] .= \"AND META.meta_id = '\".\$core->con->escapeStr(\$_ctx->meta->meta_id).\"' \";\n".
		"}\n";
		
		return
		'<?php '.$p.' ?>'.
		$GLOBALS['core']->tpl->Entries($attr,$content);
	}
	
	public static function MetaAllURL($attr)
	{
		$f = $GLOBALS['core']->tpl->getFilters($attr);
		return '<?php echo '.sprintf($f,'$core->blog->url.$core->url->getBase("tags")').'; ?>';
	}
	
	# Widget function
	public static function tagsWidget(&$w)
	{
		global $core;
		
		$title = $w->title ? html::escapeHTML($w->title) : __('Tags');
		$limit = (integer) $w->limit;
		
		$objMeta = new dcMeta($core);
		$rs = $objMeta->getMeta('tag',$limit);
		
		if ($rs->isEmpty()) {
			return;
		}
		
		$rs->sort('count','desc');
		
		$res =
		'<div id="tags">'.
		'<h2>'.$title.'</h2>'.
		'<ul>';
		
		while ($rs->fetch())
		{
			$res .=
			'<li><a href="'.$core->blog->url.$core->url->getBase('tag').'/'.rawurlencode($rs->meta_id).'" '.
			'class="tag'.$rs->roundpercent.'">'.
			$rs->meta_id.'</a> </li>';
		}
		
		$res .= '</ul>'.
		'<p><strong><a href="'.$core->blog->url.$core->url->getBase("tags").'">'.
		__('All tags').'</a></strong></p>'.
		'</div>';
		
		return $res;
	}
}

class urlMetadata extends dcUrlHandlers
{
	public static function tag($args)
	{
		$n = self::getPageNumber($args);
		
		if ($args == '' && !$n) {
			self::p404();
		} else {
			if ($n) {
				$GLOBALS['_page_number'] = $n;
			}
			
			$objMeta = new dcMeta($GLOBALS['core']);
			$GLOBALS['_ctx']->meta = $objMeta->getMeta('tag',null,$args);
			
			if ($GLOBALS['_ctx']->meta->isEmpty()) {
				self::p404();
			} else {
				self::serveDocument('tag.html');
			}
		}
		exit;
	}
	
	public static function tags($args)
	{
		self::serveDocument('tags.html');
		exit;
	}
}
?>