<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/class.dc.meta.php';

$_menu['Blog']->addItem('Tags','plugin.php?p=metadata&amp;m=tags','index.php?pf=metadata/tags.png',
		preg_match('/plugin.php\?p=metadata&m=tag(s|_posts)?(&.*)?$/',$_SERVER['REQUEST_URI']),
		$core->auth->check('usage,contentadmin',$core->blog->id));

$core->addBehavior('adminInitWidgets',array('metaBehaviors','initWidgets'));

$core->addBehavior('adminPostFormSidebar',array('metaBehaviors','tagsField'));

$core->addBehavior('adminAfterPostCreate',array('metaBehaviors','setTags'));
$core->addBehavior('adminAfterPostUpdate',array('metaBehaviors','setTags'));

$core->addBehavior('adminPostHeaders',array('metaBehaviors','postHeaders'));

$core->addBehavior('coreInitWikiPost',array('metaBehaviors','coreInitWikiPost'));

$core->rest->addFunction('getMeta',array('metaRest','getMeta'));
$core->rest->addFunction('delMeta',array('metaRest','delMeta'));
$core->rest->addFunction('setPostMeta',array('metaRest','setPostMeta'));

# BEHAVIORS
class metaBehaviors
{
	public static function initWidgets(&$widgets)
	{
		$widgets->create('tags','Tags',array('tplMetadata','tagsWidget'));
		$widgets->tags->setting('title',__('Title:'),'');
		$widgets->tags->setting('limit',__('Limit (empty means no limit):'),'20');
	}
	
	public static function coreInitWikiPost(&$wiki2xhtml)
	{
		$wiki2xhtml->registerFunction('url:tag',array('metaBehaviors','wiki2xhtmlTag'));
	}
	
	public static function wiki2xhtmlTag($url,$content)
	{
		$tag_url = html::stripHostURL($GLOBALS['core']->blog->url.$GLOBALS['core']->url->getBase('tag'));
		$res['url'] = $tag_url.'/'.rawurlencode(dcMeta::sanitizeMetaID($content));
		$res['content'] = $content;
		
		return $res;
	}
	
	public static function tagsField(&$post)
	{
		$meta = new dcMeta($GLOBALS['core']);
		
		if (!empty($_POST['post_tags'])) {
			$value = $_POST['post_tags'];
		} else {
			$value = ($post) ? $meta->getMetaStr($post->post_meta,'tag') : '';
		}
		
		echo
		'<h3><label for="post_tags">'.__('Tags:').'</label></h3>'.
		'<div id="meta-edit-tags">'.form::textarea('post_tags',20,3,$value,'maximal',3).'</div>';
	}
	
	public static function setTags(&$cur,&$post_id)
	{
		$post_id = (integer) $post_id;
		
		if (isset($_POST['post_tags'])) {
			$tags = $_POST['post_tags'];
			
			$meta = new dcMeta($GLOBALS['core']);
			
			try {
				$meta->delPostMeta($post_id,'tag');
			} catch (Exception $e) {
				throw $e;
			}
			
			foreach ($meta->splitMetaValues($tags) as $tag)
			{
				try {
					$meta->setPostMeta($post_id,'tag',$tag);
				} catch (Exception $e) {
					throw $e;
				}
			}
		}
	}
	
	public static function postHeaders()
	{
		$tag_url = $GLOBALS['core']->blog->url.$GLOBALS['core']->url->getBase('tag');
		
		return 
		'<script type="text/javascript" src="index.php?pf=metadata/post.js"></script>'.
		'<script type="text/javascript">'."\n".
		"//<![CDATA[\n".
		"metaEditor.prototype.text_confirm_remove = '".html::escapeJS(__('Are you sure you want to remove this %s?'))."';\n".
		"metaEditor.prototype.text_add_meta = '".html::escapeJS(__('Add a %s to this entry'))."';\n".
		"metaEditor.prototype.text_choose = '".html::escapeJS(__('Choose from list'))."';\n".
		"metaEditor.prototype.text_more = '".html::escapeJS(__('more'))."';\n".
		"metaEditor.prototype.text_all = '".html::escapeJS(__('all'))."';\n".
		"jsToolBar.prototype.elements.tag.title = '".html::escapeJS(__('Tag'))."';\n".
		"jsToolBar.prototype.elements.tag.url = '".html::escapeJS($tag_url)."';\n".
		"\n//]]>\n".
		"</script>\n".
		'<link rel="stylesheet" type="text/css" href="index.php?pf=metadata/style.css" />';
	}
}

# REST
class metaRest
{
	public static function getMeta(&$core,$get)
	{
		$meta = new dcMeta($core);
		
		$postid = !empty($get['postId']) ? $get['postId'] : null;
		$limit = !empty($get['limit']) ? $get['limit'] : null;
		$metaId = !empty($get['metaId']) ? $get['metaId'] : null;
		$metaType = !empty($get['metaType']) ? $get['metaType'] : null;
		
		$sortby = !empty($get['sortby']) ? $get['sortby'] : 'meta_type,asc';
		
		try {
			$rs = $meta->getMeta($metaType,$limit,$metaId,$postid);
		} catch (Exception $e) {
			throw $e;
		}
		
		
		$sortby = explode(',',$sortby);
		$sort = $sortby[0];
		$order = isset($sortby[1]) ? $sortby[1] : 'asc';
		
		switch ($sort) {
			case 'metaId':
				$sort = 'meta_id_lower';
				break;
			case 'count':
				$sort = 'count';
				break;
			case 'metaType':
				$sort = 'meta_type';
				break;
			default:
				$sort = 'meta_type';
		}
		
		$rs->sort($sort,$order);
		
		$rsp = new xmlTag();
		
		while ($rs->fetch())
		{
			$metaTag = new xmlTag('meta');
			$metaTag->type = $rs->meta_type;
			$metaTag->uri = rawurlencode($rs->meta_id);
			$metaTag->count = $rs->count;
			$metaTag->percent = $rs->percent;
			$metaTag->roundpercent = $rs->roundpercent;
			$metaTag->CDATA($rs->meta_id);
			
			$rsp->insertNode($metaTag);
		}
		
		return $rsp;
	}
	
	public static function setPostMeta(&$core,$get,$post)
	{
		if (empty($post['postId'])) {
			throw new Exception('No post ID');
		}
		
		if (empty($post['meta'])) {
			throw new Exception('No meta');
		}
		
		if (empty($post['metaType'])) {
			throw new Exception('No meta type');
		}
		
		$meta = new dcMeta($core);
		
		# Get previous meta for post
		$post_meta = $meta->getMeta($post['metaType'],null,null,$post['postId']);
		$pm = array();
		while ($post_meta->fetch()) {
			$pm[] = $post_meta->meta_id;
		}
		
		foreach ($meta->splitMetaValues($post['meta']) as $m)
		{
			if (!in_array($m,$pm)) {
				try {
					$meta->setPostMeta($post['postId'],$post['metaType'],$m);
				} catch (Exception $e) {
					throw $e;
				}
			}
		}
		
		return true;
	}
	
	public static function delMeta(&$core,$get,$post)
	{
		if (empty($post['postId'])) {
			throw new Exception('No post ID');
		}
		
		if (empty($post['metaId'])) {
			throw new Exception('No meta ID');
		}
		
		if (empty($post['metaType'])) {
			throw new Exception('No meta type');
		}
		
		$meta = new dcMeta($core);
		
		try {
			$meta->delPostMeta($post['postId'],$post['metaType'],$post['metaId']);
		} catch (Exception $e) {
			throw $e;
		}
		
		return true;
	}
}
?>