<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

if (!defined('DC_CONTEXT_ADMIN')) { exit; }

require_once DC_ROOT.'/inc/clearbricks/class.mail.php';

$types = array(
	__('Bug') => 'defect',
	__('Enhancement') => 'enhancement'
);
$skills = array(
	__('novice') => 'novice',
	__('intermediate') => 'intermediate',
	__('advanced') => 'advanced',
	__('expert') => 'expert'
);

$ticket_summary = $ticket_description = '';
$ticket_type = 'defect';
$ticket_skills = 'novice';

if (!$core->auth->getInfo('user_email')) {
	$core->error->add(__('You must provide an email address in your profile to report a bug.'));
}

# Send bug
if (!empty($_POST) && $core->auth->getInfo('user_email'))
{
	try
	{
		$ticket_summary = $_POST['ticket_summary'];
		$ticket_description = $_POST['ticket_description'];
		$ticket_type = $_POST['ticket_type'];
		$ticket_skills = $_POST['ticket_skills'];
		$ticket_url = '';
		
		if (empty($_POST['ticket_summary'])) {
			throw new Exception(__('No summary'));
		}
		
		if (empty($_POST['ticket_description'])) {
			throw new Exception(__('No description'));
		}
	
		if ($core->auth->getInfo('user_email')) {
			$ticket_reporter = $core->auth->getInfo('user_email');
		} else {
			echo $ticket_reporter = $core->auth->getInfo('user_displayname');
		}
		
		if (!empty($_POST['send_url'])) {
			$ticket_url = $core->blog->url;
		}
		
		$subject = mb_encode_mimeheader('[Bug report] - '.$ticket_type.' - '.
		$ticket_summary,'UTF-8','B');
		$headers[] = 'From: '.$core->auth->getInfo('user_email');
		$headers[] = 'Content-Type: text/plain; charset=UTF-8;';
		
		$message =
		$ticket_description."\r\n\r\n".
		"===========================================================\r\n".
		'DotClear skills: '.$ticket_skills."\r\n".
		'PHP version    : '.phpversion()."\r\n".
		'ISP            : '.$dc_remote_tickets_isp."\r\n".
		'Browser        : '.$_SERVER['HTTP_USER_AGENT']."\r\n".
		'URL            : '.$ticket_url."\r\n";
		
		mail::sendMail($dc_remote_tickets_to,$subject,$message,$headers);
		
		http::redirect($p_url.'&sent=1');
	}
	catch (Exception $e)
	{
		$core->error->add($e->getMessage());
	}
}
?>
<html>
<head>
  <title><?php echo __('Bug report'); ?></title>
</head>

<body>
<?php
if (!empty($_GET['sent'])) {
	echo '<p class="message">'.__('Ticket successfully sent, thank you.').'</p>';
}
?>
<h2><?php echo html::escapeHTML($core->blog->name); ?> &gt;
<?php echo __('Bug report'); ?></h2>

<?php
if (!$core->auth->getInfo('user_email')) {
	echo '</body></html>';
	return;
}

echo
'<form action="'.$p_url.'" method="post">'.
'<p><label>'.__('Summary:').' '.
form::field('ticket_summary',30,255,html::escapeHTML($ticket_summary)).
'</label></p>'.

'<p class="area"><label for="ticket_description">'.__('Description:').'</label> '.
form::textarea('ticket_description',50,8,html::escapeHTML($ticket_description)).
'</p>'.

'<p><label>'.__('Type:').' '.
form::combo('ticket_type',$types,$ticket_type).
'</label></p>'.

'<p><label>'.__('Skills with DotClear:').
form::combo('ticket_skills',$skills,'novice',$ticket_skills).
'</label></p>'.

'<p><label class="classic">'.form::checkbox('send_url',1,1).' '.
__('Send my blog URL').'</label></p>'.

'<p><input type="submit" value="'.__('Send the bug').'" /></p>'.
'</form>';
?>

</body>
</html>