<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

if (!defined('DC_CONTEXT_ADMIN')) { exit; }

if (!empty($_POST['s']) && is_array($_POST['s']))
{
	foreach ($_POST['s'] as $ns => $s)
	{
		$core->blog->settings->setNameSpace($ns);
		
		foreach ($s as $k => $v)
		{
			try {
				$core->blog->settings->put($k,$v);
			} catch (Exception $e) {
				$core->error->add($e->getMessage());
			}
		}
		
		try {
			$core->blog->triggerBlog();
		} catch (Exception $e) {
			$core->error->add($e->getMessage());
		}
	}
	
	if (!$core->error->flag()) {
		http::redirect($p_url.'&upd=1');
	}
}

if (!empty($_GET['update_all']))
{
	foreach ($core->blogs as $k => $v) {
		try {
			$core->blogDefaults($k);
		} catch (Exception $e) {
			$core->error->add($e->getMessage());
			break;
		}
	}
	
	if (!$core->error->flag()) {
		http::redirect($p_url.'&upda=1');
	}
}
?>
<html>
<head>
  <title>about:config</title>
</head>

<body>
<?php
if (!empty($_GET['upd'])) {
	echo '<p class="message">'.__('Configuration successfully updated').'</p>';
}

if (!empty($_GET['upda'])) {
	echo '<p class="message">'.__('Settings definition successfully updated').'</p>';
}
?>
<h2><?php echo html::escapeHTML($core->blog->name); ?> &gt; about:config</h2>

<form action="plugin.php" method="post">
<table>
<tr>
  <th class="nowrap">Setting ID</th>
  <th><?php echo __('Value'); ?></th>
  <th><?php echo __('Type'); ?></th>
  <th class="maximal"><?php echo __('Description'); ?></th>
</tr>
<?php
$settings = array();

foreach ($core->blog->settings->dumpSettings() as $k => $v) {
	$settings[$v['ns']][$k] = $v;
}

ksort($settings);

foreach ($settings as $ns => $s)
{
	ksort($s);
	echo '<tr><td colspan="4">namespace: <strong>'.$ns.'</strong></td></tr>';
	
	foreach ($s as $k => $v)
	{
		if ($v['type'] == 'boolean') {
			$field = form::combo(array('s['.$ns.']['.$k.']','s_'.$k),
			array(__('yes') => 1, __('no') => 0),$v['value']);
		} else {
			$field = form::field(array('s['.$ns.']['.$k.']','s_'.$k),40,null,
			html::escapeHTML($v['value']));
		}
		
		echo
		'<tr>'.
		'<td><label for="s_'.$k.'">'.html::escapeHTML($k).'</label></td>'.
		'<td>'.$field.'</td>'.
		'<td>'.$v['type'].'</td>'.
		'<td>'.html::escapeHTML($v['label']).'</td>'.
		'</tr>';
	}
}
?>
</table>
<p><input type="submit" value="<?php echo __('save'); ?>" />
<input type="hidden" name="p" value="aboutConfig" /></p>
</form>

<?php
if ($core->auth->isSuperAdmin())
{
	echo
	'<p><a href="'.$p_url.'&amp;update_all=1">'.
	__('Update settings definition on all blogs').
	'</a></p>';
}
?>

</body>
</html>