<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

class context
{
	public $stack = array();
	
	public function __set($name,$var)
	{
		if ($var === null) {
			$this->pop($name);
		} else {
			$this->stack[$name][] =& $var;
		}
	}
	
	public function __get($name)
	{
		if (!isset($this->stack[$name])) {
			return null;
		}
		
		$n = count($this->stack[$name]);
		if ($n > 0) {
			return $this->stack[$name][($n-1)];
		}
		
		return null;
	}
	
	public function exists($name)
	{
		return isset($this->stack[$name][0]);
	}
	
	public function pop($name)
	{
		if (isset($this->stack[$name])) {
			array_pop($this->stack[$name]);
		}
	}
	
	
	# Static methods
	public static function global_filter($str,
	$encode_xml, $remove_html, $cut_string, $lower_case, $upper_case)
	{
		if ($remove_html) {
			$str = self::remove_html($str);
		}
		
		if ($encode_xml) {
			$str = self::encode_xml($str);
		}
		
		if ($cut_string) {
			$str = self::cut_string($str,(integer) $cut_string);
		}
		
		if ($lower_case) {
			$str = self::lower_case($str);
		} elseif ($upper_case) {
			$str = self::upper_case($str);
		}
		
		return $str;
	}
	
	
	public static function cut_string($str,$l)
	{
		return text::cutString($str,$l);
	}
	
	public static function encode_xml($str)
	{
		return html::escapeHTML($str);
	}
	
	public static function remove_html($str)
	{
		return html::clean($str);
	}
	
	public static function lower_case($str)
	{
		return mb_strtolower($str);
	}
	
	public static function upper_case($str)
	{
		return mb_strtoupper($str);
	}
	
	# Static methods for pagination
	public static function PaginationNbPages()
	{
		global $_ctx;
		
		$nb_posts = $_ctx->pagination->f(0);
		$nb_per_page = $_ctx->post_params['limit'][1];
		
		$nb_pages = ceil($nb_posts/$nb_per_page);
		
		return $nb_pages;
	}
	
	public static function PaginationPosition($offset=0)
	{
		if (isset($GLOBALS['_page_number'])) {
			$p = $GLOBALS['_page_number'];
		} else {
			$p = 1;
		}
		
		$p = $p+$offset;
		
		$n = self::PaginationNbPages();
		if ($p > $n || $p <= 0) {
			return 1;
		} else {
			return $p;
		}
	}
	
	public static function PaginationStart()
	{
		if (isset($GLOBALS['_page_number'])) {
			return self::PaginationPosition() == 1;
		}
		
		return true;
	}
	
	public static function PaginationEnd()
	{
		if (isset($GLOBALS['_page_number'])) {
			return self::PaginationPosition() == self::PaginationNbPages();
		}
		
		return false;
	}
	
	public static function PaginationURL($offset=0)
	{
		$args = $_SERVER['DC_REQUEST_PART'];
		
		$n = self::PaginationPosition($offset);
		
		$args = preg_replace('#(^|/)page/([0-9]+)$#','',$args);
		
		$url = $GLOBALS['core']->blog->url.$args;
		
		if ($n > 1) {
			$url = preg_replace('#/$#','',$url);
			$url .= '/page/'.$n;
		}
		
		# If search param
		if (!empty($_GET['q'])) {
			$s = strpos($url,'?') !== false ? '&amp;' : '?';
			$url .= $s.'q='.rawurlencode($_GET['q']);
		}
		return $url;
	}
	
	# Smilies static methods
	public static function getSmilies(&$blog)
	{
		$path = array();
		if (isset($GLOBALS['__theme'])) {
			$path[] = $GLOBALS['__theme'];
		}
		$path[] = 'default';
		$definition = $blog->themes_path.'/%s/smilies/smilies.txt';
		$base_url = $blog->settings->themes_url.'/%s/smilies/';
		
		$res = array();
		
		foreach ($path as $t)
		{
			if (file_exists(sprintf($definition,$t))) {
				$base_url = sprintf($base_url,$t);
				return self::smiliesDefinition(sprintf($definition,$t),$base_url);
			}
		}
		return false;
	}
	
	public static function smiliesDefinition($f,$url)
	{
		$def = file($f);
			
		$res = array();
		foreach($def as $v)
		{
			$v = trim($v);
			if (preg_match('|^([^\t]*)[\t]+(.*)$|',$v,$matches))
			{
				$r = '/(\A|[\s]+|>)('.preg_quote($matches[1],'/').')([\s]+|[<]|\Z)/ms';
				$s = '$1<img src="'.$url.$matches[2].'" '.
				'alt="$2" class="smiley" />$3';
				$res[$r] = $s;
			}
		}
		
		return $res;
	}
	
	public static function addSmilies($str)
	{
		if (!isset($GLOBALS['__smilies']) || !is_array($GLOBALS['__smilies'])) {
			return $str;
		}
		
		return preg_replace(array_keys($GLOBALS['__smilies']),array_values($GLOBALS['__smilies']),$str);
	}
}
?>