<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

/*== DC_DEBUG ==
ini_set('display_errors',true);
error_reporting(E_ALL | E_STRICT);
define('DC_DEBUG',true);
//*/

if (!defined('DC_DEBUG')) {
	define('DC_DEBUG',false);
}

mb_internal_encoding('UTF-8');

# Setting timezone (PHP 5.1 strict)
putenv('TZ=UTC');

if (isset($_SERVER['DC_RC_PATH'])) {
	define('DC_RC_PATH',$_SERVER['DC_RC_PATH']);
} elseif (isset($_SERVER['REDIRECT_DC_RC_PATH'])) {
	define('DC_RC_PATH',$_SERVER['REDIRECT_DC_RC_PATH']);
} else {
	define('DC_RC_PATH',dirname(__FILE__).'/config.php');
}

if (!is_file(DC_RC_PATH)) {
	trigger_error('Unable to open config file',E_USER_ERROR);
	exit;
}

require DC_RC_PATH;

require_once dirname(__FILE__).'/clearbricks/lib.l10n.php';
require_once dirname(__FILE__).'/clearbricks/lib.date.php';
require_once dirname(__FILE__).'/clearbricks/lib.files.php';
require_once dirname(__FILE__).'/clearbricks/lib.crypt.php';

# Constants
define('DC_ROOT',path::real(dirname(__FILE__).'/..'));
define('DC_VERSION','2.0-beta1');
define('DC_L10N_ROOT',dirname(__FILE__).'/../locales');

if (!defined('DC_VENDOR_NAME')) {
	define('DC_VENDOR_NAME','DotClear');
}

if (!defined('DC_SINGLE_SIGNON')) {
	define('DC_SINGLE_SIGNON',false);
}

# Database layer
if (file_exists(dirname(__FILE__).'/clearbricks/dblayer/class.'.DC_DBDRIVER.'.php')) {
	require dirname(__FILE__).'/clearbricks/dblayer/class.'.DC_DBDRIVER.'.php';
} else {
	trigger_error('Unable to load DB layer for '.DC_DBDRIVER,E_USER_ERROR);
	exit(1);
}

require_once dirname(__FILE__).'/core/class.dc.core.php';

try {
	$core = new dcCore(DC_DBHOST,DC_DBNAME,DC_DBUSER,DC_DBPASSWORD,DC_DBPREFIX);
} catch (Exception $e) {
	trigger_error($e->getMessage(),E_USER_ERROR);
	exit;
}

# If we have some __top_behaviors, we load them
if (isset($__top_behaviors) && is_array($__top_behaviors))
{
	foreach ($__top_behaviors as $b) {
		$core->addBehavior($b[0],$b[1]);
	}
	unset($b);
}

http::trimRequest();
try {
	http::unsetGlobals();
} catch (Exception $e) {
	header('Content-Type: text/plain');
	echo $e->getMessage();
	exit;
}

l10n::init();

$core->url->registerDefault(array('dcUrlHandlers','home'));
$core->url->register('lang','','^([a-zA-Z]{2}(?:-[a-z]{2})?(?:/page/[0-9]+)?)$',array('dcUrlHandlers','lang'));
$core->url->register('post','post','^post/(.+)$',array('dcUrlHandlers','post'));
$core->url->register('category','category','^category/(.+)$',array('dcUrlHandlers','category'));
$core->url->register('archive','archive','^archive(/.+)?$',array('dcUrlHandlers','archive'));

$core->url->register('feed','feed','^feed/(.+)$',array('dcUrlHandlers','feed'));
$core->url->register('trackback','trackback','^trackback/(.+)$',array('dcUrlHandlers','trackback'));
$core->url->register('xmlrpc','xmlrpc','^xmlrpc(?:/?)$',array('dcUrlHandlers','xmlrpc'));

# Store upload_max_filesize in bytes
define('DC_MAX_UPLOAD_SIZE',files::str2bytes(ini_get('upload_max_filesize')));

# Shutdown
register_shutdown_function('_shutdown');

function _shutdown()
{
	global $__shutdown;
	if (is_array($__shutdown)) {
		foreach ($__shutdown as $f) {
			if (is_callable($f)) {
				call_user_func($f);
			}
		}
	}
	$GLOBALS['core']->con->close();
}
?>