<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

if (isset($_SERVER['DC_RC_PATH'])) {
	define('DC_RC_PATH',$_SERVER['DC_RC_PATH']);
} elseif (isset($_SERVER['REDIRECT_DC_RC_PATH'])) {
	define('DC_RC_PATH',$_SERVER['REDIRECT_DC_RC_PATH']);
} else {
	define('DC_RC_PATH',dirname(__FILE__).'/config.php');
}

if (!is_file(DC_RC_PATH)) {
	trigger_error('Unable to open config file',E_USER_ERROR);
	exit;
}

require DC_RC_PATH;

require dirname(__FILE__).'/clearbricks/lib.files.php';
require dirname(__FILE__).'/clearbricks/lib.http.php';

if (empty($_GET['pf'])) {
	header('Content-Type: text/plain');
	http::head(404,'Not Found');
	exit;
}

$allow_types = array('png','jpg','jpeg','gif','css','js');

$pf = path::clean($_GET['pf']);
$pf = path::real(DC_PLUGINS_ROOT.'/'.$pf);

if (!is_file($pf) || !is_readable($pf)) {
	header('Content-Type: text/plain');
	http::head(404,'Not Found');
	exit;
}

if (!in_array(files::getExtension($pf),$allow_types)) {
	header('Content-Type: text/plain');
	http::head(404,'Not Found');
	exit;
}

http::cache(array_merge(array($pf),get_included_files()));

header('Content-Type: '.files::getMimeType($pf));
readfile($pf);
exit;
?>