<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

class dcSettings
{
	private $con;
	private $table;
	private $blog_id;
	private $settings = array();
	private $ns;
	
	public function __construct(&$core,$blog_id)
	{
		$this->con =& $core->con;
		$this->table = $core->prefix.'setting';
		$this->blog_id =& $blog_id;
		
		$this->getSettings();
	}
	
	private function getSettings()
	{
		$strReq = 'SELECT setting_id, setting_ns, setting_value, '.
				'setting_type, setting_label '.
				'FROM '.$this->table.' '.
				"WHERE blog_id = '".$this->con->escapeStr($this->blog_id)."' ".
				'ORDER BY setting_ns, setting_id DESC ';
		
		try {
			$rs = $this->con->select($strReq);
		} catch (Exception $e) {
			trigger_error(__('Unable to retrieve settings: ').$this->con->error(), E_USER_ERROR);
		}
		
		while ($rs->fetch())
		{
			$id = trim($rs->f('setting_id'));
			$value = $rs->f('setting_value');
			$type = $rs->f('setting_type');
			
			if ($type == 'float' || $type == 'double') {
				$type = 'float';
			} elseif ($type != 'boolean' && $type != 'integer') {
				$type = 'string';
			}
			
			settype($value,$type);
			
			$this->settings[$id] = array(
				'ns' => $rs->f('setting_ns'),
				'value' => $value,
				'type' => $type,
				'label' => (string) $rs->f('setting_label')
			);
		}
			
		return true;
	}
	
	private function settingExists($id)
	{
		return isset($this->settings[$id]);
	}
	
	public function setNamespace($ns)
	{
		if (preg_match('/^[a-z]+$/',$ns)) {
			$this->ns = $ns;
		}
	}
	
	public function put($id,$value,$type=null,$label=null,$value_change=true)
	{
		if (!$this->ns) {
			throw new Exception(__('No namespace specified'));
		}
		
		if (!preg_match('/^[a-zA-Z][a-zA-Z0-9_]+$/',$id)) {
			throw new Exception(sprintf(__('%s is not a valid setting id'),$id));
		}
		
		if ($this->settingExists($id) && !$value_change) {
			$value = $this->settings[$id]['value'];
		}
		
		if ($type == 'double')
		{
			$type = 'float';
		}
		elseif ($type === null)
		{
			if ($this->settingExists($id)) {
				$type = $this->settings[$id]['type'];
			} else {
				$type = 'string';
			}
		}
		elseif ($type != 'boolean' && $type != 'integer' && $type != 'float')
		{
			$type = 'string';
		}
		
		if ($label == null) {
			if ($this->settingExists($id)) {
				$label = $this->settings[$id]['label'];
			}
		}
		
		settype($value,$type);
		
		$cur = $this->con->openCursor($this->table);
		$cur->setting_value = ($type == 'boolean') ? (string) (integer) $value : (string) $value;
		$cur->setting_type = $type;
		$cur->setting_label = $label;
		
		if ($this->settingExists($id) && $this->ns == $this->settings[$id]['ns'])
		{
			
			
			try {
				$cur->update(
				"WHERE blog_id = '".$this->con->escapeStr($this->blog_id)."' ".
				"AND setting_id = '".$this->con->escapeStr($id)."' "
				);
			} catch (Exception $e) {
				throw $e;
			}
		}
		else
		{
			$cur->setting_id = $id;
			$cur->blog_id = $this->blog_id;
			$cur->setting_ns = $this->ns;
			
			try {
				$cur->insert();
			} catch (Exception $e) {
				throw $e;
			}
		}
	}
	
	public function get($n)
	{
		if (isset($this->settings[$n]['value'])) {
			return $this->settings[$n]['value'];
		}
		
		return null;
	}
	
	public function __get($n)
	{
		return $this->get($n);
	}
	
	public function set($n,$v)
	{
		if (isset($this->settings[$n])) {
			$this->settings[$n]['value'] = $v;
		}
	}
	
	public function __set($n,$v)
	{
		$this->set($n,$v);
	}
	
	public function dumpSettings()
	{
		return $this->settings;
		$id = $ns = array();
		
		foreach ($res as $k => $v) {
			$id[$k] = $k;
			$ns[$k] = $v['ns'];
		}
		
		array_multisort($ns,SORT_ASC,$id,SORT_ASC,$res);
		
		return $res;
	}
}
?>