<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

class dcError
{
	private $errors = array();
	private $flag;
	
	private $html_list;
	private $html_item;
	
	public function __construct()
	{
		$this->flag = false;
		$this->code = 0;
		$this->msg = '';
		
		$this->html_list = "<ul>\n%s</ul>\n";
		$this->html_item = "<li>%s</li>\n";
	}
	
	public function add($msg)
	{
		$this->flag = true;
		$this->errors[] = $msg;
	}
	
	public function flag()
	{
		return $this->flag;
	}
	
	public function reset()
	{
		$this->flag = false;
		$this->errors = array();
	}
	
	public function getErrors()
	{
		return $this->errors;
	}
	
	public function setHTMLFormat($list,$item)
	{
		$this->html_list = $list;
		$this->html_item = $item;
	}
	
	public function toHTML()
	{
		$res = '';
		
		if ($this->flag)
		{
			foreach ($this->errors as $msg)
			{
				$res .= sprintf($this->html_item,$msg);
			}
			
			$res = sprintf($this->html_list,$res);
		}
		
		return $res;
	}
	
	public function __toString()
	{
		$res = '';
		
		foreach ($this->errors as $msg)
		{
			$res .= $msg."\n";
		}
				
		return $res;
	}
}
?>