<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

class dcAuth
{
	private $con;
	private $user_table;
	private $perm_table;
	
	private $user_id;
	private $user_info = array();
	private $user_options = array();
	private $user_admin;
	private $permissions = array();
	
	private $redirect;
	
	private $perm_types;
	
	public function __construct(&$core)
	{
		$this->core =& $core;
		$this->con =& $core->con;
		$this->blog_table = $core->prefix.'blog';
		$this->user_table = $core->prefix.'user';
		$this->perm_table = $core->prefix.'permissions';
		
		$this->perm_types = array(
			'admin' => __('administrator'),
			'usage' => __('manage their own entries and comments'),
			'publish' => __('publish entries and comments'),
			'delete' => __('delete entries and comments'),
			'contentadmin' => __('manage all entries and comments'),
			'categories' => __('manage categories'),
			'media' => __('manage their own media items'),
			'media_admin' => __('manage all media items')
		);
	}
	
	public function checkUser($user_id, $pwd=null, $user_key=null)
	{
		# Check user and password
		$strReq = 'SELECT user_id, user_super, user_pwd, user_name, '.
				'user_firstname, user_displayname, user_email, user_url, '.
				'user_default_blog, user_options, '.
				'user_lang, user_tz, user_post_status, user_creadt, user_upddt '.
				'FROM '.$this->con->escapeSystem($this->user_table).' '.
				"WHERE user_id = '".$this->con->escapeStr($user_id)."' ";
		
		$rs = $this->con->select($strReq);
		
		if ($rs->isEmpty()) {
			return false;
		}
		
		$rs->extend('rsExtUser');
		
		if ($pwd != '')
		{
			if (crypt::hmac(DC_MASTER_KEY,$pwd) != $rs->user_pwd) {
				return false;
			}
		}
		elseif ($user_key != '')
		{
			if (crypt::hmac(DC_MASTER_KEY,
				$rs->user_id.
				$rs->user_pwd.
				http::realIP().
				$_SERVER['HTTP_USER_AGENT']
			) != $user_key) {
				return false;
			}
		}
		
		$this->user_id = $rs->user_id;
		$this->user_admin = (boolean) $rs->user_super;
		
		$this->user_info['user_pwd'] = $rs->user_pwd;
		$this->user_info['user_name'] = $rs->user_name;
		$this->user_info['user_firstname'] = $rs->user_firstname;
		$this->user_info['user_displayname'] = $rs->user_displayname;
		$this->user_info['user_email'] = $rs->user_email;
		$this->user_info['user_url'] = $rs->user_url;
		$this->user_info['user_default_blog'] = $rs->user_default_blog;
		$this->user_info['user_lang'] = $rs->user_lang;
		$this->user_info['user_tz'] = $rs->user_tz;
		$this->user_info['user_post_status'] = $rs->user_post_status;
		$this->user_info['user_creadt'] = $rs->user_creadt;
		$this->user_info['user_upddt'] = $rs->user_upddt;
		
		$this->user_info['user_cn'] = dcUtils::getUserCN($rs->user_id, $rs->user_name,
		$rs->user_firstname, $rs->user_displayname);
		
		$this->user_options = array_merge($this->core->userDefaults(),$rs->options());
		
		# Get permissions on blogs
		if ($this->user_admin)
		{
			$strReq = 'SELECT blog_id, blog_name, blog_url '.
					'FROM '.$this->blog_table.' ';
			
			$rs = $this->con->select($strReq);
			
			if ($rs->isEmpty()) {
				return false;
			}
			
			while ($rs->fetch()) {
				$this->blogs[$rs->blog_id]['permissions'] = array('admin' => true);
				$this->blogs[$rs->blog_id]['name'] = $rs->blog_name;
				$this->blogs[$rs->blog_id]['url'] = $rs->blog_url;
			}
		}
		else
		{
			$strReq = 'SELECT B.blog_id, blog_name, blog_url, permissions '.
					'FROM '.$this->con->escapeSystem($this->perm_table).' P, '.
					$this->blog_table.' B '.
					'WHERE B.blog_id = P.blog_id '.
					'AND B.blog_status IN (1,0) '.
					"AND user_id = '".$this->con->escapeStr($this->user_id)."' ";
			
			$rs = $this->con->select($strReq);
			
			if ($rs->isEmpty()) {
				return false;
			}
			
			while ($rs->fetch()) {
				$this->blogs[$rs->blog_id]['permissions'] = $this->parsePermissions($rs->permissions);
				$this->blogs[$rs->blog_id]['name'] = $rs->blog_name;
				$this->blogs[$rs->blog_id]['url'] = $rs->blog_url;
			}
		}
		
		return true;
	}
	
	public function checkPassword($pwd)
	{
		if (!empty($this->user_info['user_pwd'])) {
			return $pwd == $this->user_info['user_pwd'];
		}
		
		return false;
	}
	
	public function isUserSet()
	{
		return isset($this->user['user_id']);
	}
	
	# Is user super admin?
	public function isSuperAdmin()
	{
		return $this->user_admin;
	}
	
	# Get permissions
	public function getPermissions()
	{
		return $this->blogs;
	}
	
	# Get user ID
	public function userID()
	{
		return $this->user_id;
	}
	
	public function parsePermissions($level)
	{
		$level = preg_replace('/^\|/','',$level);
		$level = preg_replace('/\|$/','',$level);
		
		$res = array();
		foreach (explode('|',$level) as $v) {
			$res[$v] = true;
		}
		return $res;
	}
	
	
	# Check permissions on a blog
	public function check($permissions,$blog_id)
	{
		if ($this->user_admin) {
			return true;
		}
		
		$p = explode(',',$permissions);
		
		if (isset($this->blogs[$blog_id]))
		{
			if (isset($this->blogs[$blog_id]['permissions']['admin'])) {
				return true;
			}
			
			foreach ($p as $v)
			{
				if (isset($this->blogs[$blog_id]['permissions'][$v])) {
					return true;
				}
			}
		}
		
		return false;
	}
	
	# Get permissions types
	public function getPermissionsTypes()
	{
		return $this->perm_types;
	}
	
	# Set a type
	public function setPermissionType($name,$title)
	{
		$this->perm_types[$name] = $title;
	}
	
	# Get user info
	public function getInfo($n)
	{
		if (isset($this->user_info[$n])) {
			return $this->user_info[$n];
		}
		
		return null;
	}
	
	public function getOption($n)
	{
		if (isset($this->user_options[$n])) {
			return $this->user_options[$n];
		}
		return null;
	}
	
	public function getOptions()
	{
		return $this->user_options;
	}
	
	# Recover password
	public function setRecoverKey($user_id,$user_email)
	{
		$strReq = 'SELECT user_id '.
				'FROM '.$this->user_table.' '.
				"WHERE user_id = '".$this->con->escapeStr($user_id)."' ".
				"AND user_email = '".$this->con->escapeStr($user_email)."' ";
		
		$rs = $this->con->select($strReq);
		
		if ($rs->isEmpty()) {
			throw new Exception(__('That user does not exists in the database.'));
		}
		
		$key = md5(uniqid());
		
		$cur = $this->con->openCursor($this->user_table);
		$cur->user_recover_key = $key;
		
		$cur->update("WHERE user_id = '".$this->con->escapeStr($user_id)."'");
		
		return $key;
	}
	
	public function recoverUserPassword($recover_key)
	{
		$strReq = 'SELECT user_id, user_email '.
				'FROM '.$this->user_table.' '.
				"WHERE user_recover_key = '".$this->con->escapeStr($recover_key)."' ";
		
		$rs = $this->con->select($strReq);
		
		if ($rs->isEmpty()) {
			throw new Exception(__('That key does not exists in the database.'));
		}
		
		$new_pass = crypt::createPassword();
		
		$cur = $this->con->openCursor($this->user_table);
		$cur->user_pwd = crypt::hmac(DC_MASTER_KEY,$new_pass);
		$cur->user_recover_key = null;
		
		$cur->update("WHERE user_recover_key = '".$this->con->escapeStr($recover_key)."'");
		
		return array('user_email' => $rs->user_email, 'user_id' => $rs->user_id, 'new_pass' => $new_pass);
	}
}
?>