<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of Clearbricks.
# Copyright (c) 2004 Olivier Meunier and contributors. All rights
# reserved.
#
# Clearbricks is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# Clearbricks is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Clearbricks; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

class text
{
	/**
	@function isEmail
	
	Checks if "str" var is a valid email address.
	
	@param str	string		Email string
	@return boolean
	*/
	public static function isEmail($str)
	{
		return preg_match('/^[a-zA-Z0-9_+-]+(\.[a-zA-Z0-9_+-]+)*@[a-zA-Z0-9-]+(\.[a-zA-Z0-9-]+)*$/',$str);
	}
	
	/**
	@function str2URL
	
	Transforms a string to a proper URL.
	
	@param str			string		String to transform
	@param with_slashes		boolean		Keep slashes in URL
	@return string
	*/
	public static function str2URL($str,$with_slashes=true)
	{
		$pattern['A'] = '\x{00C0}-\x{00C5}';
		$pattern['AE'] = '\x{00C6}';
		$pattern['C'] = '\x{00C7}';
		$pattern['D'] = '\x{00D0}';
		$pattern['E'] = '\x{00C8}-\x{00CB}';
		$pattern['I'] = '\x{00CC}-\x{00CF}';
		$pattern['N'] = '\x{00D1}';
		$pattern['O'] = '\x{00D2}-\x{00D6}\x{00D8}';
		$pattern['OE'] = '\x{0152}';
		$pattern['S'] = '\x{0160}';
		$pattern['U'] = '\x{00D9}-\x{00DC}';
		$pattern['Y'] = '\x{00DD}';
		$pattern['Z'] = '\x{017D}';
		
		$pattern['a'] = '\x{00E0}-\x{00E5}';
		$pattern['ae'] = '\x{00E6}';
		$pattern['c'] = '\x{00E7}';
		$pattern['d'] = '\x{00F0}';
		$pattern['e'] = '\x{00E8}-\x{00EB}';
		$pattern['i'] = '\x{00EC}-\x{00EF}';
		$pattern['n'] = '\x{00F1}';
		$pattern['o'] = '\x{00F2}-\x{00F6}\x{00F8}';
		$pattern['oe'] = '\x{0153}';
		$pattern['s'] = '\x{0161}';
		$pattern['u'] = '\x{00F9}-\x{00FC}';
		$pattern['y'] = '\x{00FD}\x{00FF}';
		$pattern['z'] = '\x{017E}';
		
		$pattern['ss'] = '\x{00DF}';
		
		foreach ($pattern as $r => $p) {
			$str = preg_replace('/['.$p.']/u',$r,$str);
		}
		
		$str = preg_replace('/[^A-Za-z0-9_\s\'\:\/[\]-]/','',$str);
		
		return self::tidyURL($str,$with_slashes);
	}
	
	/**
	@function tidyURL
	
	Cleans an URL.
	
	@param str			string		URL to tidy
	@param keep_slashes		boolean		Keep slashes in URL
	@param keep_spaces		boolean		Keep spaces in URL
	@return string
	*/
	public static function tidyURL($str,$keep_slashes=true,$keep_spaces=false)
	{
		$str = strip_tags($str);
		$str = str_replace(array('?','&','#','=','+','<','>'),'',$str);
		$str = str_replace("'",'',$str);
		$str = preg_replace('/[\s]+/',' ',trim($str));
		
		if (!$keep_slashes) {
			$str = str_replace('/','-',$str);
		}
		
		if (!$keep_spaces) {
			$str = str_replace(' ','-',$str);
		}
		
		$str = preg_replace('/[-]+/','-',$str);
		
		return $str;
	}
	
	/**
	@function cutString
	
	Cuts a string on spaces.
	
	@param	string	str		String to cut
	@param	integer	l		Lenght to keep
	@return	string
	*/
	public static function cutString($str,$l)
	{
		$s = preg_split('/([\s]+)/u',$str,-1,PREG_SPLIT_DELIM_CAPTURE);
		
		$res = '';
		$L = 0;
		
		if (strlen($s[0]) >= $l) {
			return substr($s[0],0,$l);
		}
		
		foreach ($s as $v)
		{
			$L = $L+strlen($v);
			
			if ($L > $l) {
				break;
			} else {
				$res .= $v;
			}
		}
		
		return trim($res);
	}
	
	/**
	@function splitWords
	
	Returns an array of words from a given string.
	
	@param str	string	Words to split
	@return array
	*/
	public static function splitWords($str)
	{
		$non_word = '\x{0000}-\x{002F}\x{003A}-\x{0040}\x{005b}-\x{0060}\x{007B}-\x{007E}\x{00A0}-\x{00BF}\s';
		if (preg_match_all('/([^'.$non_word.']{3,})/msu',html::clean($str),$match)) {
			foreach ($match[1] as $i => $v) {
				$match[1][$i] = mb_strtolower($v);
			}
			return $match[1];
		}
		return array();
	}
}
?>