<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of Clearbricks.
# Copyright (c) 2004 Olivier Meunier and contributors. All rights
# reserved.
#
# Clearbricks is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# Clearbricks is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Clearbricks; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

class xmlsql
{
	private $con;
	private $xml;
	
	private $tables;
	
	public function __construct(&$con,$xml)
	{
		$this->con =& $con;
		$this->xml = $xml;
		
		$this->tables = $this->con->getTables();
	}
	
	public function replace($str,$rep)
	{
		$this->xml = str_replace($str,$rep,$this->xml);
	}
	
	public function execute()
	{
		$x = simplexml_load_string($this->xml);
		
		foreach ($x->action as $d)
		{
			$test = array(
				'result' => true,
				'alert' => true,
				'label' => '',
				'string' => 'Unknown error'
			);
			
			# Perform tests
			if (isset($d->testTable['name']))
			{
				$test['result'] = in_array($d->testTable['name'],$this->tables);
				
				$test['label'] = 'Table %s already exists';
				$test['string'] = (string) $d->testTable['name'];
				
				$xtest = $d->testTable;
			}
			elseif (isset($d->testColumn['table']) && isset($d->testColumn['name']))
			{
				$C = $this->con->getColumns($d->testColumn['table']);
				
				$test['result'] = isset($C[(string) $d->testColumn['name']]);
				
				$test['label'] = 'Column %s already exists';
				$test['string'] = (string) $d->testColumn['table'].'.'.(string) $d->testColumn['name'];
				
				$xtest = $d->testColumn;
			}
			elseif (trim((string) $d->test) != '' && isset($d->test['value']))
			{
				$r = trim((string) $d->test);
				$rs = $this->con->select($r);
				
				$test['result'] = !$rs->isEmpty() && $rs->f(0) == $d->test['value'];
				
				$xtest = $d->test->attributes();
			}
			
			# End tests
			if (isset($xtest))
			{
				if ($xtest['eq'] == 'neq') {
					$test['result'] = !$test['result'];
				}
				
				if (isset($xtest['alert'])) {
					$test['alert'] = (boolean) (integer) $xtest['alert'];
				}
				
				if (isset($xtest['label']) && isset($xtest['string'])) {
					$test['label'] = (string) $xtest['label'];
					$test['string'] = (string) $xtest['string'];
				}
				unset($xtest);
			}
			
			
			
			# Test false
			if (!$test['result'])
			{
				if ($test['alert']) {
					throw new Exception(sprintf($test['label'],$test['string']));
				}
			}
			else
			{
				$req = trim((string) $d);
				if ($req)
				{
					try {
						$this->con->execute($req);
					} catch (Exception $e) {
						if ($d['silent'] != 1) {
							throw $e;
						}
					}
				}
			}
		}
	}
}
?>