<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/../inc/admin/prepend.php';

dcPage::checkSuper();

# Filters
$sortby_combo = array(
__('Blog ID') => 'B.blog_id',
__('Blog name') => 'blog_name'
);

$order_combo = array(
__('Descending') => 'desc',
__('Ascending') => 'asc'
);

$q = !empty($_GET['q']) ? $_GET['q'] : '';
$sortby = !empty($_GET['sortby']) ? $_GET['sortby'] : 'blog_id';
$order = !empty($_GET['order']) ? $_GET['order'] : 'asc';


# Check users
if (!empty($_REQUEST['user_id']) && is_array($_REQUEST['user_id']))
{
	foreach ($_REQUEST['user_id'] as $u)
	{
		if ($core->userExists($u)) {
			$users[] = $u;
		}
	}
}

if (empty($users))
{
	$core->error->add(__('No blog or user given.'));
}
else
{
	$page = !empty($_GET['page']) ? $_GET['page'] : 1;
	$nb_per_page =  30;
	
	if (!empty($_GET['nb']) && (integer) $_GET['nb'] > 0) {
		$nb_per_page = $_GET['nb'];
	}
	
	$show_filters = false;
	
	# - Search filter
	if ($q) {
		$params['q'] = $q;
		$show_filters = true;
	}
	
	# - Sortby and order filter
	if ($sortby !== '' && in_array($sortby,$sortby_combo)) {
		if ($order !== '' && in_array($order,$order_combo)) {
			$params['order'] = $sortby.' '.$order;
			$show_filters = true;
		}
	}
	
	$params['limit'] = array((($page-1)*$nb_per_page),$nb_per_page);
	
	try {
		$rs = $core->getBlogs($params);
		$counter = $core->getBlogs($params,1);
		$nb_blog = $counter->f(0);
	} catch (Exception $e) {
		$core->error->add($e->getMessage());
	}
}

/* DISPLAY
-------------------------------------------------------- */
$starting_script = '';
if (!$show_filters) {
	$starting_script .= '<script type="text/javascript" src="js/filter-controls.js"></script>'."\n";
}
dcPage::open(__('choose a blog'),$starting_script);

echo '<h2><a href="users.php">'.__('Users').'</a> &gt; '.__('Choose a blog').'</h2>';

if (!$core->error->flag())
{
	$hidden_fields = '';
	foreach ($users as $u) {
		$hidden_fields .= form::hidden(array('user_id[]'),$u);
	}
	
	if (!$show_filters) {
		echo '<p><a id="filter-control" class="form-control" href="#">'.__('Filters').'</a></p>';
	}
	
	echo
	'<form action="permissions_blog.php" method="get" id="filters-form">'.
	'<fieldset class="two-cols"><legend>'.__('Filters').'</legend>'.
	
	'<div class="col">'.
	'<p><label>'.__('Order by:').' '.
	form::combo('sortby',$sortby_combo,html::escapeHTML($sortby)).
	'</label> '.
	'<label>'.__('Sort').' '.
	form::combo('order',$order_combo,html::escapeHTML($order)).
	'</label></p>'.
	'</div>'.
	
	'<div class="col">'.
	'<p><label>'.__('Search:').' '.
	form::field('q',20,255,html::escapeHTML($q)).
	'</label></p>'.
	'<p><label class="classic">'.	form::field('nb',3,3,$nb_per_page).' '.
	__('Entries per page').'</label> '.
	'<input type="submit" value="'.__('filter').'" />'.
	$hidden_fields.'</p>'.
	'</div>'.
	
	'<br class="clear" />'. //Opera sucks
	'</fieldset>'.
	'</form>';
	
	echo
	'<p>'.
	sprintf(__('Choose one or more blogs to which you want to give permissions to users %s.'),
	'<strong>'.implode(', ',$users).'</strong>').'</p>';
	
	# Show blogs
	if ($nb_blog == 0)
	{
		echo '<p><strong>'.__('No blog').'</strong></p>';
	}
	else
	{
		$pager = new pager($page,$nb_blog,$nb_per_page,10);
		$pager->var_page = 'page';
		
		echo '<p>'.__('Page(s)').' : '.$pager->getLinks().'</p>';
		
		echo
		'<form action="permissions.php" method="post" id="form-blogs">'.
		'<table class="clear"><tr>'.
		'<th colspan="2">'.__('Blog ID').'</th>'.
		'<th>'.__('Blog name').'</th>'.
		'<th class="nowrap">'.__('Number of posts').'</th>'.
		'</tr>';
		
		while ($rs->fetch()) {
			echo blogLine($rs);
		}
		
		echo
		'</table>'.
		
		'<p><a href="#" onclick="return checkBoxes(\'form-blogs\',\'all\');">'.
		__('select all blogs').'</a> - '.
		'<a href="#" onclick="return checkBoxes(\'form-blogs\',\'invert\');">'.
		__('invert selection').'</a></p>'.
		
		'<p><input type="submit" value="'.__('set permissions').'" />'.
		$hidden_fields.'</p>'.
		'</form>';
		
		echo '<p>'.__('Page(s)').' : '.$pager->getLinks().'</p>';
	}
}

dcPage::close();

function blogLine(&$rs)
{
	return
	'<tr class="line">'.
	'<td class="nowrap">'.
	form::checkbox(array('blog_id[]'),$rs->blog_id).'</td>'.
	'<td class="nowrap">'.$rs->blog_id.'</td>'.
	'<td class="maximal">'.html::escapeHTML($rs->blog_name).'</td>'.
	'<td class="nowrap">'.$rs->nb_post.'</td>'.
	'</tr>';
}
?>