<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/../inc/admin/prepend.php';

dcPage::check('usage,contentadmin');

# Filters
$sortby_combo = array(
__('Blog ID') => 'B.blog_id',
__('Blog name') => 'UPPER(blog_name)',
__('Last update') => 'blog_upddt'
);

$order_combo = array(
__('Descending') => 'desc',
__('Ascending') => 'asc'
);

$q = !empty($_GET['q']) ? $_GET['q'] : '';
$sortby = !empty($_GET['sortby']) ? $_GET['sortby'] : 'blog_id';
$order = !empty($_GET['order']) ? $_GET['order'] : 'asc';

$page = !empty($_GET['page']) ? $_GET['page'] : 1;
$nb_per_page =  30;

if (!empty($_GET['nb']) && (integer) $_GET['nb'] > 0) {
	$nb_per_page = $_GET['nb'];
}

$show_filters = false;
	
# - Search filter
if ($q) {
	$params['q'] = $q;
	$show_filters = true;
}

# - Sortby and order filter
if ($sortby !== '' && in_array($sortby,$sortby_combo)) {
	if ($order !== '' && in_array($order,$order_combo)) {
		$params['order'] = $sortby.' '.$order;
		$show_filters = true;
	}
}

$params['limit'] = array((($page-1)*$nb_per_page),$nb_per_page);

try {
	$counter = $core->getBlogs($params,1);
	$rs = $core->getBlogs($params);
	$nb_blog = $counter->f(0);
} catch (Exception $e) {
	$core->error->add($e->getMessage());
}

/* DISPLAY
-------------------------------------------------------- */
$starting_script = '';
if (!$show_filters) {
	$starting_script .= '<script type="text/javascript" src="js/filter-controls.js"></script>'."\n";
}
dcPage::open(__('List of blogs'),$starting_script);

if (!empty($_GET['del'])) {
	echo '<p class="message">'.__('Blog has been successfully deleted.').'</p>';
}

echo '<h2>'.__('List of blogs').'</h2>';

if (!$core->error->flag())
{
	if ($core->auth->isSuperAdmin()) {
		echo '<p><strong><a href="blog.php">'.__('Create a new blog').'</a></strong></p>';
	}
	
	if (!$show_filters) {
		echo '<p><a id="filter-control" class="form-control" href="#">'.__('Filters').'</a></p>';
	}
	
	echo
	'<form action="blogs.php" method="get" id="filters-form">'.
	'<fieldset class="two-cols"><legend>'.__('Filters').'</legend>'.
	
	'<div class="col">'.
	'<p><label>'.__('Order by:').' '.
	form::combo('sortby',$sortby_combo,html::escapeHTML($sortby)).
	'</label> '.
	'<label>'.__('Sort').' '.
	form::combo('order',$order_combo,html::escapeHTML($order)).
	'</label></p>'.
	'</div>'.
	
	'<div class="col">'.
	'<p><label>'.__('Search:').' '.
	form::field('q',20,255,html::escapeHTML($q)).
	'</label></p>'.
	'<p><label class="classic">'.	form::field('nb',3,3,$nb_per_page).' '.
	__('Blogs per page').'</label> '.
	'<input type="submit" value="'.__('filter').'" /></p>'.
	'</div>'.
	
	'<br class="clear" />'. //Opera sucks
	'</fieldset>'.
	'</form>';
	
	# Show blogs
	if ($nb_blog == 0)
	{
		echo '<p><strong>'.__('No blog').'</strong></p>';
	}
	else
	{
		$pager = new pager($page,$nb_blog,$nb_per_page,10);
		$pager->var_page = 'page';
		
		echo '<p>'.__('Page(s)').' : '.$pager->getLinks().'</p>';
		
		echo
		'<table class="clear"><tr>'.
		'<th>'.__('Blog name').'</th>'.
		'<th class="nowrap">'.__('Last update').'</th>'.
		'<th class="nowrap">'.__('Entries').'</th>'.
		'<th class="nowrap">'.__('Blog ID').'</th>'.
		'<th>&nbsp;</th>'.
		'</tr>';
		
		while ($rs->fetch()) {
			echo blogLine($rs);
		}
		
		echo '</table>';
		
		echo '<p>'.__('Page(s)').' : '.$pager->getLinks().'</p>';
	}
}

dcPage::close();

function blogLine(&$rs)
{
	$blog_id = html::escapeHTML($rs->blog_id);
	
	$edit_link = '';
	
	if ($GLOBALS['core']->auth->isSuperAdmin()) {
		$edit_link = 
		'<a href="blog.php?id='.$blog_id.'" '.
		'title="'.sprintf(__('Edit blog %s'),$blog_id).'">'.
		__('edit').'</a>';
	}
	
	return
	'<tr class="line">'.
	'<td class="maximal"><a href="index.php?switchblog='.$rs->blog_id.'" '.
	'title="'.sprintf(__('Switch to blog %s'),$rs->blog_id).'">'.
	html::escapeHTML($rs->blog_name).'</a></td>'.
	'<td class="nowrap">'.dt::dt2str(__('%Y-%m-%d %H:%M'),$rs->blog_upddt).'</td>'.
	'<td class="nowrap">'.$rs->nb_post.'</td>'.
	'<td class="nowrap">'.$blog_id.'</td>'.
	'<td>'.$edit_link.'</td>'.
	'</tr>';
}
?>