/* ChainHandler, py Peter van der Beken
-------------------------------------------------------- */
function chainHandler(obj, handlerName, handler) {
	obj[handlerName] = (function(existingFunction) {
		return function() {
			handler.apply(this, arguments);
			if (existingFunction)
				existingFunction.apply(this, arguments); 
		};
	})(handlerName in obj ? obj[handlerName] : null);
};

/* jQuery extensions
-------------------------------------------------------- */
jQuery.fn.check = function() {
	return this.each(function() {
		if (this.checked != undefined) { this.checked = true; }
	});
};
jQuery.fn.toggleCheck = function() {
	return this.each(function() {
		if (this.checked != undefined) { this.checked = !this.checked; }
	});
};

jQuery.fn.toggleWithLegend = function(target,s) {
	var defaults = {
		img_on_src: dotclear.img_plus_src,
		img_on_alt: dotclear.img_plus_alt,
		img_off_src: dotclear.img_minus_src,
		img_off_alt: dotclear.img_minus_alt,
		hide: true,
		fn: false, // A function called on first display,
		cookie: false
	};
	var p = jQuery.extend(defaults,s);
	
	if (!target) { return this; }
	
	var set_cookie = p.hide;
	if (p.cookie && jQuery.cookie(p.cookie)) {
		p.hide = false;
	}
	
	var toggle = function(i) {
		if (p.hide) {
			target.hide();
			if (p.cookie && set_cookie) {
				jQuery.cookie(p.cookie,'',{expires: -1});
			}
		} else {
			target.show();
			if (p.fn) {
				p.fn.apply(target);
				p.fn = false;
			}
			if (p.cookie && set_cookie) {
				jQuery.cookie(p.cookie,1,{expires: 30});
			}
		}
		p.hide = !p.hide;
		if (p.hide) {
			$(i).get(0).src = p.img_off_src;
			$(i).get(0).alt = p.img_off_alt;
		} else {
			$(i).get(0).src = p.img_on_src;
			$(i).get(0).alt = p.img_on_alt;
		}
		//$(i).get(0).src = p.hide ? p.img_off_src : p.img_on_src;
	};
	
	return this.each(function() {
		var i = document.createElement('img');
		i.src = p.img_off_src;
		i.alt = p.img_off_alt;
		$(i).css('cursor','pointer');
		$(i).click(function() {
			toggle(this);
		});
		$(this).prepend(document.createTextNode(' ')).prepend(i);
		
		toggle($(i).get(0));
	});
};

jQuery.fn.helpViewer = function() {
	if (this.length < 1) {
		return this;
	}
	
	var p = {
		img_on_src: dotclear.img_plus_src,
		img_on_alt: dotclear.img_plus_alt,
		img_off_src: dotclear.img_minus_src,
		img_off_alt: dotclear.img_minus_alt
	};
	var This = this;
	var toggle = function() {
		$('#content').toggleClass('with-help');
		if (document.all) {
			if ($('#content').hasClass('with-help')) {
				select = $('#content select:visible').hide();
			} else {
				select.show();
			}
		}
		sizeBox();
		return false;
	};
	
	var sizeBox = function() {
		This.css('height','auto');
		if ($('body').height() > This.height()) {
			This.css('height',$('body').height() + 'px');
		}
	};
	
	var textToggler = function(o) {
		var i = $('<img src="'+p.img_on_src+'" alt="'+p.img_on_alt+'" />');
		o.css('cursor','pointer');
		var hide = true;
		
		o.prepend(' ').prepend(i);
		o.click(function() {
			$(this).nextAll().each(function() {
				if ($(this).is('h3')) {
					return false;
				}
				$(this).toggle();
				sizeBox();
				return true;
			});
			hide = !hide;
			var img = $(this).find('img');
			if (!hide) {
				img.attr('src',p.img_off_src);
			} else {
				img.attr('src',p.img_on_src);
			}
		});
	};
	
	this.addClass('help-box');
	this.find('>hr').remove();
	
	this.find('h3').each(function() { textToggler($(this)); });
	this.find('h3:first').nextAll('*:not(h3)').hide();
	sizeBox();
	
	var img = $('<img src="images/help.png" alt="'+dotclear.msg.help+'" title="'+dotclear.msg.help+'" id="help-button" />');
	var select = $();
	img.click(function() { return toggle(); });
	
	$('#content').append(img);
	
	return this;
};

/* Dotclear common object
-------------------------------------------------------- */
var dotclear = {
	msg: {
		select_all: 'select all',
		invert_sel: 'invert selection',
		add_another_file: 'add another files',
		
		confirm_delete_posts: 'Are you sure you want to delete selected entries?',
		confirm_delete_comments: 'Are you sure you want to delete selected comments?',
		confirm_delete_comment: 'Are you sure you want to delete this comment?',
		confirm_delete_user: 'Are you sure you want to delete selected users?',
		confirm_delete_categories: 'Are you sure you want to delete the selected categories?',
		confirm_delete_media: 'Are you sure you want to remove this item?',
		confirm_remove_attachment: 'Are you sure you want to remove this attachment?',
		confirm_delete_plugins: 'Are you sure you want to delete selected plugins?'
	},
	
	hideLockable: function() {
		$('div.lockable').each(function() {
			var current_lockable_div = this;
			$(this).find('p.form-note').hide();
			$(this).find('input').each(function() {
				this.disabled = true;
				$(this).width(($(this).width()-14) + 'px');
				
				var imgE = document.createElement('img');
				imgE.src = 'images/locker.png';
				imgE.style.position = 'absolute';
				imgE.style.top = '1.7em';
				imgE.style.left = ($(this).width()+4)+'px';
				$(imgE).css('cursor','pointer');
				
				$(imgE).click(function() {
					$(this).hide();
					$(this).prev('input').each(function() {
						this.disabled = false;
						$(this).width(($(this).width()+14) + 'px');
					});
					$(current_lockable_div).find('p.form-note').show();
				});
				
				$(this).parent().css('position','relative');
				$(this).after(imgE);
			});
		});
	},
	
	checkboxesHelpers: function(e) {
		var a = document.createElement('a');
		a.href='#';
		$(a).append(document.createTextNode(dotclear.msg.select_all));
		a.onclick = function() {
			$(this).parents('form').find('input[@type="checkbox"]').check();
			return false;
		};
		$(e).append(a);
		
		$(e).append(document.createTextNode(' - '));
		
		a = document.createElement('a');
		a.href='#';
		$(a).append(document.createTextNode(dotclear.msg.invert_sel));
		a.onclick = function() {
			$(this).parents('form').find('input[@type="checkbox"]').toggleCheck();
			return false;
		};
		$(e).append(a);
	},
	
	postsActionsHelper: function() {
		$('#form-entries').submit(function() {
			var action = $(this).find('select[@name="action"]').val();
			var checked = false;
			
			$(this).find('input[@name="entries[]"]').each(function() {
				if (this.checked) {
					checked = true;
				}
			});
			
			if (!checked) { return false; }
			
			if (action == 'delete') {
				return window.confirm(dotclear.msg.confirm_delete_posts);
			}
			
			return true;
		});
	},
	
	commentsActionsHelper: function() {
		$('#form-comments').submit(function() {
			var action = $(this).find('select[@name="action"]').val();
			var checked = false;
			
			$(this).find('input[@name="comments[]"]').each(function() {
				if (this.checked) {
					checked = true;
				}
			});
			
			if (!checked) { return false; }
			
			if (action == 'delete') {
				return window.confirm(dotclear.msg.confirm_delete_comments);
			}
			
			return true;
		});
	}
};

/* On document ready
-------------------------------------------------------- */
$(function() {
	// Blog switcher
	$('#switchblog').change(function() {
		this.form.submit();
	});
	
	$('.error').backgroundFade({sColor:'#ffffff',eColor:'#ff9999',steps:50},function() {
		$(this).backgroundFade({sColor:'#ff9999',eColor:'#ffffff'});
	});
	$('.message').backgroundFade({sColor:'#ffffff',eColor:'#ffcc00',steps:50},function() {
		$(this).backgroundFade({sColor:'#ffcc00',eColor:'#ffffff'});
	});
	
	$('#help').helpViewer();
	
	$('form:has(input[type=password][name=your_pwd])').submit(function() {
		var e = this.elements['your_pwd'];
		if (e.value == '') {
			e.focus();
			$(e).backgroundFade({sColor:'#ffffff',eColor:'#ff9999',steps:50},function() {
				$(this).backgroundFade({sColor:'#ff9999',eColor:'#ffffff'});
			});
			return false;
		}
		return true;
	});
});

