<?php
	/* ***** BEGIN LICENSE BLOCK *****
	* This is themeswitcher, a plugin for DotClear.
	* Copyright (c) 2005 Benoit CLERC and contributors. All rights
	* reserved.
	*
	* DotClear is free software; you can redistribute it and/or modify
	* it under the terms of the GNU General Public License as published by
	* the Free Software Foundation; either version 2 of the License, or
	* (at your option) any later version.
	* 
	* DotClear is distributed in the hope that it will be useful,
	* but WITHOUT ANY WARRANTY; without even the implied warranty of
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	* GNU General Public License for more details.
	* 
	* You should have received a copy of the GNU General Public License
	* along with DotClear; if not, write to the Free Software
	* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	*
	* ***** END LICENSE BLOCK *****
	*/
	
	# Existence d'un thme
	function dcThemesExists($n) {
		global $themes_list;
		return !empty($themes_list[$n]) && $themes_list[$n]['active'] == 1;
	}
	
	# Liste des thmes actifs
	function dcThemesList($c,$excl=array()) {
		global $themes_list,$__theme;
		
		$themes = array();
		foreach ($themes_list as $url=>$arr) {
			if ($arr['active'] == 1 && !in_array($arr['name'],$excl)) $themes[$arr['label']] = $arr;
		}
		ksort($themes);
		
		$s = '';
		foreach ($themes as $label => $arr) {
			$s.= '<li>'.($arr['name'] == $__theme ? '<strong>' : '');
			$label = dc_encoding == 'UTF-8' ? utf8_encode($label) : $label;
			$s.= '<a href="'.dc_blog_url.'?type_url='.dc_url_scan.'&amp;theme='.$arr['name'].'">'.htmlspecialchars($label).'</a>';
			$s.= ($arr['name'] == $__theme ? '</strong>' : '').'</li>'."\n";
		}
		
		printf($c,"\n".$s);
	}
	
	# Liste droulante des thmes actifs
	function dcThemesSelect($c,$excl=array(),$sub='ok') {
		global $themes_list,$__theme;
		
		$themes = array();
		foreach ($themes_list as $url=>$arr) {
			if ($arr['active'] == 1 && !in_array($arr['name'],$excl)) $themes[$arr['label']] = $arr;
		}
		ksort($themes);
		
		$s = '<form action="'.dc_blog_url.'" method="get"><fieldset><select name="theme" onchange="this.form.submit();">';
		foreach ($themes as $label => $arr) {
			$label = dc_encoding == 'UTF-8' ? utf8_encode($label) : $label;
			
			$s.= '<option value="'.$arr['name'].'"'.($arr['name'] == $__theme ? ' selected="selected"' : '').'>'.htmlspecialchars($label).'</option>';
		}
		$s.= '</select><input type="hidden" name="type_url" value="'.dc_url_scan.'" />';
		$s.= '<noscript><p style="display: inline;"> <input type="submit" value="'.htmlspecialchars($sub).'" /></p></noscript></fieldset></form>';
		
		printf($c,"\n".$s);
	}
	
	# Liste des thmes
	$themes_root = dirname(__FILE__).'/../../../themes';
	$themes = new plugins($themes_root,'theme');
	$themes->init();
	$themes_list = $themes->getPluginsList();
	
	#Gnration du nom du cookie
	$dcThemesCookie = 'dc_theme_'.eregi_replace('[^a-z0-9]','',strtolower(base64_encode(dc_blog_name)));
	
	# Traitement du cookie
	if (!empty($_COOKIE[$dcThemesCookie]) && dcThemesExists($_COOKIE[$dcThemesCookie])) {
		$__theme = $_COOKIE[$dcThemesCookie];
	}
	
	if (!empty($_GET['theme']) && dcThemesExists($_GET['theme'])) {
		$__theme = $_GET['theme'];
		setcookie($dcThemesCookie,$__theme,strtotime('+ 1 month'),'/','');
		
		if ( dc_http_cache == 1 ) files::touch(DC_UPDATE_FILE);
		
		header('Location: '.(!empty($_SERVER['HTTP_REFERER']) && strpos($_SERVER['HTTP_REFERER'],$_SERVER['HTTP_HOST']) !== false ? $_SERVER['HTTP_REFERER'] : dc_blog_url));
		exit;
	}
?>
