<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of Dotclear.
# Copyright (c) 2004 Geoffrey Bachelet and contributors. All rights
# reserved.
#
# Dotclear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# Dotclear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Dotclear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****
#
# Contributors :
# - Olivier Meunier
# - Pep
#
class dcPackager
{
	function _scanDirectory($dirName, &$tar) {
		$exclude_list = array('.', '..', '.svn', 'CVS');	
		$dirName = preg_replace('|/$|','',$dirName);		
		if (!is_dir($dirName)) {
			return false;
		}
		$tar->addDirectory($dirName);
		$d = dir($dirName);
		while($entry = $d->read()) {
			if (!in_array($entry,$exclude_list)) {
				if (is_dir($dirName.'/'.$entry)) {
					dcPackager::_scanDirectory($dirName.'/'.$entry, $tar);
				} else {
					$tar->addFile($dirName.'/'.$entry);
				}
			}
		}
		$d->close();
		return true;
	}
	
	function packIt($name,$root,$fname,$save,$redir,$err_msg,&$err,$arc = true)
	{
		# Cration du pack
		if (($res = files::makePackage($name,$root.'/'.$name,$root.'/',1)) !== false)
		{
			if ($save)
			{
				if (($fp = fopen(DC_SHARE_DIR.'/'.$fname.'.pkg.gz','w')) !== false)
				{
					fwrite($fp,$res,strlen($res));
					fclose($fp);
					
					# Cration d'une archive tar gzippe
					if ($arc) {
						require_once(dirname(__FILE__).'/inc/class.tar.php');
						$tar = new tar();
						$cwd = getcwd();
						chdir($root);
						dcPackager::_scanDirectory($name, $tar);
						chdir($cwd);
						$tar->toTar(DC_SHARE_DIR.'/'.$fname.'.tar.gz', true);
					}
					
					header('Location: '.$redir);
					exit;
				}
				else
				{
					$err = '<p>'.$err_msg.'</p>';
				}
			}
			else
			{
				header('Content-Type: application/dotclear-pkg');
				header('Content-Disposition: attachment; filename='.$fname.'.pkg.gz');
				echo $res;
				exit;
			}
		}
		else
		{
			$err = '<p>'.$err_msg.'</p>';
		}
	}
}
?>
