<?php

# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2004-2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****
require_once dirname(__FILE__).'/class.mymeta.php';
require_once dirname(__FILE__).'/../metadata/class.metadata.php';


$mymeta=new mymeta($blog,DB_PREFIX);
$plugin_url = 'tools.php?p=mymeta';
$plugin_name = 'metadata';



function install() {
	global $con,$plugin_url;
	$rs = $con->select('SHOW TABLES LIKE \''.DB_PREFIX.'mymeta\'');
	if ( $rs->isEmpty() ) {
		require_once dirname(__FILE__).'/../../../inc/classes/class.checklist.php';
		require_once dirname(__FILE__).'/../../../inc/classes/class.xmlsql.php';
		
		$sql_check = new checklist();
		
		$xsql = new xmlsql($con,implode('',file(dirname(__FILE__).'/db-create.xml')));
		$xsql->replace('{{PREFIX}}',DB_PREFIX);
		$xsql->replace('{{USER}}',$_SESSION['sess_user_id']);
		$xsql->execute($sql_check);
		
		$sql_boolean = $sql_check->checkAll();
		
		buffer::str('<h3>'.__('Install').'</h3>');
		buffer::str($sql_check->getHTML('images/check_on.png','images/check_off.png','images/check_wrn.png'));
		
		if ( $sql_boolean === true ) buffer::str('<p><a href="'.$plugin_url.'">'.__('Continue').'</a></p>');
	}
}

$page = isset($_GET['page']) ? $_GET['page'] : 'mymetalist';

$index = dirname(__FILE__) . '/index-' . preg_replace('/[^a-zA-Z0-9]/', '', $page) . '.php';

install();
if (file_exists($index))
	require_once($index);
else
	buffer::str(sprintf('<p class="erreur">'.__('This page doesn\'t exist : %s').'</p>',$page));


?>
