<?php

# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2004-2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

# Classic ord
if (isset($_POST['linkOrd']) && is_array($_POST['linkOrd']))
{
	$items = $_POST['linkOrd'];
	asort($items);
	$ordered=array();
	$cur_section=0;
	foreach ($items as $k => $v) {
		if ($k == 'more')
			$cur_section = 1;
		else
			$ordered[$k]=array($cur_section,$v);
	}
	if ($mymeta->ordMyMeta($_POST['linkOrd']) === false) {
		$err = $mymeta->con->error();
	} else {
		header('Location: '.$plugin_url);
		exit;
	}
}
# DragNdrop
if (!empty($_POST['dndSort']))
{
	$entries = explode(';',$_POST['dndSort']);
	$cur_section=0;
	$pos=1;
	$ordered = array();
	foreach ($entries as $e) {
		if ($e == 'moreopt')
			$cur_section = 1;
		elseif ($e != 'main') {
			$k=substr($e,3);
			$ordered[$k]=array($cur_section,$pos);
			$pos++;
		}
	}
	
	if ($mymeta->ordMyMeta($ordered) === false) {
		$err = $mymeta->con->error();
	} else {
		header('Location: '.$plugin_url);
		exit;
	}
}


$PLUGIN_HEAD =
jsHelpers::dragSort().
'<script type="text/javascript">'."\n".
"//<![CDATA[\n".
"$(function() {\n".
"    dragSort.dest = document.getElementById('dndSort');\n".
"    dragSort.makeElementSortable(document.getElementById('sortlinks'));\n".
"	$('#form-links input[@name=\"delete\"]').click(function() {\n".
"		var checked = false;\n".		
"		$('#form-links').find('input[@name=\"link_ids[]\"]').each(function() {\n".
"			if (this.checked) {\n".
"				checked = true;\n".
"			}\n".
"		});\n".
"		if (!checked) { return false; }\n".	
"		return window.confirm('".
jsHelpers::escapeJS(__('Are you sure you want to delete selected links?')).
"');\n".
"	});\n".
"});\n".
"\n//]]>\n".
'</script>'
;

$mymeta_actions = array(
		'' => '&nbsp;',
		'status' => __('switch status'),
		'delete' => __('delete')
		);

buffer::str('<h2>'.__('My metadata').'</h2>');

$rs = $mymeta->getAll();

buffer::str('<p><a href="'.$plugin_url.'&amp;page=mymeta">'.__('New mymeta').'</a></p>');
buffer::str(
'<p>'.__('Drag items to change their positions.').'</p>'.
'<form action="'.$plugin_url.'" method="post" id="form-links">'.
'<div id="sortlinks">'
);
$cur_section=0;

buffer::str('<div class="sort" id="main"><strong>'.__('Main').'</div>');
$link_id=1;
while ($rs->fetch())
{
	$mm_id = $rs->f('mymeta_id');
	$mm_ord = $rs->f('mymeta_pos');
	$mm_name = $rs->f('mymeta_key');
	$mm_section = $rs->f('mymeta_section');
	if ($cur_section != $mm_section) {
		$cur_section=$mm_section;
		buffer::str('<div class="sort" id="moreopt"><p><strong>'.__('More options').'</strong>');
		buffer::str(
		'<p class="nojsfield"><label for="linkOrdmore" class="inline">'.__('Position').' : </label>'.
		form::field(array('linkOrd[more]','linkOrdmore'),3,3,$link_id).'</p></div>');
		$link_id++;
	}
	
	
	buffer::str('<div class="sort" id="dnd'.$mm_id.'">');
	
	buffer::str( '<p>'.form::checkbox('link_ids[]',$mm_id).'<a href="'.$plugin_url.'&amp;page=mymeta&amp;id='.$mm_id.'">'.$mm_name.'</a></p>');

	buffer::str(
	'<p class="nojsfield"><label for="linkOrd'.$mm_id.'" class="inline">'.__('Position').' : </label>'.
	form::field(array('linkOrd['.$mm_id.']','linkOrd'.$mm_id),3,3,$link_id).'</p>');
	
	buffer::str('</div>');
	$link_id++;
}
if ($cur_section==0) {
		buffer::str('<div class="sort" id="main"><strong>'.__('More options').'</div>');
}
buffer::str('</div>');
buffer::str(
	'<div class="two-cols" style="margin-top:0.5em;">'.
	'<p class="col"><input type="hidden" id="dndSort" name="dndSort" value="" />'.
	dcNonce::form().
	'<input type="submit" class="submit" value="'.__('save order').'" /></p>'.
	'<p class="col right">'.
	'<label style="display: inline;">'.__('Action on selected meta').'&nbsp;'.
	form::combo('cmts_action', array_flip($mymeta_actions)).
	'</label>&nbsp;<input type="submit" name="submit" class="submit" value="'.__('ok').'" /></p>');
buffer::str('</div></form>');
?>
