<?php

# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2004-2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

$PLUGIN_HEAD =
'<script type="text/javascript" src="index.php?pf=metadata/js/_mymeta.js"></script>'."\n";

$mySubMenu->addItem(__('Back to metadata'), $plugin_url,'images/metadata.png', FALSE);

$mm_id = !empty($_GET['id']) ? $_GET['id'] : null;

$p_key     = '';
$p_prompt  = __('Enter prompt here');
$p_type    = 'string';
$p_section = 0;
$p_status  = 0;
$p_multi   = 0;
$p_pos     = 1000;
$p_values  = '';
$err='';
$action = !empty($_POST['action']) ? $_POST['action'] : NULL;

if (!empty($_GET['id']) ) {
	$rs = $mymeta->getById($_GET['id']);

	if (!$rs->isEmpty()) {
		$p_id = $rs->f('mymeta_id');
		$p_key=$rs->f('mymeta_key');
		$p_prompt=$rs->f('mymeta_prompt');
		$p_type=$rs->f('mymeta_type');
		$p_section=$rs->f('mymeta_section');
		$p_status=$rs->f('mymeta_status');
		$p_multi=$rs->f('mymeta_status');
		$p_values=unserialize(base64_decode($rs->f('mymeta_values')));
		$p_pos=$rs->f('mymeta_pos');
	}
}
if (!empty($action)) {
	$missing=array();
	foreach (array('p_mm_key','p_mm_prompt','p_mm_type','p_mm_section','p_mm_status','p_mm_multi','p_mm_values') as $key_check) {
		if (!array_key_exists($key_check,$_POST)) {
			$missing[]=$key_check;
		}
	}
	if (sizeof($missing)>0) {
		$err=__('Missing fields :').implode(',',$missing);
	} else {
		$p_key = trim($_POST['p_mm_key']);
		$p_prompt = $_POST['p_mm_prompt'];
		$p_type = $_POST['p_mm_type'];
		$p_section = $_POST['p_mm_section'];
		$p_status = $_POST['p_mm_status'];
		$p_multi = $_POST['p_mm_multi'];
		$p_values = $_POST['p_mm_values'];
		$rs_key = $mymeta->getByKey($p_key);
		if ($p_key == '') {
			$err=__('Key cannot be empty');
		} elseif ($action == 'update' && !empty($_POST['p_mm_id'])) {
			$p_id = (integer) $_POST['p_mm_id'];
			if (!$rs_key->isEmpty() && $rs_key->f('mymeta_id') != $p_id) {
				$err=__('Key already exists :').$p_key;
			} else {
				$mymeta->updMyMeta ($p_id,$p_key,$p_prompt,$p_type,$p_values,$p_status,$p_multi,$p_pos,$p_section,'');
				header("Location:".$plugin_url);
			}

		} elseif ($action == 'create') {
			if (!$rs_key->isEmpty()) {
				$err=__('Key already exists :').$p_key;
			} else {
				$mymeta->addMyMeta ($p_key,$p_prompt,$p_type,$p_values,$p_status,$p_multi,$p_section,'');
				header("Location:".$plugin_url);
			}

		}
	}
}

# Affichage de l'en-tête
if($err != '') {
	buffer::str('<div class="erreur"><p><strong>'.__('Error(s)').' :</strong></p>'.$err.'</div>');
}
buffer::str('<h2>'.__('My metadata').'</h2>');
buffer::str(
	'<form action="'.$plugin_url.'&amp;page=mymeta" method="post">'.
	'<fieldset>'.
	'<legend>'.__('Edit my meta').'</legend>'.
	'<table class="clear post-entry-info">'.
	'<tr><td><label for="p_mm_key"><strong>'.__('Metadata Key').' </strong></label></td>'.
	'<td>'.form::field('p_mm_key',20,20,$p_key).'</td></tr>'.

	'<tr><td><label for="p_mm_prompt"><strong>'.__('Prompt').' </strong></label></td>'.
	'<td>'.form::field('p_mm_prompt',30,255,$p_prompt).'</td></tr>'.

	'<tr><td><label for="p_mm_type"><strong>'.__('Type').' </strong></label></td>'.
	'<td>'.form::combo('p_mm_type',$mymeta->types_combo,$p_type).'</td></tr>'.


	'<tr><td><label for="p_mm_section"><strong>'.__('Section').' </strong></label></td>'.
	'<td>'.form::combo('p_mm_section',$mymeta->sections_combo,$p_section).'</td></tr>'.

	'<tr><td><label for="p_mm_status"><strong>'.__('Status').' </strong></label></td>'.
	'<td>'.form::combo('p_mm_status',$mymeta->status_combo,$p_status).'</td></tr>'.

	'<tr><td><label for="p_mm_multi"><strong>'.__('Enable multiple values ?').' </strong> '.
		'</label></td>'.
	'<td>'.form::combo('p_mm_multi',$mymeta->multi_combo,$p_multi).'</td></tr>'.

	'<tr><td><label for="p_mm_values"><strong>'.__('Values (for list type)').' </strong></label></td>'.
	'<td>'.form::textArea('p_mm_values',40,10,$p_values).'</td></tr>'.

	'</table><p>');
if (!empty($p_id)) {
	buffer::str(form::hidden('p_mm_id',$p_id).form::hidden('action','update'));
} else {
	buffer::str(form::hidden('action','create'));
}
buffer::str(
	'<input type="submit" class="submit" value="'.__('save').'"/></p>'.dcNonce::form().
	'</fieldset>'.
	'</form>'."\n"
	);
?>
