<?php # encoding: utf-8
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Steve Frécinaux and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

# Basé sur l'implémentation des champs meta de wordpress.

class mymeta {
	var $con;
	var $blog;
	var $table;


	var $types_combo;
	var $sections_combo;
	var $status_combo;
	var $multi_combo;

	function mymeta(&$blog,$prefix)
	{
		$this->con = $blog->con;
		$this->blog = $blog;
		$this->table = $prefix.'mymeta';
		$this->types_combo = array(
			__('String') => 'string',
			__('List') => 'list',
			__('Boolean') => 'bool');
		$this->sections_combo = array(
			__('Main') => 0,
			__('More Options') => 1);
		$this->status_combo = array(
			__('Disabled') => 0,
			__('Enabled') => 1);
		$this->multi_combo = array(
			__('no') => 0,
			__('yes') => 1);
		
	}

	function addMyMeta($key, $prompt, $type, $values, $status, $multi, $section, $behaviour) {
		$strReq = 'SELECT MAX(mymeta_pos) '.
				'FROM '.$this->table.' WHERE mymeta_section=\''.$section.'\'';
			
		if (($rs = $this->con->select($strReq)) === false) {
			return false;
		}
		
		$position = $rs->f(0);
	
		$insReq = 'INSERT INTO '.$this->table.' '.
			'(mymeta_key, mymeta_prompt,mymeta_type,mymeta_values, mymeta_status, '.
			'mymeta_multi, mymeta_pos, mymeta_section, mymeta_behaviour) VALUES '.
			'(\''.$this->con->escapeStr($key).'\', '.
			'\''.$this->con->escapeStr($prompt).'\', '.
			'\''.$this->con->escapeStr($type).'\', '.
			'\''.base64_encode(serialize($values)).'\', '.
			'\''.(integer) $status.'\', '.
			'\''.(integer) $multi.'\', '.
			'\''.(integer) $position.'\', '.
			'\''.(integer) $section.'\', '.
			'\''.$this->con->escapeStr($behaviour).'\');';
		if ($this->con->execute($insReq) === false) {
			return false;
		}
		return true;
	}

	function updMyMeta($id, $key, $prompt, $type, $values, $status, $multi, $pos, $section, $behaviour) {
		$updReq = 'UPDATE '.$this->table.' SET '.
			'mymeta_key = \''.$this->con->escapeStr($key).'\','.
			'mymeta_prompt = \''.$this->con->escapeStr($prompt).'\','.
			'mymeta_type = \''.$this->con->escapeStr($type).'\','.
			'mymeta_values = \''.base64_encode(serialize($values)).'\','.
			'mymeta_status = \''.(integer) $status.'\','.
			'mymeta_multi = \''.(integer) $multi.'\','.
			'mymeta_pos = \''.(integer) $pos.'\','.
			'mymeta_section = \''.(integer) $section.'\','.
			'mymeta_behaviour = \''.$this->con->escapeStr($behaviour).'\' '.
			'WHERE mymeta_id = '.(integer) $id;
		
		if ($this->con->execute($updReq) === false) {
			return false;
		}
		return true;
		
	}

	function ordMyMeta($ord) {
		foreach ($ord as $k => $v)
		{
			$updReq = 'UPDATE '.$this->table.' SET '.
					'mymeta_section = '.(integer) $v[0].', '.
					'mymeta_pos = '.(integer) $v[1].' '.
					'WHERE mymeta_id = '.(integer) $k;
			if (!$this->con->execute($updReq)) {
				return false;
			}
		}
		return true;
	}

	function getAll($active_only=false,$section=-1) {
		$strReq = 'SELECT * '.
			'FROM '.$this->table.' ';
		$where=array();
		if ($active_only) {
			$where[]= 'mymeta_status = 1';
		}
		if ($section > -1) {
			$where[]= 'mymeta_section = '.(integer)$section.' ';
		}
		if (sizeof($where)>0) {
			$strReq .= " WHERE ".implode(' AND ',$where).' ';
		}
		$strReq .= ' ORDER BY mymeta_section,mymeta_pos';
		return $this->con->select($strReq);
	}

	function getById($id) {
		$strReq = 'SELECT * '.
			'FROM '.$this->table.' '.
			'WHERE mymeta_id = '. (integer) $id;
		return $this->con->select($strReq);
	}
	function getByKey($key) {
		$strReq = 'SELECT * '.
			'FROM '.$this->table.' '.
			'WHERE mymeta_key = \''.$this->con->escapeStr($key).'\'';
		return $this->con->select($strReq);
	}

	function delMyMeta ($id) {
		$delReq = 'DELETE FROM '.$this->table.' '.
				'WHERE mymeta_id = '.$id;
		
		if ($this->con->execute($delReq) === false) {
			return false;
		}
		
		return true;
	}

	# Ordonner les entrées
	function ordEntries($ord)
	{
		if (!is_array($ord)) {
			return false;
		}
		
		foreach ($ord as $k => $v)
		{
			$updReq = 'UPDATE '.$this->table.' SET '.
					'position = '.(integer) $v.' '.
					'WHERE mymeta_id = '.(integer) $k;
			
			if (!$this->con->execute($updReq)) {
				return false;
			}
		}
		
		return true;
	}

}
