<?php # encoding: utf-8
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Steve Frécinaux and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

# Basé sur l'implémentation des champs meta de wordpress.

class metadata {

	var $con;
	var $blog;
	var $table;
	var $cache;

	function metadata(&$blog,$prefix)
	{
		$this->con = $blog->con;
		$this->blog = $blog;
		$this->table = $prefix.'meta';
		$this->cache = array();
	}

	function _retrieve($post_id)
	{
		if (isset($this->cache[$post_id])) 
			return false;

		$metalist = $this->con->select('SELECT meta_key, meta_value'
		                       . ' FROM ' . $this->table
		                       . ' WHERE post_id = ' . (integer) $post_id
		                       . ' ORDER BY meta_id ASC');
	
		if ($metalist === false || $metalist->isEmpty()) 
			return false;
	
		while ($metalist->fetch())
		{
			if (!isset($this->cache[$post_id][$metalist->f('meta_key')]))
				$this->cache[$post_id][$metalist->f('meta_key')] = array();
			$this->cache[$post_id][$metalist->f('meta_key')][] = $metalist->f('meta_value');
		}
		return true;
	}

	/*
	Met tous les champs définis pour tous les billets contenus dans un recordset
	(réduit le nombre de requêtes SQL nécessaires)
	
	@param recordset rec  (optionel) Recordset contenant les billets. Si non définis, recordset habituel ($news)
	*/
	function cache($rec = null)
	{
		$ids = array();
		if ($rec === null) 
			$rec =& $GLOBALS['news'];

		if (!is_a($rec, 'recordset') || $rec->isEmpty())
			return false;

		//while ($rec->fetch())
		//	if (!isset($this->cache[$rec->f('post_id')]))
		//		$this->_retrieve($rec->f('post_id'));
		//return;

		while ($rec->fetch())
			if (!isset($this->cache[$rec->f('post_id')]))
				$ids[] = $rec->f('post_id');

		$sql = 'SELECT post_id, meta_key, meta_value'
		     . ' FROM ' . $this->table
		     . ' WHERE post_id IN (' . implode(',',$ids) . ')'
		     . ' ORDER BY post_id, meta_key, meta_id';
		$metalist = $this->con->select($sql);

		if ($metalist === false || $metalist->isEmpty())
			return false;

		while ($metalist->fetch())
		{
			$post_id = $metalist->f('post_id');
			$key = $metalist->f('meta_key');
			if (!isset($this->cache[$post_id][$key]))
				$this->cache[$post_id][$key] = array();
			$this->cache[$post_id][$key][] = $metalist->f('meta_value');
		}
		return true;
	}

	/*
	Récupère les valeurs d'une clef
	
	@param string  post_id Identifiant du billet
	@param string  key     Clef
	@param boolean single  si true, considère que la clef ne peut contenir qu'une valeur
	*/	
	function get($post_id, $key, $single = false) 
	{
		$this->_retrieve($post_id);
		if (isset($this->cache[$post_id][$key]))
		{
			if ($single)
				return count($this->cache[$post_id][$key]) ? $this->cache[$post_id][$key][0] : false;
			else
				return $this->cache[$post_id][$key];
		}
		else
			return false;
	}

	/*
	Récupère la dernière valeur définie pour une clef.
	
	@param string  post_id Identifiant du billet
	@param string  key     Clef
	*/
	function getLast($post_id, $key)
	{
		$this->_retrieve($post_id);
		if (isset($this->cache[$post_id][$key]))
		{
			$c = count($this->cache[$post_id][$key]);
			return $c ? $this->cache[$post_id][$key][$c-1] : false;
		}
		else
			return false;
	}

	/*
	Crée une clef, ou ajoute une valeur à une clef.
	
	@param string  post_id Identifiant du billet pour lequel on lie une clef
	@param string  key     Clef
	@param string  value   Valeur(s) (tableau de valeurs si plusieurs valeurs sont a ajouter)
	*/
	function addMeta($post_id, $key, $value)
	{
		if (!is_array ($value)) {
			$value = array($value);
		}
		
		# Modification de l'arbre local
		if (!isset($this->cache[$post_id][$key]))
			$this->cache[$post_id][$key] = array();
		$this->cache[$post_id][$key] = array_merge ($this->cache[$post_id][$key],$value);
		$key = $this->con->escapeStr($key);
		$entries = array();
		foreach ($value as $id) {
			$entries[]='('.(integer)$post_id.',"'.$key.'","'.$this->con->escapeStr(trim($id)).'")';
		}
		# Répercussion dans la base de données
		$this->con->execute('INSERT INTO ' . $this->table . ' (post_id,meta_key,meta_value)'.
			    ' VALUES '.implode(',',$entries));
		return true;
	}

	/*
	Supprime une clef, ou enlève une valeur à une clef.
	
	@param string  post_id Identifiant du billet
	@param string  key     Clef
	@param string  value   (optionel) Valeur à supprimer. Si non défini, toutes les valeurs sont supprimées.
	*/
	function delMeta($post_id, $key, $value = '') 
	{
		if (empty($value))
		{
			if (isset($this->cache[$post_id][$key]))
				unset($this->cache[$post_id][$key]);
			$this->con->execute('DELETE FROM ' . $this->table
			            . ' WHERE post_id = ' . (integer) $post_id
			            . '   AND meta_key = "' . $this->con->escapeStr($key) . '"');
		}
		else 
		{
			if (isset($this->cache[$post_id][$key]))
			{
				$this->cache[$post_id][$key] = array_filter($this->cache[$post_id][$key], create_function('$x', 'return $x != "' . addslashes($value) . '";'));
				if (count($this->cache[$post_id][$key]) == 0)
					unset($this->cache[$post_id][$key]);
			}
			$this->con->execute('DELETE FROM ' . $this->table
			            . ' WHERE post_id = ' . (integer) $post_id
			            . '   AND meta_key = "' . $this->con->escapeStr($key) . '"'
			            . '   AND meta_value = "' . $this->con->escapeStr($value) . '"');
		}
		return true;
	}


	/*
	Retourne la liste des clefs définies pour un billet
	
	@param string  post_id Identifiant du billet
	*/	
	function getMetaKeys($post_id)
	{
		$this->_retrieve($post_id);
		if (isset($this->cache[$post_id]))
			return array_keys($this->cache[$post_id]);
		else
			return false;
	}

	function getAllKeys() {
		$strReq = "SELECT meta_key,count(post_id) as count FROM ".$this->table
			." GROUP BY meta_key";
		return $this->con->select($strReq);
	} 
	/*
	Retourne l'ensemble des paires clefs/valeurs associées à un billet
	
	@param string  post_id Identifiant du billet

	NB: le tableau est de la forme $clef => array($valeurs)
	*/
	function getPostMeta($post_id)
	{
		$this->_retrieve($post_id);
		if (isset($this->cache[$post_id]))
			return $this->cache[$post_id];
		else
			return false;
	}

	/*
	Change une valeur
	
	@param string  post_id     Identifiant du billet pour lequel on lie une clef
	@param string  key         Clef
	@param string  value       Nouvelle valeur
	@param string  prev_value  (optionnel) Ancienne valeur
	*/
	function update($post_id, $key, $value, $prev_value = null)
	{
		# modification de l'arbre local
		if (isset($this->cache[$post_id][$key]))
			foreach ($this->cache[$post_id][$key] as $k => $v)
				if (false === $prev_value || $v == $prev_value)
					$this->cache[$post_id][$key][$k] = $value;
		
		# modification dans la base de données
		$sql = 'UPDATE ' . $this->table
		     . ' SET meta_value = "' . $this->con->escapeStr($value) . '"'
		     . ' WHERE post_id = ' . (integer) $post_id
		     . '   AND meta_key = "' . $this->con->escapeStr($key) . '"';
		if (!is_null($prev_value))
			$sql .= ' AND meta_value = "' . $this->con->escapeStr($prev_value) . '"';
	
		$this->con->execute($sql);
		return true;
	}

	function displayAsList($rec = null)
	{
		$id = is_null($rec) ? $GLOBALS['news']->f('post_id') : $rec->f('post_id');
		$str = '';
		$properties = metadata::getAll($id);
		if ($properties == false) 
			return false;
		foreach($properties as $k => $v)
		{
			$str .= '<dt>' . htmlspecialchars($k) . '</dt>';
			foreach ($v as $p)
				$str .= '<dd>' . htmlspecialchars($p) . '</dd>';
		}
		return ($str != '') ? '<dl>'.$str.'</dl>' : false;
	}

	/*
		Retourne la valeur d'un champ méta associé au billet courant dans $rec
		
		@param string    key   Clef
		@param integer   mode  (optionel) TWPM_F_ALL | TWPM_F_FIRST | TWPM_F_LAST
		@param recordset rec   (optionel) Recordset contenant le(s) billet(s). Par défaut, $news
		
		Utilisation: dans la boucle de billet:
		while ($news->fetch())
		{
			$id = $news->f('post_id');
			$value = twPostMeta::f('key');
			# ...
		}
	*/
	function field($key, $mode = 0, $rec = null)
	{
		$id = is_null($rec) ? $GLOBALS['news']->f('post_id') : $rec->f('post_id');
		switch ($mode)
		{
			case 0: return twPostMeta::get($id, $key, false);
			case 1: return twPostMeta::get($id, $key, true);
			case 2: return twPostMeta::getLast($id, $key);
		}
	}

	function f($key, $mode=0, $rec=null)
	{
		return twPostMeta::field($key,$mode,$rec);
	}
	
	# Récupère les $limit derniers billets dont le champ $key est défini et a la valeur $value
	function getLastNews($key, $value, $limit = 20, $order = 'post_dt DESC', $lang='', $pub_mode = 1)
	{
		$reqPlus = 'AND meta_key = "' . $this->con->escapeStr($key) . '" AND meta_value = "' . $this->con->escapeStr($value) . '" ';

		if ($pub_mode)
			$reqPlus .= 'AND post_pub = '.(integer) $pub_mode.' ';
		if ($lang != '')
			$reqPlus .= 'AND post_lang = "'.$this->con->escapeStr($lang).'" ';
			
		$strReq = 'SELECT P.post_id, post_chapo, post_chapo_wiki, post_content, '.
				'post_content_wiki, post_notes, post_titre, post_titre_url, '.
				'post_dt, post_upddt, post_creadt, post_pub, '.
				'post_open_comment, post_open_tb, nb_comment, nb_trackback, '.
				'post_lang, post_selected, U.user_id, U.user_nom, '.
				'U.user_prenom, U.user_pseudo, U.user_email, '.
				'DATE_FORMAT(post_dt,"%Y%m%d") AS postdate, '.
				'DATE_FORMAT(post_dt,"%H:%i") AS posthour, '.
				'DATE_FORMAT(post_dt,"%d") AS postday, '.
				'DATE_FORMAT(post_dt,"%m") AS postmonth, '.
				'DATE_FORMAT(post_dt,"%Y") AS postyear, '.
				'P.cat_id, C.cat_libelle, C.cat_libelle_url '.
				'FROM '.DB_PREFIX.'post P, '.DB_PREFIX.'categorie C, '.
					DB_PREFIX.'user U ,'.DB_PREFIX.'post_meta M '.
				'WHERE P.cat_id = C.cat_id AND U.user_id = P.user_id AND P.post_id = M.post_id '.
				$reqPlus.
				'ORDER BY '.$this->con->escapeStr($order).' ';
		
		if ($limit != '')
		{
			$limit = (preg_match('/^[0-9]+$/',$limit)) ? '0,'.$limit : $limit;
			$strReq .= 'LIMIT '.$limit.' ';
		}
		
		if (($rs = $this->con->select($strReq,$GLOBALS['blog']->rs_blogpost)) !== false) 
		{
			$rs->setBlog($GLOBALS['blog']);
			return $rs;
		}
		else
			exit($strReq);
			return false;
	}
}

?>
