<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of Dotclear.
# Copyright (c) 2004-2007 dcTeam and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

class mysqlBackup
{
	var $con_id;
	var $error;
	var $errno;

	var $tables;
	var $dump = '';
	
	function mysqlBackup($con = null)
	{
		if (!empty($con)) {
			$this->con_id = $con->con_id;
		}
	}
	
	function _getConnection()
	{
		if ($this->con_id === null || !is_resource($this->con_id))
		{
			if (!$this->con_id = @mysql_connect(DB_HOST, DB_USER, DB_PASS)) {
				$this->_setError();
				return false;
			}
			elseif (!@mysql_select_db(DB_NAME)) {
				$this->_setError();
				$this->con_id = null;
				return false;
			}
		}
		return true;
	}

	function _setError()
	{
		if ($this->con_id) {
			$this->error = mysql_error($this->con_id);
			$this->errno = mysql_errno($this->con_id);
		} else {
			$this->error = (mysql_error() !== false) ? mysql_error() : 'Unknown error';
			$this->errno = (mysql_errno() !== false) ? mysql_errno() : 0;
		}
	}
		
	function _getTables()
	{
		if (!$this->_getConnection()) return false;

		if (!empty($this->tables)) return true;
		
		$this->tables = array(
			DB_PREFIX.'user' 		=> 0,
			DB_PREFIX.'setting'		=> 0,
			DB_PREFIX.'categorie'	=> 0,
			DB_PREFIX.'post'		=> 0,
			DB_PREFIX.'comment'		=> 0,
			DB_PREFIX.'ping'		=> 0,
			DB_PREFIX.'link'		=> 0
		);

		if (($res = mysql_query("SHOW TABLES LIKE '".DB_PREFIX."%'", $this->con_id)))
		{
			while ($row = mysql_fetch_row($res))
			{
				$dc_table = $row[0];
				if ($dc_table == DB_PREFIX.'log' || $dc_table == DB_PREFIX.'session') {
					continue;
				}
				if (isset($this->tables[$dc_table])) {
					continue;
				} else {
					$this->tables[$dc_table] = 0;
				}
			}
			
			$tables = array_keys($this->tables);
			foreach ($tables as $table)
			{
				if (($res = mysql_query('SELECT COUNT(*) FROM '.$table, $this->con_id))) {
					while ($row = mysql_fetch_row($res)) {
						$this->tables[$table] = (integer)$row[0];
					}
				}
				else {
					$this->setError();
					return false;
				}
			}
			return true;
		}
		else {
			$this->setError();
			return false;
		}
	}
}

/**
 * @class dbdump
 *
 */
class dbdump
{
	/**
	@function _getDCTablesList

	Crtion d'un tableau contenant la listes des tables DC  sauvegarder.
	Les tables 'log' et 'session' sont ignores et les ventuelles tables
	de plugins ajoutes, si elles sont correctement prfixes.

	@return	array
	*/
	function _getDCTablesList()
	{
		global $con;

		// D'emble, on prcise les tables "natives" dans l'ordre d'importance
		// pour scuriser au mieux la remonte.
		// NB : on ignore les tables 'log' et 'session'
		$dc_dump_tables =
			array(
				DB_PREFIX.'user' 		=> 0,
				DB_PREFIX.'setting'		=> 0,
				DB_PREFIX.'categorie'	=> 0,
				DB_PREFIX.'post'		=> 0,
				DB_PREFIX.'comment'		=> 0,
				DB_PREFIX.'ping'		=> 0,
				DB_PREFIX.'link'		=> 0
			);

		// Rcupration auprs de MySQL de la liste des tables prfixes
		// pour le DC courant
		$dc_tables = $con->select("SHOW TABLES LIKE '".DB_PREFIX."%'");

		// Maintenant on consolide le tout...
		while ($dc_tables->fetch()) {
			$dc_table = $dc_tables->f(0);

			// S'il s'agit de la table 'log' ou 'session', on carte...
			if ($dc_table == DB_PREFIX.'log' ||
				$dc_table == DB_PREFIX.'session') {
				continue;
			}

			// On n'ajoute que les tables supplmentaires susceptibles
			// d'alimenter des plugins.
			if (isset($dc_dump_tables[$dc_table])) {
				continue;
			} else {
				$dc_dump_tables[$dc_table] = 0;
			}
		}
		
		return($dc_dump_tables);
	}


	function getTotalNumRows() {
		global $con;
		
		$dc_tables = dbdump::_getDCTablesList();
		
		$total = 0;
		foreach ($dc_tables as $dc_table) {
			$rs = $con->select("SELECT COUNT(*) FROM $dc_table");	
			if ($rs->fetch()) {
				$total += $rs->f(0);	
			}
		}
		return $total;		
	}

	/**
	 @function getDump

	 Effectue un dump des tables DotClear sous forme d'un fichier SQL standard.

	 L'export se compose pour chacune des tables :
	    - d'une instruction conditionnelle DROP TABLE
	    - de la clause compl?te CREATE TABLE (cl?s comprises)
	    - des clauses INSERT n?cessaires ? la restauration des donn?es.

	 NB : Les noms des colonnes sont "backquot?s".

	 @return string La chaine repr?sentant le dump.
	 */
	function getDump($offset, $limit)
	{
		global $con;
		$dump_str = '';
		
		if (($offset < 0) || ($limit <=0)) {
			echo 'getDump Error: invalid offset, limit value';
			exit; 	
		} 
		
		if (!isset($GLOBALS['mysql_dc_tables'])) {
			$GLOBALS['mysql_dc_tables'] = dbdump::_getDCTablesList();
		}
		$dc_tables = $GLOBALS['mysql_dc_tables'];
		
		$table_start = array();
		$index = 0;
		foreach ($dc_tables as $dc_table) {
			$rs = $con->select("SELECT COUNT(*) FROM $dc_table");	
			if ($rs->fetch()) {
				$table_start[$dc_table] = $index;
				$index += $rs->f(0);	
			}
		}
		$table_start['fin'] = $index +1;
		$dc_tables[] = 'fin';
		$index_fin = $index + 1;;

		// On pr?cise ? MySQL qu'il doit "quoter" les r?sultats des
		// requ?tes SHOW CREATE TABLE qui vont suivre.
		$con->execute("SET SQL_QUOTE_SHOW_CREATE = 1");
		
		$index = 0;
		$num_tables = count($dc_tables);
		while (($num_tables != $index) && !(($table_start[$dc_tables[$index]] <= $offset) && ($table_start[$dc_tables[$index+1]] > $offset))) {
			$index++;	
		}
		$dc_table = $dc_tables[$index];
		$dc_next_table = $dc_tables[$index+1];
		if ($dc_table != 'fin') {
			if ($limit != 0) {
				if (($offset + $limit) <= $table_start[$dc_next_table]) {
					if ($table_start[$dc_table] == $offset) {
						if ($offset == 0) {
							// R?cup?ration de la version du serveur MySQL
							$rs = $con->select("SELECT REPLACE(VERSION(),'-log','')");
							$mysql_version = 'unknown';
							if ($rs) $mysql_version = $rs->f(0);
					
							// Une ent?te pour mettre quelques infos (in)utiles
							$dump_str .=
								"#-------------------------------------------------------------------\n".
								"# Dump MySQL\n".
								"#\n".
								"# Blog     : ". dc_blog_name ."\n".
								"# DotClear : ". DC_VERSION ."\n".
								"# Serveur  : ". DB_HOST ." (MySQL v ". $mysql_version .")\n".
								"# Base     : ". DB_DBASE ."\n".
								"# Date     : ". date("d/m/Y H:i") ."\n".
								"#-------------------------------------------------------------------\n".
								"\n";
								
								foreach ($dc_tables as $table) {
									if ($table != 'fin') {
										$rs = $con->select("SHOW CREATE TABLE $table");
										while($rs->fetch()) {
											// Dump de la clause CREATE TABLE
											$dump_str .=
												"#-------------------------------------------------------------------\n".
												"# Structure de la table $table\n".
												"#-------------------------------------------------------------------\n".
												"DROP TABLE IF EXISTS `$table`;\n".
												str_replace("\n","",$rs->f(1)).";".
												"\n\n";					
										}
									}	
								}
								$dump_str .=
											"#-------------------------------------------------------------------\n".
											"# Donnees \n".
											"#-------------------------------------------------------------------\n";	
						}
		
					}
					// Dump des clauses INSERT
					// calcul de l'offset local  la table
					$offset_local = $offset - $table_start[$dc_table];
					$req = "SELECT * FROM $dc_table LIMIT $limit";
					if ($offset_local != 0) {
						$req .= " OFFSET $offset_local";	
					}
					$col_rs = $con->select($req);

					while($col_rs->fetch()) {
						$values = array();
						for ($i = 0; $i < $col_rs->int_col_count; $i++) {
							$values[] = $con->escapeStr($col_rs->f($i));
						}
						$dump_str .= "INSERT INTO `$dc_table` VALUES ( '". implode("', '",$values) ."' );\n";
					}				
				} else {
					// on dcoupe en deux (sur la fin de table), et on appelle rcursivement
					// (normalement pas de prob, le premier appel doit terminer en 1 fois)
					$dump_str .= dbDump::getDump($offset, $table_start[$dc_next_table] - $offset);
					if ($dc_next_table != 'fin') {
						$dump_str .= dbDump::getDump($table_start[$dc_next_table], ($offset + $limit - $table_start[$dc_next_table]));
					}
				}
			}
			if ($offset + $limit == $table_start['fin'] ) {
				$dump_str .= "#-- EOF --\n";
			}
		}
		return($dump_str);		
	}


	function saveDumpFragment($limit, $offset) {
		$filename = (isset($GLOBALS['export_filename']))?$GLOBALS['export_filename']:'';
		$GLOBALS['export_filename'] = dbdump::saveDump(false, '', $filename, false, $offset, $limit);		
	}

	/**
	 @function saveDump

	 Enregistre un fichier de dump des tables DotClear.
	 Avec les param?tres par d?faut, un fichier gzipp? dump-YYYYMMDD.sql.gz est
	 cr?? dans le r?pertoire share/mysql/ de l'installation DotClear.

	 @param	boolean	transmit	indicateur d'envoi du fichier de dump (false)
	 @param string	path		le chemin d'enregistrement ('')
	 @param string	name		le nom du fichier cible ('')
	 @param boolean	compressed	indicateur de compression ou non (true)

	 @return mixed Retourne une chaine repr?sentant le nom du fichier dans lequel
	               le dump a ?t? sauvegard?. Retourne un boolean ? false en cas
	               de probl?me sinon.

	 @see dbdump::getDump
	 */
	function saveDump($transmit = false, $path = '', $name = '', $compressed = false, $offset = -1, $limit = -1)
	{
		if ($compressed && !function_exists('gzencode')) {
			return(false);
		}
		if (!empty($path) && is_dir($path) && is_writable($path)) {
			$trg_path = $path;
		} else {
			$trg_path = DC_SHARE_DIR.'/mysql';
		}
		if (!empty($name)) {
			$trg_name = $name;
		} else {
			$trg_name = 'dbdump-'.date("Ymd").'.sql';
		}

		$dump = dbdump::getDump($offset, $limit);
		if ($compressed) {
			$dump = gzencode($dump);
			$trg_name .= '.gz';
		}
		if ($transmit) {
			header('Content-Type: application/x-gzip');
			header('Content-Disposition: attachment; filename='.$trg_name);
			echo $dump;
			exit;
		} else {
			$trg_fullname = $trg_path.'/'.$trg_name;
			if ($fh = fopen($trg_fullname,"ab")) {
				fwrite($fh, $dump);
				fclose($fh);
			} else {
				return(false);
			}
			return($trg_name);
		}
	}


	/**
	 @function restoreDump

	 Restaure des tables DotClear depuis un fichier de dump pr?c?demment cr??
	 par l'op?ration de sauvegarde.

	 @param string	src_file	le chemin du fichier de dump ? restaurer
	 @param boolean	compressed	indicateur de compression ou non (true)

	 @return mixed Retourne une chaine indiquant que l'op?ration s'est correctement
	               d?roul?e. Retourne un boolean ? false en cas de probl?me sinon.

	 @see dbdump::saveDump
	 */
	 
	function restoreDumpFragment($limit, $offset)
	{
		dbdump::restoreDump(&$GLOBALS['fp'], false, $offset, $limit);		
	}
	 
	function fileOffset(&$fp, $offset)
	{	
		rewind($fp);
		// on skippe les $offset premires lignes
		for ($i = 0; $i < $offset ; $i++) {
	        	fgets($fp, 4096);
	    	}		
	} 
	 
	function restoreDump(&$fp, $compressed = false, $offset = -1, $limit = -1)
	{
		global $con;

		// Parsing "simpliste" du fichier dump pour la remont?e en base.
		// Seules les requ?tes DROP TABLE, CREATE TABLE et INSERT seront
		// trait?es.

		$token = $sql = '';

		for ($i = 0; $i < $limit ; $i++)
		{
			$line = fgets($fp, 4096);
			$line = rtrim($line);
			if (empty($line) || strpos(ltrim($line), "#") === 0) continue;
			$token .= $line;
			if (preg_match("/^((DROP|CREATE) TABLE .*);$/", $token, $matches) ||
				preg_match("/^(INSERT INTO (.*)'\s\));$/", $token, $matches))
			{
				$sql = $matches[1];
				if (!empty($sql))
				{
					$res = $con->execute($sql);
					if ($res === false) {
						return(false);
					}
				}
				$token = $sql = '';
			}
		}

	}


	/**
	@function _getChrono

	@return	float
	*/
	function _getChrono()
	{
	   list($usec, $sec) = explode(" ", microtime());
	   return ((float)$usec + (float)$sec);
	}
	
	function getFileNumLines($fp) 
	{
		$count = 0;
		rewind($fp);
		while (!feof($fp)) {
	        	fgets($fp, 4096);
	        	$count++;
	    	}
	    	rewind($fp);
	    	return $count;
	}
}
?>