<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2004 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

$err = '';
$tool_url = 'tools.php?p=toolsmng';
$new_tool = '';

# Liste des thmes
$plugins_root = dirname(__FILE__).'/../';
$plugins = new plugins($plugins_root);
$plugins->getPlugins(false);
$plugins_list = $plugins->getPluginsList();

$is_writable = is_writable($plugins_root);

# Installation d'un thme
if ($is_writable && !empty($_POST['new_tool']))
{
	$tool_url = strip_tags($_POST['new_tool']);
	$parsed_url = parse_url($tool_url);
	
	if (empty($parsed_url['scheme']) || !preg_match('/^http|ftp$/',$parsed_url['scheme'])
	|| empty($parsed_url['host']) || empty($parsed_url['path']))
	{
		$err = __('URL is not valid.');
	}
	else
	{
		if (($err = $plugins->install($tool_url)) === true)
		{
			header('Location: tools.php?p=toolsmng');
			exit;
		}
	}
}

# Operations sur les plugins
if ($is_writable && !empty($_POST['tools_action']) && is_array($_POST['tool_ids'])) {
	$action = $_POST['tools_action'];
	$ids = $_POST['tool_ids'];

	# Changement de status des plugins
	if ($action == 'switch') {
		foreach ($ids as $tool_id) {
			if (in_array($tool_id,array_keys($plugins_list)) && $tool_id != 'toolsmng') {
				$plugins->switchStatus($tool_id);	
			}
		}
		header('Location: tools.php?p=toolsmng');
		exit;
	}
	
	elseif ($action == 'delete') {
		foreach ($ids as $tool_id) {
			if (in_array($tool_id,array_keys($plugins_list)) && $tool_id != 'toolsmng') {
				@files::deltree($plugins_root.'/'.$tool_id);
			}
		}
		header('Location: tools.php?p=toolsmng');
		exit;
	}
}

if($err != '')
{
	buffer::str(
	'<div class="erreur"><p><strong>'.__('Error(s)').' :</strong></p>'.$err.'</div>'
	);
}

buffer::str(
'<h2>'.__('Plugins manager').'</h2>'.
'<h3>'.__('Install a plugin').'</h3>'
);

if (!$is_writable)
{
	buffer::str(
	'<p>'.sprintf(__('The folder %s is not writable, please check its permissions.'),
	DC_ECRIRE.'/tools/').'</p>'
	);
}
else
{
	buffer::str(
	'<form action="tools.php" method="post">'.
	'<p><label for="new_tool">'.__('Please give the URL (http or ftp) of the plugin\'s file').' :</label>'.
	form::field('new_tool',50,'',htmlspecialchars($new_tool)).'</p>'.
	'<p>'.
	dcNonce::form().
	'<input type="submit" class="submit" value="'.__('install').'" />'.
	'<input type="hidden" name="p" value="toolsmng" /></p>'.
	'</form>'
	);
}

buffer::str(
'<p><a href="http://www.dotclear.net/plugins/">'.__('Install new plugins').'</a></p>'
);

$tools_actions = array(
	'&nbsp;' => '',
	__('delete') => 'delete',
	__('switch status') => 'switch'
);

# Traduction des plugins
foreach ($plugins_list as $k => $v)
{
	$plugins->loadl10n($k);
	
	$plugins_list[$k]['label'] = __($v['label']);
	$plugins_list[$k]['desc'] = __($v['desc']);
}

# Tri des plugins par leur nom
uasort($plugins_list,create_function('$a,$b','return strcmp($a["label"],$b["label"]);'));

buffer::str(
'<h3>'.__('List of installed plugins').'</h3>'.
'<form action="'.$tool_url.'" method="post" id="form-tools" >'
);

foreach ($plugins_list as $k => $v)
{
	$p_style_bg = '';
	if (file_exists($plugins_root.$k.'/icon.png')) {
		$p_style_bg = 'background: url(tools/'.$k.'/icon.png) center left no-repeat;';
	}
	$p_style = ' style="padding-left:40px;'.$p_style_bg.'"';

	$chk_enabled = false;
 	if ($k != 'toolsmng') {
		$chk_enabled = (is_writable($plugins_root.$k.'/desc.xml') || $is_writable); 
 	}

	if ($v['active']) {
		$tool_status_img = '<img src="images/check_on.png" '.
				'alt="'.__('This plugin is enabled').'" class="status" /> ';
		$tool_status_style = '';
		$tool_link = '<strong><a href="tools.php?p='.$k.'">'.__($v['label']).'</a></strong>';
	}
	else	{
		$tool_status_img = '<img src="images/check_off.png" '.
				'alt="'.__('This plugin is disabled').'" class="status" /> ';
		$tool_status_style = ' cancel';
		$tool_link = '<strong>'.__($v['label']).'</strong>';
	}
	
	buffer::str(
	"\n".'<div class="ligne'.$tool_status_style.'">'.
	'<p class="ligneTitre">'.
	$tool_status_img.
	form::checkbox('tool_ids[]',$k,'','','',!$chk_enabled).
	$tool_link.' - ('.$k.')</p>'.
	'<p'.$p_style.'>'.__($v['desc']).' <br />'.
	'par '.$v['author'].' - '.__('version').' '.$v['version'].' </p></div>'
	);
}

buffer::str(
'<div class="two-cols">'.
'<p class="col small checkboxes-helpers"></p>'.
'<p class="col right">'.
dcNonce::form().
'<label style="display: inline;">'.__('Action on selected plugins').'&nbsp;'.
form::combo('tools_action', $tools_actions).
'</label>&nbsp;<input type="submit" name="submit" class="submit" value="'.__('ok').'" />'.
'</p></div></form>'
);

// This panel's JS
$PLUGIN_HEAD =
'<script type="text/javascript">'."\n".
"//<![CDATA[\n".
"$(function() {\n".
"	$('#form-tools').submit(function() {\n".
"		var action = $(this).find('select[@name=\"tools_action\"]').val();\n".
"		var checked = false;\n".
"		$(this).find('input[@name=\"tool_ids[]\"]').each(function() {\n".
"			if (this.checked) {\n".
"				checked = true;\n".
"			}\n".
"		});\n".
"		if (!checked) { return false; }\n".
"		if (action == 'delete') {\n".
"			return window.confirm('".
jsHelpers::escapeJS(__('Are you sure you want to delete selected plugins?')).
"');\n".
"		}\n".
"		return true;\n".
"	});\n".
"});\n".
"\n//]]>\n".
'</script>';
?>