<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2004 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

$err = '';
$tool_url = 'tools.php?p=thememng';
$new_theme = '';

# Liste des thmes
$themes_root = dirname(__FILE__).'/../../../themes';
$themes = new plugins($themes_root,'theme');
$themes->getPlugins(false);
$themes_list = $themes->getPluginsList();

$is_writable = is_writable($themes_root);

$dc_ini_file = dirname(__FILE__).'/../../../conf/dotclear.ini';
$is_ini_writable = is_writable($dc_ini_file);

# Installation d'un thme
if ($is_writable && !empty($_POST['new_theme']))
{
	$new_theme = strip_tags($_POST['new_theme']);
	$parsed_url = parse_url($new_theme);
	
	if (empty($parsed_url['scheme']) || !preg_match('/^http|ftp$/',$parsed_url['scheme'])
	|| empty($parsed_url['host']) || empty($parsed_url['path']))
	{
		$err = __('URL is not valid.');
	}
	else
	{
		if (($err = $themes->install($new_theme)) === true)
		{
			header('Location: tools.php?p=thememng');
			exit;
		}
	}
}

# Utilisation d'un thme
if ($is_ini_writable && !empty($_POST['config'])) {
	$theme = strip_tags($_POST['theme']);
	
	if (in_array($theme,array_keys($themes_list)))
	{
		$objIni = new iniFile($dc_ini_file);
		$objIni->editVar('dc_theme',$theme);
		if ($objIni->saveFile() !== false) {
			header('Location: tools.php?p=thememng');
			exit;
		} else {
			$err = __('An error occured while writing configuration file.');
		}
		exit;
	}
}

# Suppression d'un thme
elseif ($is_writable && !empty($_POST['delete']) && !empty($_POST['theme_ids'])) {
	$themes = $_POST['theme_ids'];
	
	foreach ($themes as $theme) {
		$theme = strip_tags($theme);
		if (in_array($theme,array_keys($themes_list)) && $theme != 'default') {
			files::deltree($themes_root.'/'.$theme);
		}
	}
	header('Location: tools.php?p=thememng');
	exit;
}

if($err != '')
{
	buffer::str(
	'<div class="erreur"><p><strong>'.__('Error(s)').' :</strong></p>'.$err.'</div>'
	);
}

buffer::str(
'<h2>'.__('Themes manager').'</h2>'.
'<h3>'.__('Install a theme').'</h3>'
);

if (!$is_writable)
{
	buffer::str(
	'<p>'.sprintf(__('The folder %s is not writable, please check its permissions.'),
	'themes/').'</p>'
	);
	
}
else
{
	buffer::str(
	'<form action="tools.php?p=thememng" method="post">'.
	'<p><label for="new_theme">'.__('Please give the URL (http or ftp) of the theme\'s file').' :</label>'.
	form::field('new_theme',50,'',htmlspecialchars($new_theme)).'</p>'.
	'<p>'.
	dcNonce::form().
	'<input type="submit" class="submit" value="'.__('install').'" /></p>'.
	'</form>'
	);
}

buffer::str(
'<p><a href="http://www.dotclear.net/themes/">'.__('Install new themes').'</a></p>'
);

buffer::str(
'<h3>'.__('List of installed themes').'</h3>'.
'<form action="tools.php?p=thememng" method="post" id="form-themes">'
);

foreach ($themes_list as $k => $v)
{
	$themes->loadl10n($k);

	$screenshot = 'tools/thememng/noscreenshot.png';
	if (file_exists($themes_root.'/'.$k.'/screenshot.jpg')) {
		$screenshot = dc_app_url.'/themes/'.$k.'/screenshot.jpg';
	}

	buffer::str(
	"\n".'<div class="ligne">'.
	'<p class="ligneTitre">'.
	($k == dc_theme ? '<img src="images/selected.png" alt="'.__('Current theme').'" class="status"/> ' : '').
	'<input type="radio" name="theme" value="'.htmlspecialchars($k).'" '.
	(($k == dc_theme)?'checked="checked" ':' ').
	((!$is_ini_writable)?'disabled="disabled"':'').' />'.
	'<strong>'.__($v['label']).'</strong> - ('.$k.')</p>'.
	'<p><img src="'.$screenshot.'" width="240" height="210" alt="" '.
	'style="display:block; margin:0 10px 5px 0; float:left; border:1px solid #ccc;" />'.
	'<span>'.__($v['desc']).' <br />'.
	__('version').' '.$v['version'].' <br />'.
	'par '.$v['author'].'<br />'.
	'</span></p>'.
	(($k != dc_theme && $is_writable)?'<p class="field"><label>'.form::checkbox('theme_ids[]',htmlspecialchars($k)).'&nbsp;'.__('to be deleted').'</label></p>':'').

	'<div class="clear"></div></div>'
	);
}

buffer::str(
'<p>'.
dcNonce::form().
'<input type="submit" class="submit" name="config" value="'.__('Save').'" />'.
(($is_writable)?'&nbsp;<input type="submit" class="submit" name="delete" value="'.__('Delete selected themes').'"/>':'').
'</p>'.
'</form>');

$PLUGIN_HEAD =
'<script type="text/javascript">'."\n".
"//<![CDATA[\n".
"$(function() {\n".
"	$('#form-themes input[@name=\"delete\"]').click(function() {\n".
"		var checked = false;\n".		
"		$('#form-themes').find('input[@name=\"theme_ids[]\"]').each(function() {\n".
"			if (this.checked) {\n".
"				checked = true;\n".
"			}\n".
"		});\n".
"		if (!checked) { return false; }\n".	
"		return window.confirm('".
jsHelpers::escapeJS(__('Are you sure you want to delete selected themes?')).
"');\n".
"	});\n".
"});\n".
"\n//]]>\n".
'</script>';
?>