<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2004 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/inc/prepend.php';

$auth->check(1);

include dirname(__FILE__).'/inc/connexion.php';

$cmd = null;
$params = array();

// Treat posts actions
if (!empty($_POST['psts_action']) &&  !empty($_POST['p_ids'])) {
	$cmd = $_POST['psts_action'];	
	$ids = $_POST['p_ids'];
	
	foreach ($ids as $k => $v) {
		$ids[$k] = (integer)$v;
	}

	if (isset($_POST['redir']) && strpos($_POST['redir'],'://') === false) {
		$redir = strip_tags($_POST['redir']);
	}
	else	{
		$redir = 'index.php';
		
		if (!empty($_POST['q'])) {
			$redir .=
			'?q='.strip_tags($_POST['q']).
			'&env='.(integer)$_POST['env'];
		}
		else {
			$ret_params = array();
			foreach(array('cat_id','offline','selected','m','y','env') as $k) {
				if (!empty($_POST[$k])) {
					$ret_params[] = $k.'='.(integer)$_POST[$k];
				}
			}
			if (!empty($ret_params)) {
				$redir .= '?'.implode('&',$ret_params);
			}
		}
	}

	$params['sql'] = 'AND P.post_id IN('.implode(',',$ids).') ';
	$params['no_content'] = true;
	if (($posts = $blog->getPosts($params)) === false) {
		$err = $blog->error(1);
	}
	else {
		if ($cmd == 'status') { 
			while ($posts->fetch()) {
				if ($posts->f('user_id') == $_SESSION['sess_user_id'] || $_SESSION['sess_user_level'] >= 9) {
					if ($blog->statusPost($posts->f('post_id')) === false) {
						$err = $blog->error(1);
					}
				}
			}
			if (empty($err)) {
				header('Location: '.$redir);
				exit;
			}
		}
		
		elseif ($cmd == 'delete') {	
			while ($posts->fetch()) {
				if ($posts->f('user_id') == $_SESSION['sess_user_id'] || $_SESSION['sess_user_level'] >= 9) {
					if ($blog->delPost($posts->f('post_id')) === false) {
						$err = $blog->error(1);
					}
				}
			}
			if (empty($err)) {
				header('Location: '.$redir);
				exit;
			}
		}
		
		elseif ($cmd == 'category' && !empty($_POST['new_cat_id'])) {
			$new_cat_id = (integer)$_POST['new_cat_id'];
			while ($posts->fetch()) {
				if ($posts->f('user_id') == $_SESSION['sess_user_id'] || $_SESSION['sess_user_level'] >= 9) {
					if ($blog->updPostCat($posts->f('post_id'), $new_cat_id) === false) {
						$err = $blog->error(1);
					}
				}
			}
			if (empty($err)) {
				header('Location: '.$redir);
				exit;
			}		
		}
		
		elseif ($cmd == 'author' && !empty($_POST['new_user_id']) && $_SESSION['sess_user_level'] >= 9) {
			$new_user_id = $_POST['new_user_id'];
			
			if (($userRs = $blog->getUser($new_user_id)) !== false && !$userRs->isEmpty()) {
				while ($posts->fetch()) {
					$updReq =
					'UPDATE '.$blog->t_post.' '.
					"SET user_id='".$userRs->f('user_id')."' ".
					'WHERE post_id='.(integer)$posts->f('post_id');
					
					if (!$blog->con->execute($updReq)) {
						$blog->setError('MySQL : '.$blog->con->error(),2000);
						$err = $blog->error(1);
					} else {
						$blog->triggerMassUpd();
						$blog->tiggerLog('post',$posts->f('post_id'),'Change post author');
					}
				}
			}
			if (empty($err)) {
				header('Location: '.$redir);
				exit;
			}
		}
	}
}

# Sous menu
if (!empty($redir)) {
	$mySubMenu->addItem(
		'<strong>'.__('Back to list of entries').'</strong>',
		array(htmlspecialchars($redir),'accesskey="r"'),
		'images/ico_retour.png',
		false
		);
}

openPage(__('Entries'));

if (empty($cmd)) {
	closePage();
	exit;
}

if (!empty($err)) {
	echo 
	'<div class="erreur"><p><strong>'.__('Error(s)').' :</strong></p>'.
	$err.'</div>';
}

$hidden_fields = '';
while ($posts->fetch()) {
	$hidden_fields .= form::hidden('p_ids[]',$posts->f('post_id'));
}

if (isset($_POST['redir']) && strpos($_POST['redir'],'://') === false) {
	$hidden_fields .= form::hidden('redir',$_POST['redir']);
}
else {
	$hidden_fields .=
	form::hidden('cat_id',$_POST['cat_id']).
	form::hidden('offline',$_POST['offline']).
	form::hidden('selected',$_POST['selected']).
	form::hidden('m',$_POST['m']).
	form::hidden('y',$_POST['y']).
	form::hidden('q',$_POST['q']).
	form::hidden('env',$_POST['env']);
}

if ($cmd == 'category')
{
	echo '<h2>'.__('Change category for entries').'</h2>';
	
	$categories_combo = array('&nbsp;' => '');
	$categories = $blog->getCat();
	while ($categories->fetch()) {
		$categories_combo[$categories->f('cat_libelle')] = $categories->f('cat_id');
	}
	
	echo
	'<form action="posts_actions.php" method="post">'.
	'<p><label class="classic">'.__('Category:').' '.
	form::combo('new_cat_id',$categories_combo,'').
	'</p></label> ';
	
	echo
	'<p>'.
	$hidden_fields.
	form::hidden('psts_action','category').
	dcNonce::form().
	'<input type="submit" value="'.__('save').'" /></p>'.
	'</form>';
}
elseif ($cmd == 'author' && $_SESSION['sess_user_level'] >= 9)
{
	echo '<h2>'.__('Change author for entries').'</h2>';
	
	$users_combo = array('&nbsp;' => '');
	$users = $blog->getUser();
	while ($users->fetch()) {
		$users_combo[$users->f('user_id')] = $users->f('user_id');
	}
	
	echo
	'<form action="posts_actions.php" method="post">'.
	'<p><label class="classic">'.__('Author:').' '.
	form::combo('new_user_id',$users_combo,'').
	'</p></label> ';
	
	echo
	'<p>'.
	$hidden_fields.
	form::hidden('psts_action','author').
	dcNonce::form().
	'<input type="submit" value="'.__('save').'" /></p>'.
	'</form>';
}
else
{
	if (isset($_POST['redir']) && strpos($_POST['redir'],'://') === false) {
		echo '<p><a href="'.htmlspecialchars($_POST['redir']).'"></a></p>';
	}
}

closePage();
?>
