<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2004-2007 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

class jsHelpers
{
	function load($src)
	{
		return
		'<script type="text/javascript" src="'.
		htmlspecialchars($src,ENT_COMPAT,dc_encoding).
		'"></script>'."\n";
	}
	
	function jsvar($n,$v)
	{
		return $n." = '".jsHelpers::escapeJS($v)."';\n";
	}
	
	function common()
	{
		return
		jsHelpers::load('js/jquery/jquery.js').
		jsHelpers::load('js/jquery/jquery.cookie.js').
		jsHelpers::load('js/tools.js').
		
		'<script type="text/javascript">'."\n".
		"//<![CDATA[\n".
		jsHelpers::jsvar('dotclear.nonce',dcNonce::get()).
		jsHelpers::jsvar('dotclear.msg.show_all',
			__('show all')).
		jsHelpers::jsvar('dotclear.msg.hide_all',
			__('hide all')).
		jsHelpers::jsvar('dotclear.msg.select_all',
			__('select all')).
		jsHelpers::jsvar('dotclear.msg.invert_sel',
			__('invert selection')).
		jsHelpers::jsvar('dotclear.msg.confirm_delete_posts',
			__("Are you sure you want to delete selected entries?")).
		jsHelpers::jsvar('dotclear.msg.confirm_delete_post',
			__("Are you sure you want to delete this entry?")).
		jsHelpers::jsvar('dotclear.msg.confirm_delete_comments',
			__('Are you sure you want to delete selected comments?')).
		jsHelpers::jsvar('dotclear.msg.confirm_delete_trackbacks',
			__('Are you sure you want to delete selected trackbacks?')).
		jsHelpers::jsvar('dotclear.msg.confirm_delete_comment',
			__('Are you sure you want to delete this comment?')).
		jsHelpers::jsvar('dotclear.msg.confirm_delete_users',
			__('Are you sure you want to delete selected editors?')).
		jsHelpers::jsvar('dotclear.msg.confirm_delete_user',
			__('Are you sure you want to delete this editor?')).
		jsHelpers::jsvar('dotclear.msg.confirm_delete_categories',
			__('Are you sure you want to delete selected categories?')).
		jsHelpers::jsvar('dotclear.msg.confirm_delete_category',
			__('Are you sure you want to delete this category?')).
		"\n//]]>\n".
		"</script>\n";
	}
	
	function confirmClose()
	{
		$args = func_get_args();
		if (count($args) > 0) {
			foreach ($args as $k => $v) {
				$args[$k] = "'".jsHelpers::escapeJS($v)."'";
			}
			$args = implode(',',$args);
		} else {
			$args = '';
		}
		
		return
		jsHelpers::load('js/confirm-close.js').
		'<script type="text/javascript">'."\n".
		"//<![CDATA[\n".
		"confirmClosePage = new confirmClose(".$args."); ".
		"confirmClose.prototype.prompt = '".jsHelpers::escapeJS(__('You have unsaved changes.'))."'; ".
		"\n//]]>\n".
		"</script>\n";
	}

	function toolBar()
	{
		return
		'<script type="text/javascript" src="js/toolbar.js"></script>'.
		'<script type="text/javascript">'.
		"//<![CDATA[\n".
		"$(function() {
			if (document.getElementById) {
				var tb = new dcToolBar(document.getElementById('p_content'),
				document.getElementById('p_format'),'images/');
				
				tb.btStrong('".jsHelpers::escapeJS(__('Strong emphasis'))."');
				tb.btEm('".jsHelpers::escapeJS(__('Emphasis'))."');
				tb.btIns('".jsHelpers::escapeJS(__('Inserted'))."');
				tb.btDel('".jsHelpers::escapeJS(__('Deleted'))."');
				tb.btQ('".jsHelpers::escapeJS(__('Inline quote'))."');
				tb.btCode('".jsHelpers::escapeJS(__('Code'))."');
				tb.addSpace(10);
				tb.btBr('".jsHelpers::escapeJS(__('Line break'))."');
				tb.addSpace(10);
				tb.btBquote('".jsHelpers::escapeJS(__('Blockquote'))."');
				tb.btPre('".jsHelpers::escapeJS(__('Preformated text'))."');
				tb.btList('".jsHelpers::escapeJS(__('Unordered list'))."','ul');
				tb.btList('".jsHelpers::escapeJS(__('Ordered list'))."','ol');
				tb.addSpace(10);
				tb.btLink('".jsHelpers::escapeJS(__('Link'))."',
					'".jsHelpers::escapeJS(__('URL?'))."',
					'".jsHelpers::escapeJS(__('Language?'))."',
					'".DC_LANG."');
				tb.btImgLink('".jsHelpers::escapeJS(__('External image'))."',
					'".jsHelpers::escapeJS(__('URL?'))."');
				tb.addSpace(10);
				tb.btImg('".jsHelpers::escapeJS(__('Internal image'))."','images-popup.php');
				tb.draw('".jsHelpers::escapeJS(__('You can use the following shortcuts to refine your layout.'))."');
			}
		});
		\n//]]>\n
		</script>";
	}

	function dragSort()
	{
		return
		'<script type="text/javascript" src="js/drag.js"></script>'."\n".
		'<script type="text/javascript" src="js/dragsort.js"></script>'."\n";
	}
	
	function escapeJS($str)
	{
		$str = htmlspecialchars($str,ENT_NOQUOTES,dc_encoding);
		$str = str_replace("'","\'",$str);
		$str = str_replace('"','\"',$str);
		return $str;
	}
}
?>