<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2007 dcTeam and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****
class dcNonce
{
	function init()
	{
		if (!defined('DC_NO_SESSION') && !isset($_SESSION['token'])) {
			dcNonce::set();
		}
	}

	function set()
	{
		if (!defined('DC_NO_SESSION')) {
			$token = md5(uniqid(mt_rand(),true));
			$_SESSION['token'] = $token;
			$_SESSION['token_ts'] = time();
		}
	}

	function get()
	{
		if (!defined('DC_NO_SESSION') && isset($_SESSION['token'])) {
			return $_SESSION['token'];
		}
	}

	function form()
	{
		if (!defined('DC_NO_SESSION') && isset($_SESSION['token'])) {
			return '<input type="hidden" name="dctoken" value="'.$_SESSION['token'].'" />';
		}
	}

	function tokenEnabledURL($url,$filter = false)
	{
		if (($res = parse_url($url)) !== false) {
			$rewritten = $url;
			if (!empty($res['query'])) {
				$res['query'] .= '&dcnonce='.dcNonce::get();

				$rewritten = '';
				$rewritten .= (empty($res['scheme']))?'':$res['scheme'].'://';
				$rewritten .= (empty($res['host']))?'':$res['host'];
				$rewritten .= (empty($res['path']))?'':$res['path'];
				$rewritten .= (empty($res['query']))?'':'?'.$res['query'];
				$rewritten .= (empty($res['fragment']))?'':'#'.$res['fragment'];
			}
			return ($filter)?htmlspecialchars($rewritten,ENT_QUOTES,dc_encoding):$rewritten;
		}
		return ($filter)?htmlspecialchars($url,ENT_QUOTES,dc_encoding):$url;
	}

	function check()
	{
		if (defined('DC_NO_SESSION')) return true;

		if (!isset($_SESSION['token'])) return false;

		if (!empty($_POST)) {
			if (!isset($_POST['dctoken'])) return false;
			if ($_POST['dctoken'] == $_SESSION['token']) {
				return true;
			}
		}
		return true;
	}

	function enforceGetCheck()
	{
		if (!defined('DC_NO_SESSION'))
		{
			if (!isset($_SESSION['token']) || !isset($_GET['dcnonce']) ||
				$_GET['dcnonce'] != $_SESSION['token'])
			{
				util::httpHead(412);
				header('Content-Type: text/plain');
				echo 'Precondition Failed';
				exit;
			}
		}
	}
}
?>
