<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2004 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/inc/prepend.php';
require dirname(__FILE__).'/../inc/classes/class.multipage.php';

$auth->check(1);

include dirname(__FILE__).'/inc/connexion.php';

$nb_per_page = 20;
$nb_comments = $blog->getComments(array(),true);

$max_pages = ceil($nb_comments/$nb_per_page);
$env = (!empty($_GET['env']) && (integer)$_GET['env'] <= $max_pages) ? (integer)$_GET['env'] : 1;

$comments = $blog->getComments('','DESC',(($env-1)*$nb_per_page).','.$nb_per_page);
$comment_actions = array(
	'' => '&nbsp;',
	'status' => __('switch status'),
	'delete' => __('delete')
	);

# Ligne pour afficher un commentaire
function ligne_comment($data,$i)
{
	$comment_id = $data['comment_id'];
	$comment_dt = $data['comment_dt'];
	$comment_auteur = $data['comment_auteur'];
	$comment_email = $data['comment_email'];
	$comment_site = $data['comment_site'];
	$comment_content = $data['comment_content'];
	$comment_pub = $data['comment_pub'];
	$comment_ip = $data['comment_ip'];
	$comment_trackback = $data['comment_trackback'];
	$post_titre = $data['post_titre'];
	$post_id = $data['post_id'];
	$user_id = $data['user_id'];
	$comment_date = date('d/m/Y H:i',strtotime($comment_dt));
	
	if ($comment_pub) {
		$com_style = '';
		$com_img = '<img src="images/check_on.png" '.
				'alt="'.__('This comment is online').'" class="status" /> ';
	}
	else	{
		$com_style = ' cancel';
		$com_img = '<img src="images/check_off.png" '.
				'alt="'.__('This comment is offline').'" class="status" /> ';
	}
	
	$str_tb = ($comment_trackback == 1) ? ' - <strong>trackback</strong>' : '';

	$edit_link = '';
	$can_edit = false;
	if ($_SESSION['sess_user_level'] == 9 || $data['user_id'] == $_SESSION['sess_user_id']) {
		$edit_link .=
			' - [ <strong><a href="comment.php?comment_id='.$comment_id.'">'.__('edit').
			'</a></strong> ]';
		$can_edit = true;
	}
	
	$res = '<div class="ligne'.$com_style.'">'.
		'<h3 class="ligneTitre">'.
		$com_img.
		form::checkbox('c_ids[]',$comment_id,'','','',!$can_edit).
		'<img src="images/plus.png" id="img_comment'.$comment_id.'" class="toggle-imgs" '.
		' alt="'.__('show/hide').'" title="'.__('show/hide').'" />&nbsp;&nbsp;'.
		'<a href="poster.php?post_id='.$post_id.'#c'.$comment_id.'">'.
		$post_titre.'</a>'.$str_tb.
		'</h3>'.
		'<p class="ligneInfo">'.$comment_date.' - '.$comment_auteur.$edit_link.'</p>';
	
	$res .= '<div id="comment'.$comment_id.'" class="comment" style="display:none">'.
		$comment_content.
		'<p class="ligneInfo">'.
		'<strong>'.__('Email').'&nbsp;:</strong> '.$comment_email.'<br />'.
		'<strong>'.__('Site').'&nbsp;:</strong> '.(($comment_site) ? 'http://'.$comment_site : '').'<br />'.
		'<strong>@IP :</strong> '.$comment_ip.
		'</p>'.
		'</div>';
	
	$res .= '</div>';
	
	return $res;
}

# Affichage
openPage(
	__('Comments'),
	'<script type="text/javascript">'."\n".
	"//<![CDATA[\n".
	"$(function() {\n".
	"	dotclear.commentsActionsHelper();\n".
	"});\n".
	"\n//]]>\n".
	'</script>'
	);

echo '<h2>'.__('Comments').'</h2>';
echo '<p>'.__('Comments listed from most recent to oldest').'</p>';

$lum = new multipage($env,'ligne_comment',$comments->getData(),$nb_comments,$nb_per_page);

$lum->setOption(
	'html_block',
	'<p class="small toggle-helpers" id="trg_form-comments"></p>'.
	'<form action="comments_actions.php" method="post" id="form-comments" '.
	'onsubmit="return confirmDelete(this,\'cmts\',\''.
	addslashes(__('Are you sure you want to delete the selected comments?')).'\')">'.
	'%s'.
	'<div class="two-cols">'.
	'<p class="col small checkboxes-helpers"></p>'.
	'<p class="col right">'.dcNonce::form().
	'<input type="hidden" name="env" value="'.$env.'" />'.
	'<label style="display: inline;">'.__('Action on selected comments').'&nbsp;'.
	form::combo('cmts_action', array_flip($comment_actions)).
	'</label>&nbsp;<input type="submit" name="submit" class="submit" value="'.__('ok').'" />'.
	'</p></div></form>'
	);
$lum->setOption('html_row','%s');
$lum->setOption('html_cell','%s');

$lum->setOption('html_links','<p>'.__('Page(s)').' : %s</p>');
$lum->setOption('html_cur_page','<strong>%s</strong>');

$lum->setOption('html_prev','&lt;'.__('prev. page'));
$lum->setOption('html_next',__('next page').'&gt;');
$lum->setOption('html_prev_grp','...');
$lum->setOption('html_next_grp','...');

$lum->setOption('html_empty','<p><strong>'.__('No comment yet').'</strong></p>');

echo $lum->getLinks();
echo $lum->getPage();
echo $lum->getLinks();

closePage();
?>
