<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2004 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/inc/prepend.php';

$auth->check(5);

include dirname(__FILE__).'/inc/connexion.php';

$err = '';

# Reord
if (!empty($_POST['reord']))
{
	if ($blog->reordCats(false,true) === false) {
		$err = $blog->error(1);
	} else {
		header('Location: cat_list.php');
		exit;
	}
}

# Delete
if (!empty($_POST['delete']) && !empty($_POST['cat_ids']))
{
	$ids = $_POST['cat_ids'];
	$has_error = false;
	foreach ($ids as $id)
	{
		if ($blog->delCat((integer)$id) === false) {
			$has_error = true;
		}
	}
	if (!$has_error) {
		$msg = __('selected categories have been deleted');
	} else {
		$msg = __('Cannot delete some categories');		
	}
	header('Location: cat_list.php&msg='.urlencode($msg));
	exit;
}

# Classic ord
if (isset($_POST['catOrd']) && is_array($_POST['catOrd']))
{
	if ($blog->ordCats($_POST['catOrd']) === false) {
		$err = $blog->error(1);
	} else {
		header('Location: cat_list.php');
		exit;
	}
}

# DragNdrop
if (!empty($_POST['dndSort']))
{
	$catOrd = array();
	foreach (explode(';',$_POST['dndSort']) as $k => $v) {
		$catOrd[substr($v,3)] = $k;
	}
	
	if ($blog->ordCats($catOrd) === false) {
		$err = $blog->error(1);
	} else {
		header('Location: cat_list.php');
		exit;
	}
}

$mySubMenu->addItem('<strong>'.__('New category').'</strong>','categorie.php','images/ico_new.png',false);

openPage(
	__('Categories list'),
	jsHelpers::dragSort().
	'<script type="text/javascript">'."\n".
	"//<![CDATA[\n".
	"$(function() {\n".
	"    dragSort.dest = document.getElementById('dndSort');\n".
	"    dragSort.makeElementSortable(document.getElementById('sortcat'));\n".
	"	$('#form-categories input[@name=\"delete\"]').click(function() {\n".
	"		var checked = false;\n".		
	"		$('#form-categories').find('input[@name=\"cat_ids[]\"]').each(function() {\n".
	"			if (this.checked) {\n".
	"				checked = true;\n".
	"			}\n".
	"		});\n".
	"		if (!checked) { return false; }\n".	
	"		return window.confirm(dotclear.msg.confirm_delete_categories);\n".
	"	});\n".
	"});\n".
	"\n//]]>\n".
	'</script>'
	);
?>
<h2><?php echo __('Categories list'); ?></h2>

<?php
if ($err != '')
{
	echo '<div class="erreur"><p><strong>'.__('Error(s)').' :</strong></p>'.
		$err.'</div>';
}

$rsCat = $blog->getCat('','cat_ord');

if ($rsCat->isEmpty())
{
	echo '<p>'.__('No category yet').'</p>';
}
else
{
	echo '<p>'.__('Drag items to change their positions.').'</p>';
	echo '<form action="cat_list.php" method="post" id="form-categories">';
	
	echo '<div id="sortcat">';
	$has_deletable = false;
	while(!$rsCat->EOF())
	{
		$cat_id = $rsCat->field('cat_id');
		$cat_ord = $rsCat->field('cat_ord');
		$cat_libelle = $rsCat->field('cat_libelle');
		$cat_nb_post = (integer) $rsCat->field('nb_post');
		
		echo
		'<div class="sort" id="dnd'.$cat_id.'">'.
		'<p>'.form::checkbox('cat_ids[]',$cat_id,'','','',(boolean)$cat_nb_post).'&nbsp;<strong><a href="categorie.php?cat_id='.$cat_id.'">'.
		$cat_libelle.'</a></strong>';
		
		if ($cat_nb_post > 0)
		{
			echo ' - <a href="index.php?cat_id='.$cat_id.'">'.
			(($cat_nb_post>1) ? sprintf(__('%d entries'),$cat_nb_post) : sprintf(__('%d entry'),$cat_nb_post)).
			'</a>';
		}
		else
		{
			$has_deletable = true;
		}
		
		echo
		'</p>'.
		'<p class="nojsfield"><label for="catOrd'.$cat_id.'" class="inline">'.__('Position').' : </label>'.
		form::field(array('catOrd['.$cat_id.']','catOrd'.$cat_id),3,3,$cat_ord).'</p>'.
		'</div>';
		
		$rsCat->moveNext();
	}
	
	echo '<p class="col small checkboxes-helpers"></p>'.
	'</div>'.
	'<div class="two-cols" style="margin-top:0.5em;">'.
	'<p class="col"><input type="hidden" id="dndSort" name="dndSort" value="" />'.
	dcNonce::form().
	'<input type="submit" class="submit" value="'.__('save order').'" />&nbsp;'.
	'<input type="submit" class="submit" name="reord" value="'.__('Reorder categories').'" /></p>';
	
	if ($has_deletable)
	{
		echo 
		'<p class="col right">'.
		'<input type="submit" class="submit" name="delete" value="'.__('Delete selected categories').'" />'.
		'</p>';
	}
	
	echo
	'</div>'.
	'</form>';
}
?>
<?php closePage(); ?>
