<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2004 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

class util
{
	# Retourne une paire de l'lment suivant ou prcdent d'un tableau 
	# un indice donn
	function getNextPrev($array,$key,$mode)
	{
		$keys = array_keys($array);
		$values = array_values($array);
		$p = array_flip($keys);
		$pos = !empty($p[$key]) ? $p[$key] : 0;
		
		
		if($mode == 'next') {
			return ($pos+1 < count($array)) ? array($keys[$pos+1] => $values[$pos+1]) : NULL;
		} else {
			return ($pos > 0) ? array($keys[$pos-1] => $values[$pos-1]) : NULL;
		}
	}
	
	# Obtenir l'host complet
	function getHost()
	{
		$server_name = explode(':',$_SERVER['HTTP_HOST']);
		$server_name = $server_name[0];
		if (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on')
		{
			$scheme = 'https';
			$port = ($_SERVER['SERVER_PORT'] != '443') ? ':'.$_SERVER['SERVER_PORT'] : '';
		}
		else
		{
			$scheme = 'http';
			$port = ($_SERVER['SERVER_PORT'] != '80') ? ':'.$_SERVER['SERVER_PORT'] : '';
		}
		
		return $scheme.'://'.$server_name.$port;
	}
	
	# Obtenir l'url complte de la page
	function getPageURL($uri=NULL)
	{
		if ($uri == NULL) {
			$uri = htmlspecialchars($_SERVER['REQUEST_URI']);
		}
		
		return util::getHost().$uri;
	}
	
	# Couper une chane aux espaces
	function cutString($str,$l)
	{
		$s = preg_split('/([\s]+)/',$str,-1,PREG_SPLIT_DELIM_CAPTURE);
		
		$res = '';
		$L = 0;
		
		if (strlen($s[0]) >= $l) {
			return substr($s[0],0,$l);
		}
		
		foreach ($s as $v)
		{
			$L = $L+strlen($v);
			
			if ($L > $l) {
				break;
			} else {
				$res .= $v;
			}
		}
		
		return trim($res);
	}
	
	# Converti une chane Latin1 en UTF-8 et effectue la translation
	# des caractres litigieux.
	function latin1utf8($str)
	{
		$conv = array(
		chr(194).chr(128) => chr(226).chr(130).chr(172),
		chr(194).chr(130) => chr(226).chr(128).chr(154),
		chr(194).chr(131) => chr(198).chr(146),
		chr(194).chr(132) => chr(226).chr(128).chr(158),
		chr(194).chr(133) => chr(226).chr(128).chr(166),
		chr(194).chr(134) => chr(226).chr(128).chr(160),
		chr(194).chr(135) => chr(226).chr(128).chr(161),
		chr(194).chr(136) => chr(203).chr(134),
		chr(194).chr(137) => chr(226).chr(128).chr(176),
		chr(194).chr(138) => chr(197).chr(160),
		chr(194).chr(139) => chr(226).chr(128).chr(185),
		chr(194).chr(140) => chr(197).chr(146),
		chr(194).chr(145) => chr(226).chr(128).chr(152),
		chr(194).chr(146) => chr(226).chr(128).chr(153),
		chr(194).chr(147) => chr(226).chr(128).chr(156),
		chr(194).chr(148) => chr(226).chr(128).chr(157),
		chr(194).chr(149) => chr(226).chr(128).chr(162),
		chr(194).chr(150) => chr(226).chr(128).chr(147),
		chr(194).chr(151) => chr(226).chr(128).chr(148),
		chr(194).chr(152) => chr(203).chr(156),
		chr(194).chr(153) => chr(226).chr(132).chr(162),
		chr(194).chr(154) => chr(197).chr(161),
		chr(194).chr(155) => chr(226).chr(128).chr(186),
		chr(194).chr(156) => chr(197).chr(147),
		chr(194).chr(159) => chr(197).chr(184)
		);
		
		$str = utf8_encode($str);
		
		return str_replace(array_keys($conv),array_values($conv),$str);
	}
	
	/**
	Reconnait une chane en UTF-8
	Taken from http://www.php.net/manual/fr/function.mb-detect-encoding.php#50087
	*/
	function isUTF8($string)
	{
		if (preg_match('%^(?:[\x09\x0A\x0D\x20-\x7E])*$%xs',$string))
		{
			return false;
		}
		else
		{
			// From http://w3.org/International/questions/qa-forms-utf-8.html
			return preg_match('%^(?:
				  [\x09\x0A\x0D\x20-\x7E]			# ASCII
				| [\xC2-\xDF][\x80-\xBF]				# non-overlong 2-byte
				| \xE0[\xA0-\xBF][\x80-\xBF]			# excluding overlongs
				| [\xE1-\xEC\xEE\xEF][\x80-\xBF]{2}	# straight 3-byte
				| \xED[\x80-\x9F][\x80-\xBF]			# excluding surrogates
				| \xF0[\x90-\xBF][\x80-\xBF]{2}		# planes 1-3
				| [\xF1-\xF3][\x80-\xBF]{3}			# planes 4-15
				| \xF4[\x80-\x8F][\x80-\xBF]{2}		# plane 16
			)*$%xs', $string);
		}
	}
	
	/**
	Encodage d'une chaine en mime Quoted printable
	*/
	function mimeEncode($s,$charset='UTF-8')
	{
		$s = preg_replace('/([^\x21-\x3c\x3e-\x7e])/e','"=".strtoupper(dechex(ord("\1")))',$s);
		
		return '=?'.$charset.'?Q?'.$s.'?=';
	}

	/**
	@function httpHead
	
	Sends an HTTP code and message to client
	
	@param code	string		HTTP code
	@param msg	string		Message
	*/
	function httpHead($code,$msg=null)
	{
		$status_mode = preg_match('/cgi/',php_sapi_name());
		
		if (!$msg)
		{
			$msg_codes = array(
				100 => 'Continue',
				101 => 'Switching Protocols',
				200 => 'OK',
				201 => 'Created',
				202 => 'Accepted',
				203 => 'Non-Authoritative Information',
				204 => 'No Content',
				205 => 'Reset Content',
				206 => 'Partial Content',
				300 => 'Multiple Choices',
				301 => 'Moved Permanently',
				302 => 'Found',
				303 => 'See Other',
				304 => 'Not Modified',
				305 => 'Use Proxy',
				307 => 'Temporary Redirect',
				400 => 'Bad Request',
				401 => 'Unauthorized',
				402 => 'Payment Required',
				403 => 'Forbidden',
				404 => 'Not Found',
				405 => 'Method Not Allowed',
				406 => 'Not Acceptable',
				407 => 'Proxy Authentication Required',
				408 => 'Request Timeout',
				409 => 'Conflict',
				410 => 'Gone',
				411 => 'Length Required',
				412 => 'Precondition Failed',
				413 => 'Request Entity Too Large',
				414 => 'Request-URI Too Long',
				415 => 'Unsupported Media Type',
				416 => 'Requested Range Not Satisfiable',
				417 => 'Expectation Failed',
				500 => 'Internal Server Error',
				501 => 'Not Implemented',
				502 => 'Bad Gateway',
				503 => 'Service Unavailable',
				504 => 'Gateway Timeout',
				505 => 'HTTP Version Not Supported'
			);
			
			$msg = isset($msg_codes[$code]) ? $msg_codes[$code] : '-';
		}
		
		if ($status_mode) {
			header('Status: '.$code.' '.$msg);
		} else {
			if (version_compare(phpversion(),'4.3.0','>=')) {
				header($msg, TRUE, $code);
			} else {
				header('HTTP/1.x '.$code.' '.$msg);
			}
		}
	}
 
	/**
	@function relToAbsURL
	
	Convert all relative URLs to absolute ones in a given text chunk
	
	@param text	string		Text to scan
	@param msg	string		Base URL
	*/
	function relToAbsURL($text,$base = '')
	{
		if (empty($base)) {
			$base = util::getHost();
		}		
		if (substr($base,-1,1) != '/') {
			$base .= '/';
		}
		
		# Replace links
		$pattern = "/<a([^>]*) href=\"[^http|ftp|https]([^\"]*)\"/";
		$replace = "<a\${1} href=\"".$base."\${2}\"";
		$text = preg_replace($pattern,$replace,$text);
		
		# Replace images
		$pattern = "/<img([^>]*) src=\"[^http|ftp|https]([^\"]*)\"/";
		$replace = "<img\${1} src=\"".$base."\${2}\"";
		$text = preg_replace($pattern,$replace,$text);

		return $text;
	}
}
?>
