<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2004 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/inc/prepend.php';

$auth->check(9);

include dirname(__FILE__).'/inc/connexion.php';

# Suppresion d'un rdacteur
if (!empty($_POST['delete']) && !empty($_POST['user_ids']))
{
	$ids = $_POST['user_ids'];
	$has_error = false;
	foreach ($ids as $id)
	{
		if ($blog->delUser($id) === false) {
			$has_error = true;
		}
	}
	if (!$has_error) {
		$msg = __('Editor(s) successfully deleted');
		header('Location: redac_list.php?msg='.rawurlencode($msg));
		exit;
	} else {
		$err = $blog->error(1);
	}
}
			
$rsUser = $blog->getUser();
$mySubMenu->addItem('<strong>'.__('New editor').'</strong>','redacteur.php','images/ico_new.png',false);
openPage(
	__('List of editors'),
	'<script type="text/javascript">'."\n".
	"//<![CDATA[\n".
	"$(function() {\n".
	"	$('#form-users input[@name=\"delete\"]').click(function() {\n".
	"		var checked = false;\n".		
	"		$('#form-users').find('input[@name=\"user_ids[]\"]').each(function() {\n".
	"			if (this.checked) {\n".
	"				checked = true;\n".
	"			}\n".
	"		});\n".
	"		if (!checked) { return false; }\n".	
	"		return window.confirm(dotclear.msg.confirm_delete_users);\n".
	"	});\n".
	"});\n".
	"\n//]]>\n".
	'</script>'
	);

echo '<h2>'.__('List of editors').'</h2>';
echo '<form action="redac_list.php" method="post" id="form-users">';

$has_deletable = false;
while(!$rsUser->EOF())
{
	$user_level = $rsUser->field('user_level');
	$user_nb_post = $rsUser->field('nb_post');
		
	if ($user_level == 9) {
		$user_level = __('administrator');
	} elseif ($user_level == 5) {
		$user_level = __('advanced editor');
	} elseif ($user_level == 1) {
		$user_level = __('editor');
	} elseif ($user_level == 0) {
		$user_level = __('inactive');
	}
	
	$style = ($rsUser->f('user_level') == 0) ? ' style="color:#999;"' : '';
	$is_deletable = (boolean)(($user_nb_post == 0) && $rsUser->field('user_id') != $_SESSION['sess_user_id']);
	
	if ($is_deletable)
	{
		$has_deletable = true;
	}
	echo '<div class="ligne clear"'.$style.'>'.
		'<h3 class="ligneTitre">'.
		'<label>'.form::checkbox('user_ids[]',$rsUser->field('user_id'),'','','',!$is_deletable).
		' '.$rsUser->field('user_id').'</label></h3>'.
		'<p class="semi">'.
		$rsUser->field('user_prenom').' '.$rsUser->field('user_nom').
		' ('.$user_level.')'.
		' [ <strong><a href="redacteur.php?id='.rawurlencode($rsUser->field('user_id')).'">'.
		__('edit').'</a></strong> ] ';
	
	if ($user_nb_post > 0) {
		echo $user_nb_post.' billet';
		echo ($user_nb_post > 1) ? 's' : '';
	}
		
	echo '</p></div>';
	
	$rsUser->moveNext();
}

if ($has_deletable)
{
	echo 
	'<div class="two-cols">'.
	'<p class="col small checkboxes-helpers"></p>'.
	'<p class="col right">'.
	dcNonce::form().
	'<input type="submit" class="submit" name="delete" value="'.__('Delete selected editors').'" />'.
	'</p></div>';
}
echo '</form>';

closePage();
?>
