<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2004 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/inc/prepend.php';

$auth->check(1);

include dirname(__FILE__).'/inc/connexion.php';

$cmd = null;

# Mise hors ligne d'un commentaire
if (!empty($_POST['cmts_action']) && !empty($_POST['c_ids']))
{
	$cmd = $_POST['cmts_action'];
	$ids = $_POST['c_ids'];

	foreach ($ids as $k => $v) {
		$ids[$k] = (integer)$v;
	}

	if (isset($_POST['redir']) && strpos($_POST['redir'],'://') === false) {
		$redir = strip_tags($_POST['redir']);
	}
	else	{
		$redir = 'comments.php?env='.(integer)$_POST['env'];
	}

	if (($comments = $blog->getComments(array('c_id' => $ids,'no_content' => true))) === false) {
		$err = $blog->error(1);
	}
	else
	{
	 	if ($cmd == 'status') {
			while ($comments->fetch()) {
				if ($comments->f('user_id') == $_SESSION['sess_user_id'] || $_SESSION['sess_user_level'] >= 9) {
					if ($blog->statusComment($comments->f('comment_id')) === false) {
						$err = $blog->error(1);
					}
				}
			}
			if (empty($err)) {
				header('Location: '.$redir);
				exit;
			}
		}
		
		elseif ($cmd == 'delete') {
			while($comments->fetch()) {
				if ($comments->f('user_id') == $_SESSION['sess_user_id'] || $_SESSION['sess_user_level'] >= 9) {
					if ($blog->delComment($comments->f('comment_id')) === false) {
						$err = $blog->error(1);
					}
				}
			}
			if (empty($err)) {
				//$msg = __('Selected comments successfully removed');
				header('Location: '.$redir);
				exit;
			}
		}
	}
}

# Sous menu
if (!empty($redir)) {
	$mySubMenu->addItem(
		'<strong>'.__('Back to list of comments').'</strong>',
		array(htmlspecialchars($redir),'accesskey="r"'),
		'images/ico_retour.png',
		false
		);
}

openPage(__('Comments'));

if (!empty($err)) {
	echo
	'<div class="erreur"><p><strong>'.__('Error(s)').' :</strong></p>'.
	$err.'</div>';
}

if (isset($_POST['redir']) && strpos($_POST['redir'],'://') === false) {
	echo '<p><a href="'.htmlspecialchars($_POST['redir']).'"></a></p>';
}

closePage();
?>
