<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2004 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

define('NOT_CHECK_CONFIG',true);

require dirname(__FILE__).'/prepend.php';

require dirname(__FILE__).'/__top.php';

define('CONF_ONLY',true);
require dirname(__FILE__).'/../conf/config.php';


$con = new connection(DB_USER,DB_PASS,DB_HOST,DB_DBASE);

$sql_check = new checklist();

$xsql = new xmlsql($con,implode('',file(dirname(__FILE__).'/db-upgrade.xml')));
$xsql->replace('{{PREFIX}}',DB_PREFIX);
$xsql->execute($sql_check);

if ($sql_check->checkAll())
{
	$blog = new blog($con,DB_PREFIX,NULL);
	
	# Mise  jour de la table post (titre_url)
	if ($sql_check->checkItem('post_titre_url') === true)
	{
		$rs = $con->select('SELECT post_id, post_titre FROM '.DB_PREFIX.'post');
		$up_t_url = true;
		$up_t_url_msg = $up_t_url_err = 'Update URLed titles';
		while (!$rs->EOF()) {
			if ($rs->f('post_titre_url') == '') {
				$updReq = 'UPDATE '.DB_PREFIX.'post SET '.
						'post_titre_url = \''.$con->escapeStr($blog->str2url($rs->f('post_titre'))).'\' '.
						'WHERE post_id = '.$rs->f('post_id').' ';
				if ($con->execute($updReq) === false) {
					$up_t_url = false;
					$up_t_url_err .= ' failed - '.$con->error();
					break(1);
				}
			}
			$rs->moveNext();
		}
		$sql_check->addItem('up_t_url',$up_t_url,$up_t_url_msg,$up_t_url_err); 
	}
	
	# Rordonne les catgories
	$sql_check->addItem('reord_cat',$blog->reordCats(true),
	'Reord categories','Reord categories failed'
	);
	
	# Mise  jour du fichier dotclear.ini
	$objIni = new iniFile(dirname(__FILE__).'/../conf/dotclear.ini');
	
	$objIni->createVar('dc_comments_ttl',0,
	'Temps de vie (en jours) des commentaires et trackbacks (0 = infini)');
	$objIni->createVar('dc_upload_size',251200,
	"Format maximum d'une image largeur x hauteur\nexemples : 600x600, 600, 600x, x600");
	$objIni->createVar('dc_time_delta',0,
	"Dcalage horaire global (entre -12 et 12)");
	$objIni->createVar('dc_blog_desc','',
	'Description courte du weblog (pour les fils RSS et Atom');
	$objIni->createVar('dc_comments_pub',1,
	'Publier directement les nouveaux commentaires');
	
	$sql_check->addItem('ini_file',$objIni->saveFile(),
	'Update of ini file','Update of ini file failed'
	);
	
	# On recompte tout
	$blog->countAll();
}

$con->close();

echo '<h2>'.__('Upgrade DotClear').'</h2>';

echo $sql_check->getHTML($img_chk_on,$img_chk_off,$img_chk_wrn);

if ($sql_check->checkAll()) {
	echo '<p><strong>DotClear successfully upgraded</strong></p>';
	echo '<p><a href="../'.DC_ECRIRE.'/">Log in</a></p>';
	if ($sql_check->checkWarnings()) {
		echo
		'<p><strong>Note:</strong> DotClear will run properly even if warnings are issued.</p>';
	}
} else {
	echo '<p class="important">Unable to upgrade DotClear</p>';
}


?>

<?php require dirname(__FILE__).'/__bottom.php'; ?>
