<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2004 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

define('STEP',4);

require dirname(__FILE__).'/prepend.php';

require dirname(__FILE__).'/__top.php';

$con = new connection($_SESSION['sess_db_user'],$_SESSION['sess_db_pass'],
		$_SESSION['sess_db_host'],$_SESSION['sess_db_name']);

$sql_check = new checklist();

$xsql = new xmlsql($con,implode('',file(dirname(__FILE__).'/db-create.xml')));
$xsql->replace('{{PREFIX}}',$_SESSION['sess_db_prefix']);
$xsql->execute($sql_check);

$con->close();

echo '<h2>'.__('Tables creation').'</h2>';

echo $sql_check->getHTML($img_chk_on,$img_chk_off,$img_chk_wrn);

if (!$sql_check->checkAll())
{
	echo '<p class="important">'.
	__('Unable to create all tables. Please check if the tables don\'t exist yet.').'</p>';
}
else
{
	echo '<p><strong>'.__('Tables successfully created.').'</strong></p>';
	if ($sql_check->checkWarnings()) {
		echo
		'<p>'.__('DotClear will run properly even if warnings are issued.').'</p>';
	}
	
	echo
	'<form action="db-user.php" method="post">'.
	'<p><input type="submit" class="submit" value="'.__('Create user').' &#187;" /></p>'.
	'</form>';
	$_SESSION['sess_step'] = 5;
}
?>

<?php require dirname(__FILE__).'/__bottom.php'; ?>
