<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2004 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****


/* --------------------------------------------------------
                DO NOT EDIT THIS FILE
               NE PAS EDITER CE FICHIER
-------------------------------------------------------- */




#Version de DotClear
if (file_exists(dirname(__FILE__).'/../VERSION')) {
	define('DC_VERSION',trim(implode('',file(dirname(__FILE__).'/../VERSION'))));
} else {
	define('DC_VERSION','?');
}


# Chargement du fichier ini
require_once dirname(__FILE__).'/classes/class.ini.file.php';
iniFile::read(dirname(__FILE__).'/../conf/dotclear.ini');

# Chargement du layout d'URL
if (dc_url_scan == 'path_info')
{
	if (!defined('dc_format_post_url')) { define('dc_format_post_url','%04d/%02d/%02d/%d-%s'); }
	if (!defined('dc_format_cat_url')) { define('dc_format_cat_url','%s'); }
	if (!defined('dc_format_archive_url')) { define('dc_format_archive_url','%s/%02d'); }
	if (!defined('dc_format_day_url')) { define('dc_format_day_url','%s/%02d/%02d'); }
}
elseif (dc_url_scan == 'query_string')
{
	if (!defined('dc_format_post_url')) { define('dc_format_post_url','?%04d/%02d/%02d/%d-%s'); }
	if (!defined('dc_format_cat_url')) { define('dc_format_cat_url','?%s'); }
	if (!defined('dc_format_archive_url')) { define('dc_format_archive_url','?%s/%02d'); }
	if (!defined('dc_format_day_url')) { define('dc_format_day_url','?%s/%02d/%02d'); }
}
else
{
	if (!defined('dc_format_post_url')) { define('dc_format_post_url','%04d/%02d/%02d/%d-%s'); }
	if (!defined('dc_format_cat_url')) { define('dc_format_cat_url','%s'); }
	if (!defined('dc_format_archive_url')) { define('dc_format_archive_url','%s/%02d'); }
	if (!defined('dc_format_day_url')) { define('dc_format_day_url','%s/%02d/%02d'); }
}

# Chargement des locales
if (!empty($_SESSION['sess_user_lang'])) {
	define('DC_LANG',$_SESSION['sess_user_lang']);
} else {
	define('DC_LANG',dc_default_lang);
}

require_once dirname(__FILE__).'/libs/lib.l10n.php';
l10n::init();

# On vrifier si le fichie UPDATE est modifiable
define('DC_UPDATE_FILE',dirname(__FILE__).'/../conf/UPDATE');

if (defined('DC_UPDATE_FILE') && is_writable(DC_UPDATE_FILE)) {
	define('DC_UPDATE_FILE_W',true);
}

# On initialise DC_CACHE_DIR uniquement si on a le fichier update et le dossier
# de cache en criture
if (defined('DC_UPDATE_FILE_W') && DC_UPDATE_FILE
&& is_writable(dirname(__FILE__).'/../cache')) {
	define('DC_CACHE_DIR',dirname(__FILE__).'/../cache');
}

# Rpertoire share
define('DC_SHARE_DIR',dirname(__FILE__).'/../share');
?>