<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2004 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

/**
@proto doc

!!!Fonctionnement des gabarits

!!Introduction

Le systme de modle de page de DotClear n'est pas ce qui se fait de plus
simple  l'usage mais reste abordable pour peu de bien lire la
documentation.

Le fonctionnement est trs simple, il s'agit de fonctions PHP qui se
chargent d'afficher l'information qu'on lui demande.

Parfois un motif est utilis pour formater l'information affiche. Ce motif
constitue une marque de substitution, gnralement identifie par %s. Pour de
plus amples dtails, suivrent la documentation de la fonction
??PHP|PHP Hypertext Processor??,
[sprintf|http://fr2.php.net/manual/fr/function.sprintf.php].
Pour chaque fonction utilisant un motif, nous expliquerons comment le remplir.
*/

/**
@proto doc

!! Les fonctions informatives

Les fonctions suivantes permettent d'afficher des renseignements divers sur
le blog ou les billets.
*/


/**
Fonction affichant une information sur le blog.
La proprit __name__ peut prendre les valeurs suivantes :

* name : non du weblogue
* theme : chemin vers le rpertoire du thme
* img : chemin vers les images
* url : URL de la home page du blog
* rss : chemin vers le fil RSS
* atom : chemin vers le fil Atom
* search : chemin de l'action pour le moteur de rechercher
* logo : chemin vers l'image du logo
* encoding : Encodage des caractres
* lang : langue principale du weblogue

Exemple :

|<h1><?php dcInfo(); ?></h1>
|
|<a href="<?php dcInfo('rss'); ?>">fil rss</a>

@proto 	function  	 dcInfo

@param 	string name 	Nom de la proprit  afficher 	('name')
*/
function dcInfo($name='name')
{
	switch ($name)
	{
		case 'theme' : echo $GLOBALS['theme_uri'].dc_theme; break;
		case 'img' : echo $GLOBALS['img_path']; break;
		case 'url' : echo dc_blog_url; break;
		case 'rss' : echo dc_blog_rss; break;
		case 'atom' : echo dc_blog_atom; break;
		case 'search' : echo dc_blog_url; break;
		case 'logo' : echo dc_app_url.'/ecrire/images/dotclear_pw.png'; break;
		case 'encoding' : echo dc_encoding; break;
		case 'lang' : echo dc_default_lang; break;
		default : echo dc_blog_name;
	}
}

/**
Cette fonction affiche la date du jour. Elle est utilise dans la boucle
des billets et n'affiche la date que lors du premier billet du jour. Cela
permet d'afficher la date du jour au dessus de plusieurs billets du mme
jour.

On peut entourer la date de marqueur ou de texte grce  la chane
de substitution __s__ passe en argument. Par exemple:

|<?php dcDayDate('<h2>%s</h2>'); ?>

@proto function dcDayDate

@param string s Chaine de substition ('%s')
*/
function dcDayDate($s='%s')
{
	if ($GLOBALS['news']->firstPostOfDay())
	{
		printf($s,$GLOBALS['news']->getLDate());
	}
}

/**
Cette fonction affiche un calendrier contextuel (mois, anne, jour).
Le calendrier est un tableau dans une balise <div> dont la classe
??CSS|Cascading Style Sheet??
est ''cal''. Les nom des jours sont indiqus avec des cellules d'en-tte
(th) et le titre
avec (caption).

Exemple d'utilisation :

|<?php dcCalendar(); ?>

@proto function dcCalendar
@param string  block Chaine de substitution pour pour le tableau ('<div class="cal"><table summary="calendrier">%s</table></div>')
*/
function dcCalendar($block='<div class="cal"><table summary="calendrier">%s</table></div>')
{
	global $year,$month,$day,$cat_id,$lang;
	
	echo $GLOBALS['blog']->xCalendar($year,$month,$day,$cat_id,$lang,$block);
}

/**
Cette fonction affiche les liens (link) dans l'en-tte du fichier HTML.
Elle gnre automatiquement les liens de naviguation dans le blog. Il
suffit de la placer dans l'en-tte du document :

|<head>
|<?php dcHeadLinks(); ?>
|</head>

@proto function dcHeadLinks
*/
function dcHeadLinks()
{
	global $blog, $cat_id, $rs_cat;
	
	echo dcPostNext(1,'<link rel="next" href="%3$s" title="%2$s" />'."\n");
	echo dcPostNext(-1,'<link rel="previous" href="%3$s" title="%2$s" />'."\n");
	
	if (!$rs_cat->isEmpty() && !$cat_id)
	{
		while (!$rs_cat->EOF())
		{
			if ($rs_cat->f('nb_post') > 0)
			{
				$id = $rs_cat->f('cat_libelle_url');
				$libelle = $rs_cat->f('cat_libelle');
				$lien = sprintf($blog->front_url['cat'],$id);
				
				echo '<link rel="section" href="'.$lien.'" title="'.$libelle.'" />'."\n";
			}
			$rs_cat->moveNext();
		}
		$rs_cat->moveStart();
	}
	
	$arry_months = $GLOBALS['arry_months'];
	$comp_url = '';
	if ($cat_id) {
		$comp_url = $cat_id.'/';
	}
	foreach ($arry_months as $ts => $d)
	{
		$titre = dt::str('%B %Y',$ts);
		$url = sprintf($blog->front_url['archive'],$comp_url.date('Y',$ts),date('m',$ts));
		echo '<link rel="archive" href="'.$url.'" title="'.$titre.'" />'."\n";
	}
	
	if ($GLOBALS['mode'] == 'home')
	{
		echo $GLOBALS['news']->getHeadLinks();
	}
}

/**
Cette fonction affiche le titre d'un billet si on est sur une page prsentant
un billet (/blog/yyyy/mm/dd/titre par exemple).

On l'utilisera dans la balise <title> du document. Par exemple:

|<title><?php dcSinglePostTitle(); ?></title>

@proto function dcSinglePostTitle

@param string s Chane de substitution ('%s')
*/
function dcSinglePostTitle($s='%s - ')
{
	if ($GLOBALS['mode'] == 'post') {
		printf($s,$GLOBALS['news']->f('post_titre'));
	}
}

/**
Cette fonction affiche le nom de la catgorie s'il y a lieu de l'afficher. On peut
l'utiliser dans le titre, comme __dcSinglePostTitle__.

@proto function dcSingleCatTitle
@param string s Chane de substitution
*/
function dcSingleCatTitle($s='%s - ')
{
	if ($GLOBALS['cat_id'] != '') {
		printf($s,$GLOBALS['news']->f('cat_libelle'));
	}
}

/**
Cette fonction affiche le mois et l'anne en cours s'il y a lieu de l'afficher.
S'utilise aussi dans le titre comme __dcSinglePostTitle__.

@proto function dcSingleMonthTitle
@param string s Chane de substitution
*/
function dcSingleMonthTitle($s='%s - ')
{
	if ($GLOBALS['mode'] == 'month') {
		$ts = strtotime($GLOBALS['year'].'-'.$GLOBALS['month'].'-01 00:00');
		printf($s,dt::str('%B %Y',$ts));
	}
}

/**
@proto doc

! Exemples d'usage des fonctions pour la balise <title>

Voici un exemple de commun de balise <title>  partir des fonctions prcdentes :

|<title><?php dcSinglePostTitle('%s - ').dcSingleCatTitle('%s - ').
|dcSingleMonthTitle('%s - ').dcInfo(); ?></title>
*/



/**
Cette fonction affiche une liste des catgories avec les liens pour y
accder. La liste gnre est une liste non ordonne (<ul>), il est donc
trs simple de la mettre en forme par la suite.

@proto function dcCatList
@param string  block Chaine de substitution pour pour la liste ('<ul>%s</ul>')
@param string  item  Chaine de substitution pour un lment ('<li>%s</li>')
*/
function dcCatList($block='<ul>%s</ul>',$item='<li>%s</li>')
{
	global $rs_cat, $cat_id, $lang, $blog;
	
	$comp_url = '';
	
	if ($lang) {
		$comp_url = $lang.'/';
	}
	
	if (!$rs_cat->isEmpty())
	{
		$res = '';
		
		while (!$rs_cat->EOF())
		{
			if ($rs_cat->f('nb_post') > 0)
			{
				$id = $rs_cat->f('cat_libelle_url');
				$libelle = $rs_cat->f('cat_libelle');
				
				$lien = '<a href="'.
				sprintf($blog->front_url['cat'],$comp_url.$id).
				'">'.$libelle.'</a>';
				
				if ($cat_id == $id) {
					$lien = '<strong>'.$lien.'</strong>';
				}
				
				$res .= sprintf($item,$lien);
			}
			$rs_cat->moveNext();
		}
		$rs_cat->moveStart();
		
		printf($block,$res);
	}
}

/**
Cette fonction affiche la liste des mois contenant les archives.
Si on se trouve dans une catgorie, seuls les mois de cette catgorie
seront affichs.

@proto function dcMonthsList
@param string  block Chaine de substitution pour pour la liste ('<ul>%s</ul>')
@param string  item  Chaine de substitution pour un lment ('<li>%s</li>')
*/
function dcMonthsList($block='<ul>%s</ul>',$item='<li>%s</li>')
{
	global $arry_months, $month, $year, $cat_id, $lang, $blog;
	
	$comp_url = '';
	
	if ($lang) {
		$comp_url .= $lang.'/';
	}
	
	if($cat_id) {
		$comp_url .= $cat_id.'/';
	}
	
	$res = '';
	
	foreach($arry_months as $ts => $d)
	{
		$titre = dt::str('%B %Y',$ts);
		
		$url = sprintf($blog->front_url['archive'],$comp_url.date('Y',$ts),date('m',$ts));
		$lien = '<a href="'.$url.'">%s</a>';
		
		$liClass = '';
		
		if($year == date('Y',$ts) && $month == date('m',$ts)) {
			$lien = '<strong>'.$lien.'</strong>';
		}
		
		$res .= sprintf($item,sprintf($lien,$titre));
	}
	
	printf($block,$res);
}

/**
Cette fonction affiche une liste des billets slectionns, avec simplement
le titre et un lien vers le billet. L'affichage par dfaut produira une liste,
vous pouvez l'appeler tout simplement par @@dcSelection()@@.

@proto function dcSelection

@param string  block Chaine de substitution pour pour la liste ('<ul>%s</ul>')
@param string  item  Chaine de substitution pour un lment ('<li><a href="%2$s">%1$s</a></li>')
@param integer limit Nombre de titres  afficher (ilimit)
*/
function dcSelection($block='<ul>%s</ul>',$item='<li><a href="%2$s">%1$s</a></li>',$limit=NULL)
{
	global $blog;
	
	$rs = $blog->getLastNews($limit,'','post_dt DESC',true);
	
	if (!$rs->isEmpty()) {
		$res = '';
		while (!$rs->EOF()) {
			$res .= sprintf($item,$rs->f('post_titre'),$rs->getPermURL());
			$rs->moveNext();
		}
		printf($block,$res);
	}
}

/**
Cette fonction affiche la chane de recherche lorsque qu'une recherche vient d'tre
effectue.

@proto function dcSearchString

@param string s Chane de substitution ('%s')
*/
function dcSearchString($s='%s')
{
	if(!empty($_GET['q'])) {
		printf($s,htmlspecialchars(stripslashes($_GET['q'])));
	}
}


# Billets #################################################
/**
@proto doc

!! Traitement des billets.

Les fonctions suivantes doivent tre utilises uniquement dans un
contexte de billet. Cela signifie qu'on l'utilisera si __$mode__
vaut 'post' ou dans une boucle de billet. Exemple:

|<?php if ($mode == 'post') : ?>
| on peut utiliser les fonctions.
|<?php endif; ?>

L'affichage des listes de billets est gr par une boucle trs simple
 mettre en place. Voici un exemple qui affiche le titre des billets :

|<?php while ($news->fetch()) : ?>
|<h3><?php dcPostTitle(); ?></h3>
|<?php endwhile; ?>

*/

/**
Cette fonction affiche l'URI du billet, son permalien. On l'utilisera dans
l'affichage d'un billet (boucle ou pas). Par exemple:

|<a href="<?php dcPostURL(); ?>">lien permanent</a>

@proto function dcPostURL
*/
function dcPostURL()
{
	echo $GLOBALS['news']->getPermURL();
}

/**
Cette fonction affiche l'ID du billet (son numro identifiant unique).

@proto function dcPostID
*/
function dcPostID()
{
	echo $GLOBALS['news']->f('post_id');
}

/**
Cette fonction affiche le titre d'un billet, avec chane de substitution
possible. Exemple:

|<h2><?php dcPostTitle(); ?></h2>

@proto function dcPostTitle
*/
function dcPostTitle($s='%s')
{
	printf($s,$GLOBALS['news']->f('post_titre'));
}

/**
Dans le contexte du billet, cette fonction affiche le nom de la catgorie
du billet.

@proto function dcPostCatTitle
*/
function dcPostCatTitle()
{
	echo $GLOBALS['news']->f('cat_libelle');
}

/**
Cette fonction affiche l'URL de la catgorie d'un billet. Ne s'utilise que dans
le contexte d'un billet. Par exemple:

|<a href="<?php dcPostCarURL(); ?>"><?php dcPostCatTitle(); ?></a>

@proto function dcPostCatURL
*/
function dcPostCatURL()
{
	echo $GLOBALS['news']->getCatURL();
}

/**
Cette fonction affiche le contenu d'un billet (sans son chap). On peut
limiter le nombre de mots affichs avec le paramre __part__.
Si __part__ vaut 0 alors on affiche tout le billet.

@proto function dcPostContent
@param integer part Nombre de mots  afficher
*/
function dcPostContent($part=0)
{
	global $news;
		
	if ($part > 0) {
		echo $news->blog->getPart($news->f('post_content'),$part);
	} else {
		echo $news->getContent();
	}
}

/**
Cette fonction affiche le chap d'un billet s'il existe, sinon elle
n'affiche rien. Le paramtre __s__ permet d'ajouter des information lors
de l'affichage du chap. Exemple:

|<?php dcPostChapo('<h3>Chap</h3> %s'); ?>

@proto function dcPostChapo
@param string s Chaine de substitution ('%s <hr />')
*/
function dcPostChapo($s='%s <hr />')
{
	printf($s,$GLOBALS['news']->getChapo());
}

/**
Cette fonction affiche le chap du billet s'il y en a un sinon elle affiche
le contenu du billet. Si elle affiche le chap, le paramtre __l__ permet
de dfinir un texte  afficher aprs le chap. Dans le paramtre __l__ la
chane %s indique le lien vers le billet. On pourra donc par exemple faire
ceci :

|<?php dcPostAbstract('%s','<p><a href="%s">lire la suite</a></p>'); ?>

On notera que cette fonction trouve sa place dans un affichage de liste de
billets, plutt que dans l'affichage d'un seul billet.

@proto function dcPostAbstract
@param string s Chane de substitution du chap ('%s')
@param string l Chane affiche aprs le chap ('<p><a href="%s">lire la suite</a></p>')
*/
function dcPostAbstract($s='%s',$l='<p><a href="%s">lire la suite</a></p>')
{
	global $news;
		
	if ($news->f('post_chapo') != '') {
		printf($s,$news->getChapo());
		printf($l,$news->getPermURL());
	} else {
		echo $news->getContent();
	}
}

/**
Cette fonction affiche le nom canonique de l'auteur du billet. Le nom canonique
est dfini en fonction des informations donnes par le rdacteur. Si un pseudo
est prsent, il sera utilis, sinon, le prnom et le nom seront utiliss.

@proto function dcPostAuthor
*/
function dcPostAuthor()
{
	echo $GLOBALS['news']->getUserCN();
}

/**
Cette fonction affiche la date d'un billet. On peut changer le formatage
de la date en changeant le paramtre __format__. Par dfaut, ce paramtre
utilisera le format donn dans la configuration du blog.

Voir [strftime|http://fr2.php.net/manual/fr/function.strftime.php] pour les
formats possible de date.

@proto function dcPostDate
@param string format Masque de formatage de la date ('')
*/
function dcPostDate($format='')
{
	if ($format) {
		echo dt::str($format,strtotime($GLOBALS['news']->f('post_dt')));
	} else {
		echo $GLOBALS['news']->getLDate();
	}
}

/**
Cette fonction affiche l'heure d'un billet en utilisant le format donn dans la
configuration du blog.

@proto function dcPostTime
*/
function dcPostTime($format='')
{
	echo $GLOBALS['news']->getLTime();
}

/**
Cette fonction affiche l'attribut lang="" pour un billet. Vous pouvez le
positionner dans n'importe quel marqueur. Rien n'est affich si la langue
n'est pas prsente.

@proto function dcPostLang
*/
function dcPostLang()
{
	$lang = $GLOBALS['news']->f('post_lang');
	if ($lang != '') {
		echo 'lang="'.$lang.'"';
	}
}

/**
Cette fonction affiche le nombre de commentaires d'un billet.
Les trois arguments permettent de dfinir le texte affich pour
respectivement aucun, un ou plusieurs commentaires. Par exemple:

|<?php dcPostNbComments('aucun commentaire','un commentaire',
|'%s commentaires'); ?>

@proto function dcPostNbComments
@param string zero Texte affich pour 0 commentaire
@param string one Texte affich pour 1 commentaire
@param string more Texte affich plusieurs commentaires
*/
function dcPostNbComments($zero,$one,$more)
{
	$nb = $GLOBALS['news']->f('nb_comment');
	
	if($nb == 0) {
		echo $zero;
	} elseif($nb == 1) {
		echo $one;
	} elseif($nb > 1) {
		printf($more,$nb);
	}
}

/**
Cette fonction affiche le nombre de trackbacks d'un billet.
Les trois arguments permettent de dfinir le texte affich pour
respectivement aucun, un ou plusieurs trackbacks. Par exemple:

|<?php dcPostNbTrackbacks('aucun trackback','un trackback',
|'%s trackbacks'); ?>

@proto function dcPostNbTrackbacks
@param string zero Texte affich pour 0 trackback
@param string one Texte affich pour 1 trackback
@param string more Texte affich plusieurs trackbacks
*/
function dcPostNbTrackbacks($zero,$one,$more)
{
	$nb = $GLOBALS['news']->f('nb_trackback');
	
	if($nb == 0) {
		echo $zero;
	} elseif($nb == 1) {
		echo $one;
	} elseif($nb > 1) {
		printf($more,$nb);
	}
}

/**
Cette fonction permet d'afficher une information sur le billet suivant ou
prcdent. Le paramtre __dir__ indique la direction dans laquelle chercher
le billet (1 pour suivant, -1 pour prcdent). Le paramtre __s__ est une
chane de substitution permettant de formater l'affichage des informations
concernant le billet. Il y a trois paramtres  cette chane, donnant
respectivement l'ID, le titre et l'url du billet suivant ou prcdent. Cette
fonction n'affiche rien si elle ne trouve pas de billet.

On peut l'utiliser pour l'affichage individuel des billets, par exemple:

|<?php dcPostNext(1,'<a href="%3$s" title="%2$s">Billet suivant</a>'); ?>

Ceci affichera un lien vers le billet suivant s'il existe et ayant pour titre le
titre du billet.

@proto function dcPostNext
@param integer dir Direction (1)
@param string s Chane de substitution ('%1$s %2$s %3$s')
*/
function dcPostNext($dir,$s='%1$s %2$s %3$s')
{
	global $blog;
	
	if (empty($GLOBALS['rs_next']) || empty($GLOBALS['rs_next'])) {
		return false;
	}
	
	$rs = ($dir > 0) ? $GLOBALS['rs_next'] : $GLOBALS['rs_prev'];
	
	if (!$rs->isEmpty())
	{
		$id = $rs->f('post_id');
		$titre = $rs->f('post_titre');
		$date = $rs->f('post_dt');
		
		$ts = strtotime($date);
		
		$url = sprintf($blog->front_url['post'],date('Y',$ts),
		date('m',$ts),date('d',$ts),$id,$blog->str2url($titre));
	
		printf($s,$id,$titre,$url);
	}
}

/**
Cette fonction indique si les commentaires sont autoriss pour un billet.
On peut l'utiliser dans un test par exemple.

@proto function dcPostOpenComments
@return boolean
*/
function dcPostOpenComments()
{
	return (boolean) $GLOBALS['news']->openComment();
}

/**
Cette fonction indique si les trackbacks sont autoriss pour un billet.
On peut l'utiliser dans un test par exemple.

@proto function dcPostOpenComments
@return boolean
*/
function dcPostOpenTrackbacks()
{
	return (boolean) $GLOBALS['news']->openTb();
}

/**
Cette fonction affiche l'URI  pinger pour faire un trackback sur un billet.

@proto function dcPostTrackbackURI
*/
function dcPostTrackbackURI()
{	
	echo
	'http://'.$_SERVER['HTTP_HOST'].
	dc_trackback_uri.'?id='.$GLOBALS['news']->f('post_id');
}

/**
Cette fonction affiche le commentaire HTML contenant les informations
RDF permettant de raliser la dcouverte automatique de l'URL de trackback.
On l'utilisera dans l'en-tte du document de prfrence.

@proto function dcPostTrackbackAutoDiscovery
*/
function dcPostTrackbackAutoDiscovery()
{	
	if ($GLOBALS['mode'] == 'post' && $GLOBALS['news']->openTb())
	{
		$tb_url = 'http://'.$_SERVER['HTTP_HOST'].
		dc_trackback_uri.'?id='.$GLOBALS['news']->f('post_id');
		
		echo '<!--'."\n".
		'<rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"'."\n".
		'  xmlns:dc="http://purl.org/dc/elements/1.1/"'."\n".
		'  xmlns:trackback="http://madskills.com/public/xml/rss/module/trackback/">'."\n".
		'<rdf:Description'."\n".
		'  rdf:about="http://'.$_SERVER['HTTP_HOST'].$GLOBALS['news']->getPermURL().'"'."\n".
		'  dc:identifier="http://'.$_SERVER['HTTP_HOST'].$GLOBALS['news']->getPermURL().'"'."\n".
		'  dc:title="'.$GLOBALS['news']->f('post_titre').'"'."\n".
		'  trackback:ping="'.$tb_url.'" />'."\n".
		'</rdf:RDF>'."\n".
		'-->'."\n";
	}
}

# Commentaires ############################################
/**
@proto doc

!!Traitement des commentaires

Le traitement des commentaires est rgis par la mme systme de boucle
que les billets. Les fonctions suivantes ne s'utilisent que dans une
boucle de commentaires sauf __dcCommentFormError__ et __dcCommentFormValue__
qui peuvent tre utiliss partout.

Exemple d'une boucle de commentaires affichant son contenu

|<?php while ($comments->fetch()) : ?>
| <?php dcCommentContent(); ?>
|<?php endwhile; ?>
*/

/**
Cette fonction affiche le contenu d'un commentaire.

@proto function dcCommentContent
*/
function dcCommentContent()
{
	echo $GLOBALS['comments']->xGetContent();
}

/**
Cette fonction affiche un commentaire de type trackback avec le lien vers
l'article dans le corps du commentaire (autour du titre). Sinon, il affiche
que le commentaire comme dcCommentContent().

@proto function dcCommentContentTransform
*/
function dcCommentContentTransform()
{
	dcCommentContent();
}

/**
Cette fonction affiche la date d'un commentaire. On peut changer le formatage
de la date en changeant le paramtre __format__. Par dfaut, ce paramtre
utilisera le format donn dans la configuration du blog.

Voir [strftime|http://fr2.php.net/manual/fr/function.strftime.php] pour les
formats possibles de date.

@proto function dcCommentDate
@param string format Masque de formatage de la date ('')
*/
function dcCommentDate($format='')
{
	 if ($format) {
		echo dt::str($format,strtotime($GLOBALS['comments']->f('comment_dt')));
	} else {
		echo $GLOBALS['comments']->getLDate();
	}
}

/**
Cette fonction affiche l'heure d'un commentaire en utilisant le format donn
dans la configuration du blog.

@proto function dcCommentTime
*/
function dcCommentTime()
{
	echo $GLOBALS['comments']->getLTime();
}

/**
Cette fonction affiche le pseudo de l'auteur d'un commentaire.

@proto function dcCommentAuthor
*/
function dcCommentAuthor()
{
	echo $GLOBALS['comments']->f('comment_auteur');
}

/**
Cette fonction affiche l'ID d'un commentaire

@proto function dcCommentID
*/
function dcCommentID()
{
	echo $GLOBALS['comments']->f('comment_id');
}

/**
Cette fonction affiche le nom de l'auteur avec un lien
vers son adresse email s'il en a laiss une.

@proto function dcCommentAuthorLink
@param string s Chane de substitution
*/
function dcCommentAuthorLink($s='%s')
{
	if (($link = $GLOBALS['comments']->auteurLink()) !== false) {
		printf($s,$link);
	}
}

/**
Cette fonction affiche un lien vers le site de l'auteur d'un commentaire
s'il en a laiss un.

@proto function dcCommentAuthorSite
@param string s Chane de substitution
*/
function dcCommentAuthorSite($s='%s')
{
	if (($link = $GLOBALS['comments']->auteurSite()) !== false) {
		printf($s,$link);
	}
}

/**
Cette fonction affiche la prvisualisation d'un commentaire. Elle affiche les
moticones et le formatage tel qu'il sera affich
*/
function dcCommentPreview()
{
	if (!empty($GLOBALS['in_content'])) {
		if (dc_use_smilies) {
			echo $GLOBALS['blog']->addSmilies($GLOBALS['in_content']);
		} else {
			echo $GLOBALS['in_content'];
		}
	}
}

/**
Cette fonction affiche les erreurs qui ont pu se produire lors de la soumission
d'un commentaire. Il est conseill de la laisser.

@proto function dcCommentFormError
@param string s Chane de substitution
*/
function dcCommentFormError($s='%s')
{
	if (!empty($GLOBALS['form_err'])) {
		printf($s,$GLOBALS['form_err']);
	}
}

/**
Cette fonction affiche la valeur d'une variable pour le formulaire de
commentaire. Elle permet par exemple de rappeler les valeurs en cas d'erreur.
Les valeurs possibles de __var__ sont :

* c_nom : nom
* c_mail : adresse email
* c_site : site web
* c_content : contenu du commentaire

On pourra utiliser par exemple:

|<input name="c_nom" id="c_nom" type="text" size="30" maxlength="255"
|value="<?php dcCommentFormValue('c_nom'); ?>" />

@proto function dcCommentFormValue
@param string var Nom de la variable  afficher
*/
function dcCommentFormValue($var)
{
	echo htmlspecialchars($GLOBALS[$var]);
}

/**
Cette fonction donne l'url vers laquelle on redirige le client une fois
le commentaire post.

@proto function dcCommentFormRedir
*/
function dcCommentFormRedir()
{
	echo util::getPageURL();
}

/**
Cette fonction indique si un commentaire est un trackback.

@proto function dcCommentIsTrackBack
@return boolean 
*/
function dcCommentIsTrackBack()
{
	return (boolean) $GLOBALS['comments']->f('comment_trackback');
}

/**
Cette fonction retourne l'URL du trackback. Il s'agit en fait de l'URL
du site dans le commentaire. Elle fait simplement un test supplmentaire
pour vrifier que le commentaire est bien un trackback.

@proto function dcCommentTrackBackURL
*/
function dcCommentTrackBackURL($s='%s')
{
	if ($GLOBALS['comments']->f('comment_trackback') == 1)
	{
		printf($s,$GLOBALS['comments']->f('comment_site'));
	}
}

# Trackbacks ##############################################
/**
@proto doc

!!Traitement des trackbacks

Le traitement des trackbacks suit le mme fonctionnement que les
commentaires. Les fonctions suivantes ne s'utilisent que dans une
boucle de trackbacks.

Exemple d'une boucle de trackbacks affichant son contenu

|<?php while ($trackbacks->fetch()) : ?>
| <?php dcTBContent(); ?>
|<?php endwhile; ?>
*/

/**
Cette fonction affiche un trackback avec le lien vers
l'article dans le corps du commentaire (autour du titre).

@proto function dcTBContent
*/
function dcTBContent()
{
	$content = $GLOBALS['trackbacks']->xGetContent();
	$link = '<a href="'.$GLOBALS['trackbacks']->auteurSite().'">$2</a>';
	
	echo preg_replace('|(<p><strong>)(.*)(</strong></p>)|msU','$1'.$link.'$3',$content);
}

/**
Cette fonction affiche la date d'un trackback. On peut changer le formatage
de la date en changeant le paramtre __format__. Par dfaut, ce paramtre
utilisera le format donn dans la configuration du blog.

Voir [strftime|http://fr2.php.net/manual/fr/function.strftime.php] pour les
formats possibles de date.

@proto function dcTBDate
@param string format Masque de formatage de la date ('')
*/
function dcTBDate($format='')
{
	 if ($format) {
		echo dt::str($format,strtotime($GLOBALS['trackbacks']->f('comment_dt')));
	} else {
		echo $GLOBALS['trackbacks']->getLDate();
	}
}

/**
Cette fonction affiche l'heure d'un trackback en utilisant le format donn
dans la configuration du blog.

@proto function dcTBTime
*/
function dcTBTime()
{
	echo $GLOBALS['trackbacks']->getLTime();
}

/**
Cette fonction affiche le nom de l'auteur d'un trackback.

@proto function dcTBAuthor
*/
function dcTBAuthor()
{
	echo $GLOBALS['trackbacks']->f('comment_auteur');
}

/**
Cette fonction affiche l'ID d'un trackback

@proto function dcTBID
*/
function dcTBID()
{
	echo $GLOBALS['trackbacks']->f('comment_id');
}
?>