<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2004 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

class auth
{
	function check($level)
	{
		$failed = true;
		
		if (empty($_SESSION['sess_user_id'])) {
			$failed = true;
			$_SESSION['sess_auth_from'] = $_SERVER['REQUEST_URI'];
		} else {
			$con = new connection(DB_USER,DB_PASS,DB_HOST,DB_DBASE);
			
			$blog = new blog($con,DB_PREFIX,NULL,dc_encoding);
					
			$failed = !$blog->checkUser($_SESSION['sess_user_id'],NULL,$level);
			
			$con->close();
			unset($blog);
		}
		
		if ($failed) {
			header('Location: auth.php');
			exit;
		}
	}
	
	function perform($user_id,$user_pwd,$level)
	{
		$con = new connection(DB_USER,DB_PASS,DB_HOST,DB_DBASE);
		$blog = new blog($con,DB_PREFIX,NULL,dc_encoding);
		
		$res = false;
		
		if($blog->checkUser($user_id,$user_pwd,$level) !== false) {
			$rs = $blog->getUser($user_id);
			
			$_SESSION['sess_user_level'] = $rs->field('user_level');
			$_SESSION['sess_user_format']= $rs->field('user_post_format');
			$_SESSION['sess_user_nom'] = $rs->field('user_nom');
			$_SESSION['sess_user_prenom'] = $rs->field('user_prenom');
			$_SESSION['sess_user_pseudo'] = $rs->field('user_pseudo');
			$_SESSION['sess_user_email'] = $rs->field('user_email');
			$_SESSION['sess_user_edit_size'] = $rs->field('user_edit_size');
			$_SESSION['sess_user_pref_cat'] = (integer) $rs->field('user_pref_cat');
			$_SESSION['sess_user_lang'] = $rs->field('user_lang');
			$_SESSION['sess_user_delta'] = $rs->field('user_delta');
			
			if($_SESSION['sess_user_pseudo'] != '')
				$_SESSION['sess_user_cn'] = $_SESSION['sess_user_pseudo'];
			else
				$_SESSION['sess_user_cn'] = trim($_SESSION['sess_user_prenom'].' '.$_SESSION['sess_user_nom']);
			
			$res = true;
			
			$blog->tiggerLog('','','Login',$rs->f('user_id'));
		}
		
		$con->close();
		unset($blog);
		
		return $res;
	}
	
	function userLevel($level)
	{
		return $_SESSION['sess_user_level'] >= $level;
	}
}
?>