<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2004 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/inc/prepend.php';
require dirname(__FILE__).'/../inc/incutio/class.httpClient.php';

auth::check(1);
include dirname(__FILE__).'/inc/connexion.php';

openPopup(__('Entry validation'));

$post_id = (!empty($_GET['post_id'])) ? $_GET['post_id'] : '';

if ($post_id != '') {
	$post = $blog->getPostByID($post_id);
}

echo '<h2>'.__('Entry validation').'</h2>';

if (empty($post) || $post->isEmpty())
{
	echo '<div class="erreur"><p><strong>'.__('Error(s)').' :</strong></p>'.
		'<p>'.__('No entry').'</p></div>';
}
else
{
	flush();
	$http = new HttpClient('www.htmlhelp.com',80);
	$http->setUserAgent('Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.3a) Gecko/20021207');
	$http->useGzip(false);
	$http->setPersistReferers(false);
	
	//$http->setDebug(true);
	/*
	POST /cgi-bin/validate.cgi
	charset : UTF-8
	warnings : yes
	input : yes 
	*/
	
	$chapo = $post->f('post_chapo');
	$content = $post->f('post_content');
	
	$post_content = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" '.
	'"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">'."\n".
	'<html xmlns="http://www.w3.org/1999/xhtml">'."\n".
	'<head>'."\n".
	'<title>validation</title>'."\n".
	'</head>'."\n".
	'<body>'."\n".
	$chapo."\n".
	$content."\n".
	'</body>'."\n".
	'</html>';
	
	$params = array('area' => $post_content,'charset' => dc_encoding);
	
	if ($http->post('/cgi-bin/validate.cgi',$params) !== false)
	{
		$result = $http->getContent();
	
		if (strpos($result,'<p class=congratulations><strong>Congratulations, no errors!</strong></p>'))
		{
			echo '<h3>'.__('Valid entry').'</h3>';
		}
		else
		{
			echo '<h3>'.__('Invalid entry').'</h3>';
			if ($errors = preg_match('#<h2>Errors</h2>[\s]*(<ul>.*</ul>)#msU',$result,$matches))
			{
				echo '<p>'.__('Errors list').'&nbsp;:</p>';
				echo strip_tags($matches[1],'<ul><li><pre><b>');
			}
		}
	}
	else
	{
		echo '<p>Impossible de se connecter au serveur.</p>';
	}
	
	echo '<p class="small">'.sprintf(__('Validation done with %s'),'WDG HTML Validator').'<br />'.
	'http://www.htmlhelp.com/tools/validator/</p>';
	echo '<p><img src="images/wdglogo-small.gif" alt="" /></p>';
}

closePopup();
?>