<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2004 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/inc/prepend.php';
require dirname(__FILE__).'/../inc/libs/lib.image.php';
require dirname(__FILE__).'/../inc/classes/class.multipage.php';

auth::check(1);

$err = array();
$up_dir = $_SERVER['DOCUMENT_ROOT'].'/'.dc_img_url;
$is_writable = false;
$mode = (!empty($_REQUEST['mode'])) ? $_REQUEST['mode'] : '';

$env = (!empty($_GET['env'])) ? $_GET['env'] : 1;

$page_title = __('Manage images');

# On vrifie si le rpertoire existe et est accessible en criture
if(is_dir($up_dir))
{
	if (is_writable($up_dir)) {
		$is_writable = true;
	} else {
		$err[] = sprintf(__('Directory %s is not writable. Check permissions.'),
		'<strong>'.dc_img_url.'</strong>');
	}
}
else
{
	$err[] = sprintf(__('Directory %s does not exist.'),'<strong>'.dc_img_url.'</strong>');
}

# Modification d'une image
if (!empty($_GET['img']) && empty($err))
{
	$img_file = str_replace('..','',$_GET['img']);
	$img_file = $img_file;
	
	if (!file_exists($up_dir.'/'.$img_file))
	{
		$err[] = __('Image does not exist');
	}
	else
	{
		if (!empty($_GET['del']) && $_GET['del'] == 1)
		{
			if (@unlink($up_dir.'/'.$img_file) === false)
			{
				$err[] = __('Unable to delete image');
			}
			else
			{
				@unlink($up_dir.'/thumb/'.md5($img_file).'.jpg');
				
				$msg = __('Image deleted');
				header('Location: uploadimg.php?msg='.rawurlencode($msg).'&mode='.$mode);
				exit();
			}
		}
		elseif(!empty($_GET['thumb']) && $_GET['thumb'] == 1)
		{
			$thumb = $up_dir.'/thumb/'.md5($img_file).'.jpg';
			$thumb=images::cropImg($up_dir.'/'.$img_file, $thumb, 100, 180);
		}
	}
}

# Upload de l'image
if($is_writable && !empty($_FILES['up_img']) && empty($err))
{
	$tmp_file = $_FILES['up_img']['tmp_name'];
	$img_name = $_FILES['up_img']['name'];
	
	if (version_compare(phpversion(),'4.2.0','>=')) {
		$upd_error = $_FILES['up_img']['error'];
	} else {
		$upd_error = 0;
	}
	
	if($upd_error != 0)
	{
		switch ($upd_error) {
			case 1:
			case 2:
				$err[] = __('File size exceeds the authorized limit');
				break;
			case 3:
				$err[] = __('File was only partially uploaded');
				break;
			case 4:
				$err[] = __('No file');
				break; 
		}
	}
	elseif(filesize($tmp_file) > dc_upload_size)
	{
		$err[] = __('File size exceeds the authorized limit'); 
	}
	else
	{	
		if(!getimagesize($tmp_file))
		{
			$err[] = sprintf(__('The file %s is not an image'),
			'<strong>'.$img_name.'</strong>');
		}
		else
		{
			if(@copy($tmp_file,$up_dir.'/'.$img_name))
			{
				# On fait le thumbnail
				$thumb = $up_dir.'/thumb/'.md5($img_name).'.jpg';
				@$thumb=images::cropImg($up_dir.'/'.$img_name, $thumb, 100);
				
				$msg = __('Image uploaded');
				header('Location: uploadimg.php?msg='.rawurlencode($msg).'&mode='.$mode);
				exit();
			}
			else
			{
				$err[] = __('An error occured while uploading the image');
			}
		}
	}
}

if ($mode == 'popup') {
	openPopup($page_title);
} else {
	# Sous menu
	$mySubMenu->addItem(
		__('Back to list of entries'),'index.php','images/ico_retour.png',false);
	
	openPage($page_title);
}

echo '<h2>'.$page_title.'</h2>';

if (count($err) > 0)
{
	echo '<div class="erreur"><p><strong>'.__('Error(s)').' :</strong></p>'.
		'<ul><li>'.implode('</li><li>',$err).'</li></ul></div>';
}
?>

<?php if($is_writable) : ?>
<form enctype="multipart/form-data" action="uploadimg.php" method="post">
<fieldset class="clear"><legend><?php echo __('Upload an image'); ?></legend>
<p><label for="up_img"><?php
echo sprintf(__('Choose a file (max size %s)'),files::size(dc_upload_size)); ?>&nbsp;: </label>
<input name="up_img" id="up_img" type="file" />
<input type="hidden" name="MAX_FILE_SIZE" value="<?php echo dc_upload_size; ?>" />
<input type="hidden" name="mode" value="<?php echo $mode; ?>" />
&nbsp;<input class="submit" type="submit" value="<?php echo __('send'); ?>" /></p>
</fieldset>
</form>

<h3><?php echo __('Your images'); ?></h3>
<?php
$D = dir($up_dir);

$img_list = array();
$i = 0;
while(false !== ($entry = $D->read()))
{
	if($entry != '.' && $entry != '..' && !is_dir($up_dir.'/'.$entry)) {
		 $img_list[$i]['url'] = dc_img_url.$entry;
		 $img_list[$i]['name'] = $entry;
		 $i++;
	}
}

# Ligne pour afficher l'image
function ligne_image($data,$i)
{
	global $mode, $up_dir;
	
	$url = $data['url'];
	$name = $data['name'];
	
	$res = '<div class="ligne">';
		
	if ($mode == 'popup')
	{
		$action_link = '<a href="#" '.
		'onclick="insertImage(window.opener.document,\''.$url.'\'); '.
		'window.close(); return false;">%s</a>';
	}
	else
	{
		$action_link = '<a href="'.$url.'">%s</a>';
	}
	
	if (file_exists($up_dir.'/thumb/'.md5($name).'.jpg'))
	{
		$th = sprintf($action_link,
			'<img class="thumbnail" '.
			'src="'.dc_img_url.'/thumb/'.md5($name).'.jpg" alt="" />');
	}
	else
	{
		$th = __('No thumbnail').' - '.
		'<a href="uploadimg.php?img='.rawurlencode($name).
		'&amp;thumb=1&amp;mode='.$mode.'">'.
		__('Try to create thumbnail').'</a>';
	}
	
	$res .= '<p class="small">'.$th.'</p>'.
			'<p class="small">'.sprintf($action_link,$name).'</a> '.
			'[<strong><a href="uploadimg.php?img='.rawurlencode($name).'&amp;del=1&amp;mode='.$mode.'" '.
			'onclick="return window.confirm(\''.__('Are you sure you want to delete this image?').'\')">'.__('delete').'</a></strong>]<br /> '.
			'<strong>'.__('link').'</strong> : '.$url.'</p>'.
			'</div>';
	
	return $res;
}

// Afichage
$lum = new multipage($env,'ligne_image',$img_list,0,20);

$lum->setOption('html_block','%s');
$lum->setOption('html_row','%s');
$lum->setOption('html_cell','%s');

$lum->setOption('html_links','<p class="small">'.__('Page(s)').' : %s</p>');
$lum->setOption('html_cur_page','<strong>%s</strong>');

$lum->setOption('html_prev','&lt;'.__('prev. page'));
$lum->setOption('html_next',__('next page').'&gt;');
$lum->setOption('html_prev_grp','...');
$lum->setOption('html_next_grp','...');

$lum->setOption('html_empty','<p><strong>'.__('No file yet').'</strong></p>');

echo $lum->getLinks();
echo $lum->getPage();
echo $lum->getLinks();

?>
<?php endif; ?>

<?php
if ($mode == 'popup') {
	closePopup();
} else {
	closePage();
}
?>